/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryLocalServiceBaseImpl;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksEntryLocalServiceImpl
extends BookmarksEntryLocalServiceBaseImpl {
    public BookmarksEntry addEntry(long userId, long groupId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        Date now = new Date();
        this.validate(url);
        long entryId = this.counterLocalService.increment();
        BookmarksEntry entry = this.bookmarksEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setCreateDate(serviceContext.getCreateDate(now));
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setFolderId(folderId);
        entry.setName(name);
        entry.setUrl(url);
        entry.setComments(comments);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        Indexer indexer = IndexerRegistryUtil.getIndexer(BookmarksEntry.class);
        indexer.reindex((Object)entry);
        return entry;
    }

    public void addEntryResources(BookmarksEntry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BookmarksEntry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(BookmarksEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BookmarksEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void addEntryResources(long entryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, communityPermissions, guestPermissions);
    }

    public void deleteEntries(long groupId, long folderId) throws PortalException, SystemException {
        for (BookmarksEntry entry : this.bookmarksEntryPersistence.findByG_F(groupId, folderId)) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntry(BookmarksEntry entry) throws PortalException, SystemException {
        this.bookmarksEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BookmarksEntry.class.getName(), 4, entry.getEntryId());
        this.assetEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        this.expandoValueLocalService.deleteValues(BookmarksEntry.class.getName(), entry.getEntryId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(BookmarksEntry.class);
        indexer.delete((Object)entry);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.bookmarksEntryPersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, long folderId) throws SystemException {
        return this.bookmarksEntryPersistence.countByG_F(groupId, folderId);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
    }

    public int getFoldersEntriesCount(long groupId, List<Long> folderIds) throws SystemException {
        return this.bookmarksEntryPersistence.countByG_F(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()])));
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.findByGroupId(groupId, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) throws SystemException {
        EntryModifiedDateComparator orderByComparator = new EntryModifiedDateComparator();
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.findByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.bookmarksEntryPersistence.findByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupEntriesCount(long groupId) throws SystemException {
        return this.bookmarksEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.countByGroupId(groupId);
        }
        return this.bookmarksEntryPersistence.countByG_U(groupId, userId);
    }

    public List<BookmarksEntry> getNoAssetEntries() throws SystemException {
        return this.bookmarksEntryFinder.findByNoAssets();
    }

    public BookmarksEntry openEntry(long userId, long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        entry.setVisits(entry.getVisits() + 1);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        this.assetEntryLocalService.incrementViewCounter(userId, BookmarksEntry.class.getName(), entryId);
        return entry;
    }

    public void updateAsset(long userId, BookmarksEntry entry, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUuid(), assetCategoryIds, assetTagNames, true, null, null, null, null, "text/plain", entry.getName(), entry.getComments(), null, entry.getUrl(), 0, 0, null, false);
    }

    public BookmarksEntry updateEntry(long userId, long entryId, long groupId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        this.validate(url);
        entry.setModifiedDate(serviceContext.getModifiedDate(null));
        entry.setFolderId(folderId);
        entry.setName(name);
        entry.setUrl(url);
        entry.setComments(comments);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        Indexer indexer = IndexerRegistryUtil.getIndexer(BookmarksEntry.class);
        indexer.reindex((Object)entry);
        return entry;
    }

    protected long getFolder(BookmarksEntry entry, long folderId) throws SystemException {
        BookmarksFolder newFolder;
        if (entry.getFolderId() != folderId && folderId != 0L && ((newFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(folderId)) == null || entry.getGroupId() != newFolder.getGroupId())) {
            folderId = entry.getFolderId();
        }
        return folderId;
    }

    protected void validate(String url) throws PortalException {
        if (!Validator.isUrl((String)url)) {
            throw new EntryURLException();
        }
    }
}

