/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetCategoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AssetCategoryServiceHttp.class);

    public static AssetCategory addCategory(HttpPrincipal httpPrincipal, long parentCategoryId, Map<Locale, String> titleMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "addCategory", new Class[]{Long.TYPE, Map.class, Long.TYPE, String[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentCategoryId, titleMap, vocabularyId, categoryProperties, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "deleteCategory", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetCategory> getCategories(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "getCategories", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetCategory getCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "getCategory", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetCategory> getChildCategories(HttpPrincipal httpPrincipal, long parentCategoryId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "getChildCategories", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentCategoryId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetCategory> getVocabularyCategories(HttpPrincipal httpPrincipal, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "getVocabularyCategories", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{vocabularyId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetCategory> getVocabularyRootCategories(HttpPrincipal httpPrincipal, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "getVocabularyRootCategories", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{vocabularyId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static JSONArray search(HttpPrincipal httpPrincipal, long groupId, String name, String[] categoryProperties, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "search", new Class[]{Long.TYPE, String.class, String[].class, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, categoryProperties, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (JSONArray)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetCategory updateCategory(HttpPrincipal httpPrincipal, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetCategoryServiceUtil.class.getName(), "updateCategory", new Class[]{Long.TYPE, Long.TYPE, Map.class, Long.TYPE, String[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId, parentCategoryId, titleMap, vocabularyId, categoryProperties, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

