/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.Validator;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.TextMimeType;
import eu.medsea.mimeutil.detector.MagicMimeMimeDetector;
import eu.medsea.util.EncodingGuesser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.activation.MimetypesFileTypeMap;

public class MimeTypesImpl
implements MimeTypes {
    private static Log _log = LogFactoryUtil.getLog(MimeTypesImpl.class);
    private MimetypesFileTypeMap _mimeTypes = new MimetypesFileTypeMap();

    public MimeTypesImpl() {
        MimeUtil.registerMimeDetector((String)MagicMimeMimeDetector.class.getName());
        HashSet<String> encodings = new HashSet<String>();
        encodings.add("UTF-8");
        encodings.add(System.getProperty("file.encoding"));
        EncodingGuesser.setSupportedEncodings(encodings);
    }

    public String getContentType(File file) {
        try {
            return this.getContentType(new FileInputStream(file), file.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.getContentType(file.getName());
        }
    }

    public String getContentType(InputStream inputStream, String fileName) {
        String contentTypeByFileName;
        String contentType = this.getContentType(fileName);
        if (!contentType.equals("application/octet-stream")) {
            return contentType;
        }
        ArrayList mimeTypes = new ArrayList(MimeUtil.getMimeTypes((InputStream)inputStream));
        MimeType mimeType = (MimeType)mimeTypes.get(0);
        if (mimeTypes.size() > 1 && mimeType instanceof TextMimeType) {
            mimeType = (MimeType)mimeTypes.get(1);
        }
        if ((contentType = String.valueOf(mimeType.getMediaType()) + "/" + mimeType.getSubType()).equals("application/octet-stream")) {
            contentType = this.getContentType(fileName);
        } else if (contentType.equals("application/zip") && (contentTypeByFileName = this.getContentType(fileName)).contains("vnd.openxmlformats")) {
            contentType = contentTypeByFileName;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Content type " + contentType + " returned for " + fileName));
        }
        return contentType;
    }

    public String getContentType(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return "application/octet-stream";
        }
        if (!fileName.contains(".")) {
            fileName = "." + fileName;
        }
        String contentType = this._mimeTypes.getContentType(fileName);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Content type " + contentType + " returned for file name " + fileName));
        }
        return contentType;
    }
}

