/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpImpl
implements Http {
    private static final String _DEFAULT_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
    private static final int _MAX_CONNECTIONS_PER_HOST = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".max.connections.per.host"), (int)2);
    private static final int _MAX_TOTAL_CONNECTIONS = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".max.total.connections"), (int)20);
    private static final String _NON_PROXY_HOSTS = SystemProperties.get((String)"http.nonProxyHosts");
    private static final String _PROXY_AUTH_TYPE = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.auth.type"));
    private static final String _PROXY_HOST = GetterUtil.getString((String)SystemProperties.get((String)"http.proxyHost"));
    private static final String _PROXY_NTLM_DOMAIN = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.ntlm.domain"));
    private static final String _PROXY_NTLM_HOST = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.ntlm.host"));
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.password"));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)SystemProperties.get((String)"http.proxyPort"));
    private static final String _PROXY_USERNAME = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.username"));
    private static final String _TEMP_SLASH = "_LIFERAY_TEMP_SLASH_";
    private static final int _TIMEOUT = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".timeout"), (int)5000);
    private static Log _log = LogFactoryUtil.getLog(HttpImpl.class);
    private static ThreadLocal<javax.servlet.http.Cookie[]> _cookies = new ThreadLocal();
    private HttpClient _client = new HttpClient();
    private Pattern _nonProxyHostsPattern;
    private HttpClient _proxyClient = new HttpClient();
    private Credentials _proxyCredentials;

    public HttpImpl() {
        if (Validator.isNotNull((String)_NON_PROXY_HOSTS)) {
            String nonProxyHostsRegEx = _NON_PROXY_HOSTS;
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\.", "\\\\.");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\*", ".*?");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\|", ")|(");
            nonProxyHostsRegEx = "(" + nonProxyHostsRegEx + ")";
            this._nonProxyHostsPattern = Pattern.compile(nonProxyHostsRegEx);
        }
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setParameter("maxConnectionsPerHost", (Object)new Integer(_MAX_CONNECTIONS_PER_HOST));
        params.setParameter("maxTotalConnections", (Object)new Integer(_MAX_TOTAL_CONNECTIONS));
        params.setConnectionTimeout(_TIMEOUT);
        params.setSoTimeout(_TIMEOUT);
        this._client.setHttpConnectionManager((HttpConnectionManager)httpConnectionManager);
        this._proxyClient.setHttpConnectionManager((HttpConnectionManager)httpConnectionManager);
        if (this.hasProxyConfig() && Validator.isNotNull((String)_PROXY_USERNAME)) {
            ArrayList<String> authPrefs = new ArrayList<String>();
            if (_PROXY_AUTH_TYPE.equals("username-password")) {
                this._proxyCredentials = new UsernamePasswordCredentials(_PROXY_USERNAME, _PROXY_PASSWORD);
                authPrefs.add("Basic");
                authPrefs.add("Digest");
                authPrefs.add("NTLM");
            } else if (_PROXY_AUTH_TYPE.equals("ntlm")) {
                this._proxyCredentials = new NTCredentials(_PROXY_USERNAME, _PROXY_PASSWORD, _PROXY_NTLM_HOST, _PROXY_NTLM_DOMAIN);
                authPrefs.add("NTLM");
                authPrefs.add("Basic");
                authPrefs.add("Digest");
            }
            this._proxyClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        }
    }

    public String addParameter(String url, String name, boolean value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, double value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, int value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, long value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, short value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        String anchor = "";
        int pos = url.indexOf(35);
        if (pos != -1) {
            anchor = url.substring(pos);
            url = url.substring(0, pos);
        }
        if (url.indexOf(63) == -1) {
            url = String.valueOf(url) + "?";
        }
        if (!url.endsWith("?") && !url.endsWith("&")) {
            url = String.valueOf(url) + "&";
        }
        return String.valueOf(url) + name + "=" + this.encodeURL(value) + anchor;
    }

    public String decodePath(String path) {
        path = StringUtil.replace((String)path, (String)"/", (String)_TEMP_SLASH);
        path = this.decodeURL(path, true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    public String decodeURL(String url) {
        return this.decodeURL(url, false);
    }

    public String decodeURL(String url, boolean unescapeSpace) {
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return "";
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
            if (unescapeSpace) {
                url = StringUtil.replace((String)url, (String)"%20", (String)"+");
            }
            return url;
        }
        catch (UnsupportedEncodingException uee) {
            _log.error((Object)uee, (Throwable)uee);
            return "";
        }
    }

    public void destroy() {
        MultiThreadedHttpConnectionManager.shutdownAll();
    }

    public String encodePath(String path) {
        path = StringUtil.replace((String)path, (String)"/", (String)_TEMP_SLASH);
        path = this.encodeURL(path, true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, false);
    }

    public String encodeURL(String url, boolean escapeSpaces) {
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return "";
        }
        try {
            url = URLEncoder.encode(url, "UTF-8");
            if (escapeSpaces) {
                url = StringUtil.replace((String)url, (String)"+", (String)"%20");
            }
            return url;
        }
        catch (UnsupportedEncodingException uee) {
            _log.error((Object)uee, (Throwable)uee);
            return "";
        }
    }

    public String fixPath(String path) {
        return this.fixPath(path, true, true);
    }

    public String fixPath(String path, boolean leading, boolean trailing) {
        if (path == null) {
            return "";
        }
        if (leading) {
            path = path.replaceAll("^/+", "");
        }
        if (trailing) {
            path = path.replaceAll("/+$", "");
        }
        return path;
    }

    public HttpClient getClient(HostConfiguration hostConfig) {
        if (this.isProxyHost(hostConfig.getHost())) {
            return this._proxyClient;
        }
        return this._client;
    }

    public String getCompleteURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (request.getQueryString() != null) {
            sb.append("?");
            sb.append(request.getQueryString());
        }
        String completeURL = sb.toString();
        if (_log.isWarnEnabled() && completeURL.contains("?&")) {
            _log.warn((Object)("Invalid url " + completeURL));
        }
        return completeURL;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return _cookies.get();
    }

    public String getDomain(String url) {
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return url;
    }

    public HostConfiguration getHostConfig(String location) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Location is " + location));
        }
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(new URI(location, false));
        if (this.isProxyHost(hostConfig.getHost())) {
            hostConfig.setProxy(_PROXY_HOST, _PROXY_PORT);
        }
        return hostConfig;
    }

    public String getIpAddress(String url) {
        try {
            URL urlObj = new URL(url);
            InetAddress address = InetAddress.getByName(urlObj.getHost());
            return address.getHostAddress();
        }
        catch (Exception exception) {
            return url;
        }
    }

    public String getParameter(String url, String name) {
        return this.getParameter(url, name, true);
    }

    public String getParameter(String url, String name, boolean escaped) {
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return "";
        }
        String[] parts = StringUtil.split((String)url, (String)"?");
        if (parts.length == 2) {
            String[] params = null;
            params = escaped ? StringUtil.split((String)parts[1], (String)"&amp;") : StringUtil.split((String)parts[1], (String)"&");
            int i = 0;
            while (i < params.length) {
                String[] kvp = StringUtil.split((String)params[i], (String)"=");
                if (kvp.length == 2 && kvp[0].equals(name)) {
                    return kvp[1];
                }
                ++i;
            }
        }
        return "";
    }

    public Map<String, String[]> getParameterMap(String queryString) {
        return this.parameterMapFromString(queryString);
    }

    public String getProtocol(ActionRequest actionRequest) {
        return this.getProtocol(actionRequest.isSecure());
    }

    public String getProtocol(boolean secure) {
        if (!secure) {
            return "http";
        }
        return "https";
    }

    public String getProtocol(HttpServletRequest request) {
        return this.getProtocol(request.isSecure());
    }

    public String getProtocol(RenderRequest renderRequest) {
        return this.getProtocol(renderRequest.isSecure());
    }

    public String getProtocol(String url) {
        int pos = url.indexOf("://");
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return "http";
    }

    public String getQueryString(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return "";
        }
        return url.substring(pos + 1, url.length());
    }

    public String getRequestURL(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public boolean hasDomain(String url) {
        return Validator.isNotNull((String)this.getDomain(url));
    }

    public boolean hasProtocol(String url) {
        int pos = url.indexOf("://");
        return pos != -1;
    }

    public boolean hasProxyConfig() {
        return Validator.isNotNull((String)_PROXY_HOST) && _PROXY_PORT > 0;
    }

    public boolean isNonProxyHost(String host) {
        return this._nonProxyHostsPattern == null || this._nonProxyHostsPattern.matcher(host).matches();
    }

    public boolean isProxyHost(String host) {
        return this.hasProxyConfig() && !this.isNonProxyHost(host);
    }

    public Map<String, String[]> parameterMapFromString(String queryString) {
        String key;
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (Validator.isNull((String)queryString)) {
            return parameterMap;
        }
        LinkedHashMap<String, ArrayList<String>> tempParameterMap = new LinkedHashMap<String, ArrayList<String>>();
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            ArrayList<String> values;
            String token = st.nextToken();
            if (!Validator.isNotNull((String)token)) continue;
            String[] kvp = StringUtil.split((String)token, (String)"=");
            key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if ((values = (ArrayList<String>)tempParameterMap.get(key)) == null) {
                values = new ArrayList<String>();
                tempParameterMap.put(key, values);
            }
            values.add(value);
        }
        for (Map.Entry entry : tempParameterMap.entrySet()) {
            key = (String)entry.getKey();
            List values = (List)entry.getValue();
            parameterMap.put(key, values.toArray(new String[values.size()]));
        }
        return parameterMap;
    }

    public String parameterMapToString(Map<String, String[]> parameterMap) {
        return this.parameterMapToString(parameterMap, true);
    }

    public String parameterMapToString(Map<String, String[]> parameterMap, boolean addQuestion) {
        StringBundler sb = new StringBundler();
        if (parameterMap.size() > 0) {
            if (addQuestion) {
                sb.append("?");
            }
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                String[] values;
                String name = entry.getKey();
                String[] stringArray = values = entry.getValue();
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    sb.append(name);
                    sb.append("=");
                    sb.append(this.encodeURL(value));
                    sb.append("&");
                    ++n2;
                }
            }
            if (sb.index() > 1) {
                sb.setIndex(sb.index() - 1);
            }
        }
        return sb.toString();
    }

    public String protocolize(String url, ActionRequest actionRequest) {
        return this.protocolize(url, actionRequest.isSecure());
    }

    public String protocolize(String url, boolean secure) {
        if (secure) {
            if (url.startsWith("http://")) {
                return StringUtil.replace((String)url, (String)"http://", (String)"https://");
            }
        } else if (url.startsWith("https://")) {
            return StringUtil.replace((String)url, (String)"https://", (String)"http://");
        }
        return url;
    }

    public String protocolize(String url, HttpServletRequest request) {
        return this.protocolize(url, request.isSecure());
    }

    public String protocolize(String url, RenderRequest renderRequest) {
        return this.protocolize(url, renderRequest.isSecure());
    }

    public String removeDomain(String url) {
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos > 0) {
            return url.substring(pos);
        }
        return url;
    }

    public String removeParameter(String url, String name) {
        int pos = url.indexOf(63);
        if (pos == -1) {
            return url;
        }
        String anchor = "";
        int anchorPos = url.indexOf(35);
        if (anchorPos != -1) {
            anchor = url.substring(anchorPos);
            url = url.substring(0, anchorPos);
        }
        StringBundler sb = new StringBundler();
        sb.append(url.substring(0, pos + 1));
        StringTokenizer st = new StringTokenizer(url.substring(pos + 1, url.length()), "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!Validator.isNotNull((String)token)) continue;
            String[] kvp = StringUtil.split((String)token, (String)"=");
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if (key.equals(name)) continue;
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("&");
        }
        url = StringUtil.replace((String)sb.toString(), (String)"&&", (String)"&");
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return String.valueOf(url) + anchor;
    }

    public String removeProtocol(String url) {
        if (url.startsWith("http://")) {
            return url.substring("http://".length(), url.length());
        }
        if (url.startsWith("https://")) {
            return url.substring("https://".length(), url.length());
        }
        return url;
    }

    public String setParameter(String url, String name, boolean value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, double value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, int value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, long value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, short value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        url = this.removeParameter(url, name);
        return this.addParameter(url, name, value);
    }

    public byte[] URLtoByteArray(Http.Options options) throws IOException {
        return this.URLtoByteArray(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookies(), options.getAuth(), options.getBody(), options.getParts(), options.getResponse(), options.isFollowRedirects());
    }

    public byte[] URLtoByteArray(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoByteArray(options);
    }

    public byte[] URLtoByteArray(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoByteArray(options);
    }

    public String URLtoString(Http.Options options) throws IOException {
        return new String(this.URLtoByteArray(options));
    }

    public String URLtoString(String location) throws IOException {
        return new String(this.URLtoByteArray(location));
    }

    public String URLtoString(String location, boolean post) throws IOException {
        return new String(this.URLtoByteArray(location, post));
    }

    public String URLtoString(URL url) throws IOException {
        String xml = null;
        if (url != null) {
            String protocol = url.getProtocol().toLowerCase();
            if (protocol.startsWith("http") || protocol.startsWith("https")) {
                return this.URLtoString(url.toString());
            }
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream();
            byte[] bytes = new byte[512];
            int i = is.read(bytes, 0, 512);
            while (i != -1) {
                ubaos.write(bytes, 0, i);
                i = is.read(bytes, 0, 512);
            }
            xml = new String(ubaos.unsafeGetByteArray(), 0, ubaos.size());
            is.close();
            ubaos.close();
        }
        return xml;
    }

    protected void proxifyState(HttpState state, HostConfiguration hostConfig) {
        Credentials proxyCredentials = this._proxyCredentials;
        String host = hostConfig.getHost();
        if (this.isProxyHost(host) && proxyCredentials != null) {
            AuthScope scope = new AuthScope(_PROXY_HOST, _PROXY_PORT, null);
            state.setProxyCredentials(scope, proxyCredentials);
        }
    }

    protected Cookie toCommonsCookie(javax.servlet.http.Cookie cookie) {
        Cookie commonsCookie = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getMaxAge(), cookie.getSecure());
        commonsCookie.setVersion(cookie.getVersion());
        return commonsCookie;
    }

    protected Cookie[] toCommonsCookies(javax.servlet.http.Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        Cookie[] commonCookies = new Cookie[cookies.length];
        int i = 0;
        while (i < cookies.length) {
            commonCookies[i] = this.toCommonsCookie(cookies[i]);
            ++i;
        }
        return commonCookies;
    }

    protected javax.servlet.http.Cookie toServletCookie(Cookie commonsCookie) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(commonsCookie.getName(), commonsCookie.getValue());
        cookie.setDomain(commonsCookie.getDomain());
        Date expiryDate = commonsCookie.getExpiryDate();
        if (expiryDate != null) {
            int maxAge = (int)(expiryDate.getTime() - System.currentTimeMillis());
            if ((maxAge /= 1000) > -1) {
                cookie.setMaxAge(maxAge);
            }
        }
        cookie.setPath(commonsCookie.getPath());
        cookie.setSecure(commonsCookie.getSecure());
        cookie.setVersion(commonsCookie.getVersion());
        return cookie;
    }

    protected javax.servlet.http.Cookie[] toServletCookies(Cookie[] commonsCookies) {
        if (commonsCookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[commonsCookies.length];
        int i = 0;
        while (i < commonsCookies.length) {
            cookies[i] = this.toServletCookie(commonsCookies[i]);
            ++i;
        }
        return cookies;
    }

    protected byte[] URLtoByteArray(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, Map<String, String> parts, Http.Response response, boolean followRedirects) throws IOException {
        byte[] bytes = null;
        Object httpMethod = null;
        HttpState httpState = null;
        try {
            InputStream is;
            _cookies.set(null);
            if (location == null) {
                byte[] byArray = bytes;
                return byArray;
            }
            if (!location.startsWith("http://") && !location.startsWith("https://")) {
                location = "http://" + location;
            }
            HostConfiguration hostConfig = this.getHostConfig(location);
            HttpClient httpClient = this.getClient(hostConfig);
            if (method == Http.Method.POST || method == Http.Method.PUT) {
                httpMethod = method == Http.Method.POST ? new PostMethod(location) : new PutMethod(location);
                if (body != null) {
                    StringRequestEntity requestEntity = new StringRequestEntity(body.getContent(), body.getContentType(), body.getCharset());
                    EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)httpMethod;
                    entityEnclosingMethod.setRequestEntity((RequestEntity)requestEntity);
                } else if (parts != null && parts.size() > 0 && method == Http.Method.POST) {
                    ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>();
                    for (Map.Entry<String, String> entry : parts.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (value == null) continue;
                        nvpList.add(new NameValuePair(key, value));
                    }
                    NameValuePair[] nvpArray = nvpList.toArray(new NameValuePair[nvpList.size()]);
                    PostMethod postMethod = httpMethod;
                    postMethod.setRequestBody(nvpArray);
                }
            } else {
                httpMethod = method == Http.Method.DELETE ? new DeleteMethod(location) : (method == Http.Method.HEAD ? new HeadMethod(location) : new GetMethod(location));
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpMethod.addRequestHeader(header.getKey(), header.getValue());
                }
            }
            if (!(method == Http.Method.POST || method == Http.Method.PUT && body != null || this._hasRequestHeader((HttpMethod)httpMethod, "Content-Type"))) {
                httpMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            if (!this._hasRequestHeader((HttpMethod)httpMethod, "User-Agent")) {
                httpMethod.addRequestHeader("User-Agent", _DEFAULT_USER_AGENT);
            }
            httpMethod.getParams().setIntParameter("http.socket.timeout", 0);
            httpState = new HttpState();
            if (cookies != null && cookies.length > 0) {
                Cookie[] commonsCookies = this.toCommonsCookies(cookies);
                httpState.addCookies(commonsCookies);
                httpMethod.getParams().setCookiePolicy("compatibility");
            }
            if (auth != null) {
                httpMethod.setDoAuthentication(true);
                httpState.setCredentials(new AuthScope(auth.getHost(), auth.getPort(), auth.getRealm()), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
            }
            this.proxifyState(httpState, hostConfig);
            httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod, httpState);
            Header locationHeader = httpMethod.getResponseHeader("location");
            if (locationHeader != null && !locationHeader.equals((Object)location)) {
                String redirect = locationHeader.getValue();
                if (followRedirects) {
                    byte[] byArray = this.URLtoByteArray(redirect, Http.Method.GET, headers, cookies, auth, body, parts, response, followRedirects);
                    return byArray;
                }
                response.setRedirect(redirect);
            }
            if ((is = httpMethod.getResponseBodyAsStream()) != null) {
                Header contentType;
                Header contentLength = httpMethod.getResponseHeader("Content-Length");
                if (contentLength != null) {
                    response.setContentLength(GetterUtil.getInteger((String)contentLength.getValue()));
                }
                if ((contentType = httpMethod.getResponseHeader("Content-Type")) != null) {
                    response.setContentType(contentType.getValue());
                }
                bytes = FileUtil.getBytes((InputStream)is);
                is.close();
            }
            Header[] headerArray = httpMethod.getResponseHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                response.addHeader(header.getName(), header.getValue());
                ++n2;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            try {
                if (httpState != null) {
                    _cookies.set(this.toServletCookies(httpState.getCookies()));
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            try {
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    private boolean _hasRequestHeader(HttpMethod httpMethod, String name) {
        return httpMethod.getRequestHeaders(name).length != 0;
    }
}

