/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_8_to_6_0_5;

import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.upgrade.v5_2_8_to_6_0_5.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v5_2_8_to_6_0_5.util.DLFileVersionTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryNameUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryTitleUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryVersionUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileRankTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileShortcutTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select * from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                String newName;
                long companyId = rs.getLong("companyId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String portletId = "20";
                long repositoryId = folderId;
                if (repositoryId == 0L) {
                    repositoryId = groupId;
                }
                if ((newName = DLFileEntryNameUpgradeColumnImpl.getNewName(name)).equals(name)) continue;
                DLServiceUtil.updateFile((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)name, (String)newName, (boolean)false);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        DLFileEntryNameUpgradeColumnImpl nameColumn = new DLFileEntryNameUpgradeColumnImpl("name");
        DLFileEntryTitleUpgradeColumnImpl titleColumn = new DLFileEntryTitleUpgradeColumnImpl((UpgradeColumn)nameColumn, "title");
        DLFileEntryVersionUpgradeColumnImpl versionColumn = new DLFileEntryVersionUpgradeColumnImpl("version");
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileEntry", (Object[][])DLFileEntryTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn, titleColumn, versionColumn});
        upgradeTable.setCreateSQL("create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,versionUserId LONG,versionUserName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,name VARCHAR(255) null,extension VARCHAR(75) null,title VARCHAR(255) null,description STRING null,extraSettings TEXT null,version VARCHAR(75) null,size_ LONG,readCount INTEGER)");
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileRank", (Object[][])DLFileRankTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn});
        upgradeTable.setCreateSQL("create table DLFileRank (fileRankId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate DATE null,folderId LONG,name VARCHAR(255) null)");
        upgradeTable.updateTable();
        DLFileEntryNameUpgradeColumnImpl toNameColumn = new DLFileEntryNameUpgradeColumnImpl("toName");
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileShortcut", (Object[][])DLFileShortcutTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{toNameColumn});
        upgradeTable.setCreateSQL("create table DLFileShortcut (uuid_ VARCHAR(75) null,fileShortcutId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,toFolderId LONG,toName VARCHAR(255) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)");
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileVersion", (Object[][])DLFileVersionTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn, versionColumn});
        upgradeTable.setCreateSQL("create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,folderId LONG,name VARCHAR(255) null,extension VARCHAR(75) null,title VARCHAR(75) null,description STRING null,changeLog VARCHAR(75) null,extraSettings VARCHAR(75) null,version VARCHAR(75) null,size_ LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)");
        upgradeTable.updateTable();
        this.updateFileEntries();
        this.updateFileVersions();
    }

    protected long getLatestFileVersionId(long folderId, String name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long fileVersionId = 0L;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select fileVersionId from DLFileVersion where folderId = ? and name = ? order by version desc");
            ps.setLong(1, folderId);
            ps.setString(2, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                fileVersionId = rs.getLong("fileVersionId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return fileVersionId;
    }

    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select uuid_, fileEntryId, groupId, folderId, name, title from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String extension = FileUtil.getExtension((String)title);
                this.runSQL("update DLFileEntry set extension = '" + extension + "' where uuid_ = '" + uuid_ + "' and groupId = " + groupId);
                long fileVersionId = this.getLatestFileVersionId(folderId, name);
                this.runSQL("update ExpandoRow set classPK = " + fileVersionId + " where classPK = " + fileEntryId);
                this.runSQL("update ExpandoValue set classPK = " + fileVersionId + " where classPK = " + fileEntryId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateFileVersion(long fileVersionId, String extension, String title, String description, String extraSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update DLFileVersion set extension = ?, title = ?, description = ?,  extraSettings = ? where fileVersionId = ?");
            ps.setString(1, extension);
            ps.setString(2, title);
            ps.setString(3, description);
            ps.setString(4, extraSettings);
            ps.setLong(5, fileVersionId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select folderId, name, extension, title, description, extraSettings from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String extension = rs.getString("extension");
                String title = rs.getString("title");
                String description = rs.getString("description");
                String extraSettings = rs.getString("extraSettings");
                long fileVersionId = this.getLatestFileVersionId(folderId, name);
                this.updateFileVersion(fileVersionId, extension, title, description, extraSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

