/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class InstanceWrapperBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        new InstanceWrapperBuilder(args[0]);
    }

    public InstanceWrapperBuilder(String xml) {
        try {
            File file = new File(xml);
            Document doc = null;
            try {
                doc = SAXReaderUtil.read((File)file);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
            Element root = doc.getRootElement();
            for (Element instanceWrapper : root.elements("instance-wrapper")) {
                String parentDir = instanceWrapper.attributeValue("parent-dir");
                String srcFile = instanceWrapper.attributeValue("src-file");
                this._createIW(parentDir, srcFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createIW(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] methods = javaClass.getMethods();
        StringBuilder sb = new StringBuilder();
        sb.append("package " + javaClass.getPackage().getName() + ";");
        sb.append("public class " + javaClass.getName() + "_IW {");
        sb.append("public static " + javaClass.getName() + "_IW getInstance() {");
        sb.append("return _instance;");
        sb.append("}\n");
        int i = 0;
        while (i < methods.length) {
            JavaMethod javaMethod = methods[i];
            String methodName = javaMethod.getName();
            if (javaMethod.isPublic() && javaMethod.isStatic()) {
                DocletTag[] docletTags;
                if (methodName.equals("getInstance")) {
                    methodName = "getWrappedInstance";
                }
                if ((docletTags = javaMethod.getTagsByName("deprecated")) != null && docletTags.length > 0) {
                    sb.append("\t/**\n");
                    sb.append("\t * @deprecated\n");
                    sb.append("\t */\n");
                }
                sb.append("public ");
                TypeVariable[] typeParameters = javaMethod.getTypeParameters();
                if (typeParameters.length > 0) {
                    sb.append(" " + typeParameters[0].getGenericValue() + " ");
                }
                sb.append(String.valueOf(this._getTypeGenericsName(javaMethod.getReturns())) + " " + methodName + "(");
                JavaParameter[] parameters = javaMethod.getParameters();
                int j = 0;
                while (j < parameters.length) {
                    JavaParameter javaParameter = parameters[j];
                    sb.append(this._getTypeGenericsName(javaParameter.getType()));
                    if (javaParameter.isVarArgs()) {
                        sb.append("...");
                    }
                    sb.append(" " + javaParameter.getName());
                    if (j + 1 != parameters.length) {
                        sb.append(", ");
                    }
                    ++j;
                }
                sb.append(")");
                Type[] thrownExceptions = javaMethod.getExceptions();
                LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
                int j2 = 0;
                while (j2 < thrownExceptions.length) {
                    Type thrownException = thrownExceptions[j2];
                    newExceptions.add(thrownException.getValue());
                    ++j2;
                }
                if (newExceptions.size() > 0) {
                    sb.append(" throws ");
                    Iterator itr = newExceptions.iterator();
                    while (itr.hasNext()) {
                        sb.append((String)itr.next());
                        if (!itr.hasNext()) continue;
                        sb.append(", ");
                    }
                }
                sb.append("{\n");
                if (!javaMethod.getReturns().getValue().equals("void")) {
                    sb.append("return ");
                }
                sb.append(String.valueOf(javaClass.getName()) + "." + javaMethod.getName() + "(");
                j2 = 0;
                while (j2 < parameters.length) {
                    JavaParameter javaParameter = parameters[j2];
                    sb.append(javaParameter.getName());
                    if (j2 + 1 != parameters.length) {
                        sb.append(", ");
                    }
                    ++j2;
                }
                sb.append(");");
                sb.append("}\n");
            }
            ++i;
        }
        sb.append("private " + javaClass.getName() + "_IW() {");
        sb.append("}");
        sb.append("private static " + javaClass.getName() + "_IW _instance = new " + javaClass.getName() + "_IW();");
        sb.append("}");
        File file = new File(String.valueOf(parentDir) + "/" + StringUtil.replace((String)javaClass.getPackage().getName(), (String)".", (String)"/") + "/" + javaClass.getName() + "_IW.java");
        ServiceBuilder.writeFile(file, sb.toString());
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        int i = 0;
        while (i < type.getDimensions()) {
            dimensions = String.valueOf(dimensions) + "[]";
            ++i;
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(String.valueOf(parentDir) + "/" + srcFile));
        return builder.getClassByName(className);
    }

    private String _getTypeGenericsName(Type type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getValue());
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null) {
            sb.append("<");
            int i = 0;
            while (i < actualTypeArguments.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this._getTypeGenericsName(actualTypeArguments[i]));
                ++i;
            }
            sb.append(">");
        }
        sb.append(this._getDimensions(type));
        return sb.toString();
    }
}

