/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.model.Release;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.ReleaseLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.util.InitUtil;
import java.util.Date;
import org.apache.commons.lang.time.StopWatch;

public class DBUpgrader {
    private static final String _DELETE_TEMP_IMAGES_1 = "delete from Image where imageId IN (SELECT articleImageId FROM JournalArticleImage where tempImage = TRUE)";
    private static final String _DELETE_TEMP_IMAGES_2 = "delete from JournalArticleImage where tempImage = TRUE";
    private static Log _log = LogFactoryUtil.getLog(DBUpgrader.class);

    public static void main(String[] args) {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            InitUtil.initWithSpring();
            DBUpgrader.upgrade();
            DBUpgrader.verify();
            System.out.println("\nSuccessfully completed upgrade process in " + stopWatch.getTime() / 1000L + " seconds.");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void upgrade() throws Exception {
        int buildNumber;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Disable cache registry");
        }
        CacheRegistryUtil.setActive((boolean)false);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Run upgrade process");
        }
        if ((buildNumber = ReleaseLocalServiceUtil.getBuildNumberOrCreate()) < ReleaseInfo.RELEASE_4_2_1_BUILD_NUMBER) {
            String msg = "You must first upgrade to Liferay Portal 4.2.1";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        StartupHelperUtil.upgradeProcess(buildNumber);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        ResourceActionsUtil.init();
        ResourceActionLocalServiceUtil.checkResourceActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource codes");
        }
        ResourceCodeLocalServiceUtil.checkResourceCodes();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete temporary images");
        }
        DBUpgrader._deleteTempImages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Clear cache if upgrade process was run");
        }
        if (StartupHelperUtil.isUpgraded()) {
            MultiVMPoolUtil.clear();
        }
    }

    public static void verify() throws Exception {
        Release release = null;
        try {
            release = ReleaseLocalServiceUtil.getRelease((String)"portal", (int)ReleaseInfo.getBuildNumber());
        }
        catch (PortalException portalException) {
            release = ReleaseLocalServiceUtil.addRelease((String)"portal", (int)ReleaseInfo.getBuildNumber());
        }
        StartupHelperUtil.verifyProcess(release.isVerified());
        if (StartupHelperUtil.isUpgraded()) {
            StartupHelperUtil.updateIndexes();
        }
        boolean verified = StartupHelperUtil.isVerified();
        if (release.isVerified()) {
            verified = true;
        }
        ReleaseLocalServiceUtil.updateRelease((long)release.getReleaseId(), (int)ReleaseInfo.getBuildNumber(), (Date)ReleaseInfo.getBuildDate(), (boolean)verified);
        CacheRegistryUtil.setActive((boolean)true);
    }

    private static void _deleteTempImages() throws Exception {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(_DELETE_TEMP_IMAGES_1);
        db.runSQL(_DELETE_TEMP_IMAGES_2);
    }
}

