/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletResponse;

public class StrutsURLEncoder
implements URLEncoder {
    private static Log _log = LogFactoryUtil.getLog(StrutsURLEncoder.class);
    private String _contextPath;
    private LiferayPortletURL _liferayPortletURL;
    private String _mainPath;
    private PortletMode _portletMode;
    private String _servletMapping = "";
    private WindowState _windowState;

    public static void setParameters(LiferayPortletURL liferayPortletURL, String queryString) {
        String[] params = StringUtil.split((String)queryString, (String)"&");
        int i = 0;
        while (i < params.length) {
            int pos = params[i].indexOf("=");
            if (pos != -1) {
                String param = params[i].substring(0, pos);
                String value = params[i].substring(pos + 1, params[i].length());
                if (param.equals("windowState")) {
                    try {
                        liferayPortletURL.setWindowState(WindowStateFactory.getWindowState((String)value));
                    }
                    catch (WindowStateException wse) {
                        _log.error((Object)wse.getMessage());
                    }
                } else if (param.equals("portletMode")) {
                    try {
                        liferayPortletURL.setPortletMode(PortletModeFactory.getPortletMode((String)value));
                    }
                    catch (PortletModeException pme) {
                        _log.error((Object)pme.getMessage());
                    }
                } else if (param.equals("actionURL")) {
                    String lifecycle = "RENDER_PHASE";
                    if (GetterUtil.getBoolean((String)value)) {
                        lifecycle = "ACTION_PHASE";
                    }
                    liferayPortletURL.setLifecycle(lifecycle);
                } else {
                    liferayPortletURL.setParameter(param, HttpUtil.decodeURL((String)value), true);
                }
            }
            ++i;
        }
    }

    public StrutsURLEncoder(String contextPath, String mainPath, String servletMapping, LiferayPortletURL liferayPortletURL) {
        this._contextPath = contextPath;
        this._mainPath = mainPath;
        this._setServletMapping(servletMapping);
        this._liferayPortletURL = liferayPortletURL;
        this._windowState = liferayPortletURL.getWindowState();
        this._portletMode = liferayPortletURL.getPortletMode();
    }

    public String encodeURL(HttpServletResponse response, String path) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Path " + path));
            _log.debug((Object)("Context path " + this._contextPath));
            _log.debug((Object)("Servlet mapping " + this._servletMapping));
        }
        String encodedURL = path;
        if (path.startsWith("//") || path.startsWith(this._contextPath) || path.startsWith(this._servletMapping)) {
            path = StringUtil.replace((String)path, (String)"&amp;", (String)"&");
            this._liferayPortletURL.setLifecycle("RENDER_PHASE");
            this._liferayPortletURL.setParameters(new HashMap());
            try {
                this._liferayPortletURL.setWindowState(this._windowState);
            }
            catch (WindowStateException windowStateException) {}
            try {
                this._liferayPortletURL.setPortletMode(this._portletMode);
            }
            catch (PortletModeException portletModeException) {}
            String strutsAction = path;
            String queryString = "";
            int pos = strutsAction.indexOf(63);
            if (pos != -1) {
                strutsAction = path.substring(0, pos);
                queryString = path.substring(pos + 1, path.length());
            }
            if (strutsAction.startsWith("c/")) {
                strutsAction = strutsAction.substring(1);
            } else if (strutsAction.startsWith("/c/")) {
                strutsAction = strutsAction.substring(2);
            }
            if (Validator.isNotNull((String)this._contextPath)) {
                strutsAction = strutsAction.substring(this._contextPath.length(), strutsAction.length());
            }
            if (strutsAction.startsWith(this._servletMapping)) {
                strutsAction = strutsAction.substring(this._servletMapping.length(), strutsAction.length());
            }
            if (!strutsAction.startsWith("/")) {
                strutsAction = "/" + strutsAction;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Struts action " + strutsAction));
            }
            this._liferayPortletURL.setParameter("struts_action", strutsAction);
            StrutsURLEncoder.setParameters(this._liferayPortletURL, queryString);
            encodedURL = this._liferayPortletURL.toString();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Encoded portlet URL " + encodedURL));
            }
        }
        return encodedURL;
    }

    private void _setServletMapping(String servletMapping) {
        if (servletMapping != null && servletMapping.endsWith("/*")) {
            int pos = 0;
            if (servletMapping.startsWith(this._mainPath)) {
                pos = this._mainPath.length() - 2;
            }
            this._servletMapping = servletMapping.substring(pos, servletMapping.length() - 1);
        }
    }
}

