/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.PortletPreferencesServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import java.io.IOException;
import java.util.Iterator;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesServiceImpl
extends PortletPreferencesServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceImpl.class);

    public void deleteArchivedPreferences(long portletItemId) throws PortalException, SystemException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(portletItemId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)portletItem.getGroupId(), (String)"MANAGE_ARCHIVED_SETUPS");
        long ownerId = portletItemId;
        int ownerType = 5;
        long plid = 0L;
        String portletId = portletItem.getPortletId();
        this.portletPreferencesLocalService.deletePortletPreferences(ownerId, ownerType, plid, portletId);
        this.portletItemLocalService.deletePortletItem(portletItemId);
    }

    public void restoreArchivedPreferences(long groupId, String name, String portletId, PortletPreferences preferences) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_ARCHIVED_SETUPS");
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(groupId, name, portletId, com.liferay.portal.model.PortletPreferences.class.getName());
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedPrefs = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, portletId);
        this.copyPreferences(archivedPrefs, preferences);
    }

    public void updateArchivePreferences(long userId, long groupId, String name, String portletId, PortletPreferences preferences) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_ARCHIVED_SETUPS");
        PortletItem portletItem = this.portletItemLocalService.updatePortletItem(userId, groupId, name, portletId, com.liferay.portal.model.PortletPreferences.class.getName());
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedPrefs = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, portletId);
        this.copyPreferences(preferences, archivedPrefs);
    }

    protected void copyPreferences(PortletPreferences sourcePreferences, PortletPreferences targetPreferences) throws SystemException {
        try {
            String key;
            Iterator itr = targetPreferences.getMap().keySet().iterator();
            while (itr.hasNext()) {
                try {
                    key = (String)itr.next();
                    targetPreferences.reset(key);
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            itr = sourcePreferences.getMap().keySet().iterator();
            while (itr.hasNext()) {
                try {
                    key = (String)itr.next();
                    targetPreferences.setValues(key, sourcePreferences.getValues(key, new String[0]));
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            targetPreferences.store();
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
        catch (ValidatorException ve) {
            throw new SystemException((Throwable)ve);
        }
    }
}

