/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPrototypeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutPrototypeServiceHttp.class);

    public static LayoutPrototype addLayoutPrototype(HttpPrincipal httpPrincipal, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class.getName(), "addLayoutPrototype", new Class[]{Map.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nameMap, description, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class.getName(), "deleteLayoutPrototype", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutPrototypeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutPrototype getLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class.getName(), "getLayoutPrototype", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutPrototypeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<LayoutPrototype> search(HttpPrincipal httpPrincipal, long companyId, Boolean active, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class.getName(), "search", new Class[]{Long.TYPE, Boolean.class, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, active, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutPrototype updateLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class.getName(), "updateLayoutPrototype", new Class[]{Long.TYPE, Map.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutPrototypeId, nameMap, description, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

