/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.EmailAddressServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailAddressServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(EmailAddressServiceHttp.class);

    public static EmailAddress addEmailAddress(HttpPrincipal httpPrincipal, String className, long classPK, String address, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class.getName(), "addEmailAddress", new Class[]{String.class, Long.TYPE, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, address, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class.getName(), "deleteEmailAddress", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{emailAddressId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static EmailAddress getEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class.getName(), "getEmailAddress", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{emailAddressId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<EmailAddress> getEmailAddresses(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class.getName(), "getEmailAddresses", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static EmailAddress updateEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId, String address, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class.getName(), "updateEmailAddress", new Class[]{Long.TYPE, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{emailAddressId, address, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

