/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.monitoring.MonitoringService;
import com.liferay.portal.monitoring.RequestStatus;
import com.liferay.portal.monitoring.statistics.DataSampleThreadLocal;
import com.liferay.portal.monitoring.statistics.service.ServiceRequestDataSample;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMonitorAdvice
extends ChainableMethodAdvice {
    private static ServiceMonitorAdvice _instance = new ServiceMonitorAdvice();
    private static ThreadLocal<ServiceRequestDataSample> _serviceRequestDataSampleThreadLocal = new AutoResetThreadLocal(ServiceRequestDataSample.class + "._serviceRequestDataSampleThreadLocal");
    private boolean _active;
    private Set<String> _monitoredClasses = new HashSet<String>();
    private Set<MethodKey> _monitoredMethods = new HashSet<MethodKey>();
    private String _monitoringDestinationName;
    private boolean _permissiveMode;

    public static ServiceMonitorAdvice getInstance() {
        return _instance;
    }

    public void addMonitoredClass(String className) {
        this._monitoredClasses.add(className);
    }

    public void addMonitoredMethod(String className, String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(className, methodName, parameterTypes);
            this._monitoredMethods.add(methodKey);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SystemException("Unable to add method", (Throwable)cnfe);
        }
    }

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.SUCCESS);
        }
    }

    @Override
    public void afterThrowing(MethodInvocation methodInvocation, Throwable throwable) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.ERROR);
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!this._active) {
            return null;
        }
        Class<?> classObj = methodInvocation.getThis().getClass();
        Class<?>[] interfaces = classObj.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].isAssignableFrom(MonitoringService.class)) {
                return null;
            }
            ++i;
        }
        if (!this._permissiveMode && !this.isMonitored(methodInvocation)) {
            return null;
        }
        ServiceRequestDataSample serviceRequestDataSample = new ServiceRequestDataSample(methodInvocation);
        serviceRequestDataSample.prepare();
        _serviceRequestDataSampleThreadLocal.set(serviceRequestDataSample);
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            _serviceRequestDataSampleThreadLocal.remove();
            DataSampleThreadLocal.addDataSample(serviceRequestDataSample);
            MessageBusUtil.sendMessage((String)this._monitoringDestinationName, (Object)serviceRequestDataSample);
        }
    }

    public Set<String> getMonitoredClasses() {
        return this._monitoredClasses;
    }

    public Set<MethodKey> getMonitoredMethods() {
        return this._monitoredMethods;
    }

    public String getMonitoringDestinationName() {
        return this._monitoringDestinationName;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isPermissiveMode() {
        return this._permissiveMode;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setMonitoredClasses(Set<String> monitoredClasses) {
        this._monitoredClasses = monitoredClasses;
    }

    public void setMonitoredMethods(Set<MethodKey> monitoredMethods) {
        this._monitoredMethods = monitoredMethods;
    }

    public void setMonitoringDestinationName(String monitoringDestinationName) {
        this._monitoringDestinationName = monitoringDestinationName;
    }

    public void setPermissiveMode(boolean permissiveMode) {
        this._permissiveMode = permissiveMode;
    }

    protected boolean isMonitored(MethodInvocation methodInvocation) {
        Class[] parameterTypes;
        Method method = methodInvocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        String className = declaringClass.getName();
        if (this._monitoredClasses.contains(className)) {
            return true;
        }
        String methodName = method.getName();
        MethodKey methodKey = new MethodKey(className, methodName, parameterTypes = method.getParameterTypes());
        return this._monitoredMethods.contains(methodKey);
    }
}

