/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.LayoutPermissionException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.FriendlyURLNormalizer;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePreAction
extends Action {
    protected File privateLARFile;
    protected File publicLARFile;
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static Log _log = LogFactoryUtil.getLog(ServicePreAction.class);

    public ServicePreAction() {
        this.initImportLARFiles();
    }

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            this.servicePre(request, response);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Running takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void addDefaultLayoutsByLAR(long userId, long groupId, boolean privateLayout, File larFile) throws PortalException, SystemException {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        LayoutLocalServiceUtil.importLayouts((long)userId, (long)groupId, (boolean)privateLayout, parameterMap, (File)larFile);
    }

    protected void addDefaultUserPrivateLayoutByProperties(long userId, long groupId) throws PortalException, SystemException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)true, (long)0L, (String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_TEMPLATE_ID, false);
        int i = 0;
        while (i < 10) {
            String columnId = "column-" + i;
            String portletIds = PropsUtil.get("default.user.private.layout.column-" + i);
            String[] portletIdsArray = StringUtil.split((String)portletIds);
            layoutTypePortlet.addPortletIds(0L, portletIdsArray, columnId, false);
            ++i;
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPrivateLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        if (this.privateLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), true, this.privateLARFile);
        } else {
            this.addDefaultUserPrivateLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void addDefaultUserPublicLayoutByProperties(long userId, long groupId) throws PortalException, SystemException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)0L, (String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        int i = 0;
        while (i < 10) {
            String columnId = "column-" + i;
            String portletIds = PropsUtil.get("default.user.public.layout.column-" + i);
            String[] portletIdsArray = StringUtil.split((String)portletIds);
            layoutTypePortlet.addPortletIds(0L, portletIdsArray, columnId, false);
            ++i;
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPublicLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        if (this.publicLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), false, this.publicLARFile);
        } else {
            this.addDefaultUserPublicLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void deleteDefaultUserPrivateLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)true);
    }

    protected void deleteDefaultUserPublicLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)false);
    }

    protected Object[] getDefaultLayout(HttpServletRequest request, User user, boolean signedIn) throws PortalException, SystemException {
        Group guestGroup;
        List layouts;
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && (layouts = LayoutLocalServiceUtil.getLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return new Object[]{layout, layouts};
        }
        Layout layout = null;
        List layouts2 = null;
        if (signedIn) {
            Group userGroup = user.getGroup();
            layouts2 = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)true, (long)0L);
            if (layouts2.size() == 0) {
                layouts2 = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)false, (long)0L);
            }
            if (layouts2.size() > 0) {
                layout = (Layout)layouts2.get(0);
            }
            if (layout == null) {
                LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
                groupParams.put("usersGroups", new Long(user.getUserId()));
                List groups = GroupLocalServiceUtil.search((long)user.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
                for (Group group : groups) {
                    layouts2 = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L);
                    if (layouts2.size() == 0) {
                        layouts2 = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                    }
                    if (layouts2.size() <= 0) continue;
                    layout = (Layout)layouts2.get(0);
                    break;
                }
            }
        }
        if (layout == null && (layouts2 = LayoutLocalServiceUtil.getLayouts((long)(guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId(), (boolean)false, (long)0L)).size() > 0) {
            layout = (Layout)layouts2.get(0);
        }
        return new Object[]{layout, layouts2};
    }

    protected String getFriendlyURL(String friendlyURL) {
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        return FriendlyURLNormalizer.normalize(friendlyURL);
    }

    protected Object[] getViewableLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws PortalException, SystemException {
        if (layouts == null || layouts.isEmpty()) {
            return new Object[]{layout, layouts};
        }
        boolean hasUpdateLayoutPermission = false;
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) {
            hasUpdateLayoutPermission = true;
        }
        ArrayList<Layout> accessibleLayouts = new ArrayList<Layout>();
        int i = 0;
        while (i < layouts.size()) {
            Layout curLayout = layouts.get(i);
            if (!curLayout.isHidden() && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)curLayout, (String)"VIEW")) {
                if (accessibleLayouts.isEmpty() && !hasUpdateLayoutPermission) {
                    layout = curLayout;
                }
                accessibleLayouts.add(curLayout);
            }
            ++i;
        }
        if (accessibleLayouts.isEmpty()) {
            layouts = null;
            if (!hasUpdateLayoutPermission) {
                SessionErrors.add((HttpServletRequest)request, (String)LayoutPermissionException.class.getName());
            }
        } else {
            layouts = accessibleLayouts;
        }
        return new Object[]{layout, layouts};
    }

    protected Boolean hasPowerUserRole(User user) throws Exception {
        return RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Power User", (boolean)true);
    }

    protected void initImportLARFiles() {
        String privateLARFileName = PropsValues.DEFAULT_USER_PRIVATE_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading private LAR file " + privateLARFileName));
        }
        if (Validator.isNotNull((String)privateLARFileName)) {
            this.privateLARFile = new File(privateLARFileName);
            if (!this.privateLARFile.exists()) {
                _log.error((Object)("Private LAR file " + this.privateLARFile + " does not exist"));
                this.privateLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using private LAR file " + privateLARFileName));
            }
        }
        String publicLARFileName = PropsValues.DEFAULT_USER_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected boolean isViewableCommunity(User user, long groupId, boolean privateLayout, PermissionChecker permissionChecker) throws PortalException, SystemException {
        return this.isViewableGroup(user, groupId, privateLayout, 0L, permissionChecker);
    }

    protected boolean isViewableGroup(User user, long groupId, boolean privateLayout, long layoutId, PermissionChecker permissionChecker) throws PortalException, SystemException {
        Group liveGroup;
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!group.isActive()) {
            return false;
        }
        if (group.isStagingGroup() && !(liveGroup = group.getLiveGroup()).isActive()) {
            return false;
        }
        if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (groupUserId == user.getUserId()) {
                return true;
            }
            User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
            if (!groupUser.isActive()) {
                return false;
            }
            if (privateLayout) {
                return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupUserId, (long[])groupUser.getOrganizationIds(), (String)"UPDATE");
            }
        }
        if (group.isStagingGroup()) {
            if (user.isDefaultUser()) {
                return false;
            }
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"APPROVE_PROPOSAL") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_REVIEWER") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_LAYOUTS") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING") || layoutId > 0L && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        }
        if (!privateLayout) {
            return true;
        }
        if (group.isControlPanel()) {
            return !user.isDefaultUser();
        }
        if (group.isCommunity()) {
            if (GroupLocalServiceUtil.hasUserGroup((long)user.getUserId(), (long)groupId)) {
                return true;
            }
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE")) {
                return true;
            }
        } else {
            if (group.isCompany()) {
                return false;
            }
            if (group.isLayoutPrototype()) {
                return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
            }
            if (group.isLayoutSetPrototype()) {
                return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
            }
            if (group.isOrganization()) {
                long organizationId = group.getOrganizationId();
                if (OrganizationLocalServiceUtil.hasUserOrganization((long)user.getUserId(), (long)organizationId, (boolean)false, (boolean)true, (boolean)false)) {
                    return true;
                }
                if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"UPDATE")) {
                    return true;
                }
                if (!PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
                    List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)user.getUserId(), (boolean)true);
                    for (Organization organization : userOrgs) {
                        for (Organization ancestorOrganization : organization.getAncestors()) {
                            if (organizationId != ancestorOrganization.getOrganizationId()) continue;
                            return true;
                        }
                    }
                }
            } else if (group.isUserGroup() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_LAYOUTS")) {
                return true;
            }
        }
        return false;
    }

    protected List<Layout> mergeAdditionalLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws PortalException, SystemException {
        Group guestGroup;
        if (layout == null || layout.isPrivateLayout()) {
            return layouts;
        }
        long layoutGroupId = layout.getGroupId();
        if (layoutGroupId != (guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId()) {
            Group layoutGroup = GroupLocalServiceUtil.getGroup((long)layoutGroupId);
            UnicodeProperties props = layoutGroup.getTypeSettingsProperties();
            boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)props.getProperty("mergeGuestPublicPages"));
            if (!mergeGuestPublicPages) {
                return layouts;
            }
            List guestLayouts = LayoutLocalServiceUtil.getLayouts((long)guestGroup.getGroupId(), (boolean)false, (long)0L);
            Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, guestLayouts);
            guestLayouts = (List)viewableLayouts[1];
            layouts.addAll(0, guestLayouts);
        } else {
            HttpSession session = request.getSession();
            Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
            if (previousGroupId != null && previousGroupId != layoutGroupId) {
                Group previousGroup = null;
                try {
                    previousGroup = GroupLocalServiceUtil.getGroup((long)previousGroupId);
                }
                catch (NoSuchGroupException nsge) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)nsge);
                    }
                    return layouts;
                }
                UnicodeProperties props = previousGroup.getTypeSettingsProperties();
                boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)props.getProperty("mergeGuestPublicPages"));
                if (!mergeGuestPublicPages) {
                    return layouts;
                }
                List previousLayouts = LayoutLocalServiceUtil.getLayouts((long)previousGroupId, (boolean)false, (long)0L);
                Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, previousLayouts);
                previousLayouts = (List)viewableLayouts[1];
                layouts.addAll(previousLayouts);
            }
        }
        return layouts;
    }

    protected void rememberVisitedGroupIds(HttpServletRequest request, long currentGroupId) {
        String requestURI = GetterUtil.getString((String)request.getRequestURI());
        if (!requestURI.endsWith(_PATH_PORTAL_LAYOUT)) {
            return;
        }
        HttpSession session = request.getSession();
        Long recentGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT");
        Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
        if (recentGroupId == null) {
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
        } else if (recentGroupId != currentGroupId) {
            previousGroupId = new Long(recentGroupId);
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS", (Object)previousGroupId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Current group id " + currentGroupId));
            _log.debug((Object)("Recent group id " + recentGroupId));
            _log.debug((Object)("Previous group id " + previousGroupId));
        }
    }

    protected void servicePre(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletId;
        Portlet portlet;
        List portletIds;
        String colorSchemeId;
        String themeId;
        String i18nLanguageId;
        HttpSession session = request.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        long companyId = company.getCompanyId();
        String cdnHost = null;
        cdnHost = request.isSecure() ? PortalUtil.getCDNHostHttps() : PortalUtil.getCDNHostHttp();
        cdnHost = ParamUtil.getString((HttpServletRequest)request, (String)"cdn_host", (String)cdnHost);
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        String contextPath = PortalUtil.getPathContext();
        String friendlyURLPrivateGroupPath = PortalUtil.getPathFriendlyURLPrivateGroup();
        String friendlyURLPrivateUserPath = PortalUtil.getPathFriendlyURLPrivateUser();
        String friendlyURLPublicPath = PortalUtil.getPathFriendlyURLPublic();
        String imagePath = cdnHost.concat(PortalUtil.getPathImage());
        String mainPath = PortalUtil.getPathMain();
        String i18nPath = (String)request.getAttribute("I18N_PATH");
        if (Validator.isNotNull((String)i18nPath)) {
            if (Validator.isNotNull((String)contextPath)) {
                String i18nContextPath = contextPath.concat(i18nPath);
                friendlyURLPrivateGroupPath = StringUtil.replaceFirst((String)friendlyURLPrivateGroupPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPrivateUserPath = StringUtil.replaceFirst((String)friendlyURLPrivateUserPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPublicPath = StringUtil.replaceFirst((String)friendlyURLPublicPath, (String)contextPath, (String)i18nContextPath);
                mainPath = StringUtil.replaceFirst((String)mainPath, (String)contextPath, (String)i18nContextPath);
            } else {
                friendlyURLPrivateGroupPath = i18nPath.concat(friendlyURLPrivateGroupPath);
                friendlyURLPrivateUserPath = i18nPath.concat(friendlyURLPrivateUserPath);
                friendlyURLPublicPath = i18nPath.concat(friendlyURLPublicPath);
                mainPath = i18nPath.concat(mainPath);
            }
        }
        StringBundler sb = new StringBundler(5);
        sb.append(imagePath);
        sb.append("/company_logo?img_id=");
        sb.append(company.getLogoId());
        sb.append("&t=");
        sb.append(ImageServletTokenUtil.getToken((long)company.getLogoId()));
        String companyLogo = sb.toString();
        Image companyLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)company.getLogoId());
        int companyLogoHeight = companyLogoImage.getHeight();
        int companyLogoWidth = companyLogoImage.getWidth();
        String realCompanyLogo = companyLogo;
        int realCompanyLogoHeight = companyLogoHeight;
        int realCompanyLogoWidth = companyLogoWidth;
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (NoSuchUserException nsue) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsue.getMessage());
            }
            if ((userId = PortalUtil.getUserId((HttpServletRequest)request)) > 0L) {
                session.invalidate();
            }
            return;
        }
        boolean signedIn = false;
        if (user == null) {
            user = company.getDefaultUser();
        } else if (!user.isDefaultUser()) {
            signedIn = true;
        }
        User realUser = user;
        Long realUserId = (Long)session.getAttribute("USER_ID");
        if (realUserId != null && user.getUserId() != realUserId.longValue()) {
            realUser = UserLocalServiceUtil.getUserById((long)realUserId);
        }
        String doAsUserId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
        long refererPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"refererPlid");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)doAsUserLanguageId);
        }
        if (Validator.isNotNull((String)(i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID")))) {
            locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        } else if (locale == null) {
            if (signedIn) {
                locale = user.getLocale();
            } else {
                String languageId = CookieKeys.getCookie(request, "GUEST_LANGUAGE_ID");
                if (Validator.isNotNull((String)languageId)) {
                    locale = LocaleUtil.fromLanguageId((String)languageId);
                }
                if (locale == null && PropsValues.LOCALE_DEFAULT_REQUEST) {
                    locale = request.getLocale();
                }
                if (locale == null) {
                    locale = user.getLocale();
                }
                if (Validator.isNull((String)locale.getCountry())) {
                    locale = LanguageUtil.getLocale((String)locale.getLanguage());
                }
                if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
                    locale = user.getLocale();
                }
            }
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
            LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
        }
        try {
            CookieKeys.validateSupportCookie(request);
        }
        catch (Exception exception) {
            CookieKeys.addSupportCookie(request, response);
        }
        TimeZone timeZone = user.getTimeZone();
        if (timeZone == null) {
            timeZone = company.getTimeZone();
        }
        if (signedIn) {
            this.updateUserLayouts(user);
        }
        Layout layout = null;
        List<Object> layouts = null;
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        } else {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
            if (groupId > 0L && layoutId > 0L) {
                layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            }
        }
        if (layout != null) {
            try {
                boolean isViewableCommunity;
                Group group = layout.getGroup();
                if (!signedIn && PropsValues.AUTH_FORWARD_BY_REDIRECT) {
                    request.setAttribute("REQUESTED_LAYOUT", (Object)layout);
                }
                if (!(isViewableCommunity = this.isViewableGroup(user, layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), permissionChecker)) && group.isStagingGroup()) {
                    layout = null;
                } else {
                    if (!isViewableCommunity) {
                        sb = new StringBundler(6);
                        sb.append("User ");
                        sb.append(user.getUserId());
                        sb.append(" is not allowed to access the ");
                        sb.append(layout.isPrivateLayout() ? "private" : "public");
                        sb.append(" pages of group ");
                        sb.append(layout.getGroupId());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)sb.toString());
                        }
                        throw new PrincipalException(sb.toString());
                    }
                    if (isViewableCommunity && !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) {
                        layout = null;
                    } else if (group.isLayoutPrototype()) {
                        layouts = new ArrayList();
                    } else {
                        layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
                        if (!group.isControlPanel()) {
                            doAsGroupId = 0L;
                        }
                    }
                }
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        if (layout == null) {
            Object[] defaultLayout = this.getDefaultLayout(request, user, signedIn);
            layout = (Layout)defaultLayout[0];
            layouts = (ArrayList)defaultLayout[1];
            request.setAttribute("LAYOUT_DEFAULT", (Object)Boolean.TRUE);
        }
        Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, layouts);
        String layoutSetLogo = null;
        layout = (Layout)viewableLayouts[0];
        layouts = (List)viewableLayouts[1];
        Group group = null;
        if (layout != null && !(group = layout.getGroup()).isControlPanel()) {
            this.rememberVisitedGroupIds(request, group.getGroupId());
        }
        LayoutTypePortlet layoutTypePortlet = null;
        layouts = this.mergeAdditionalLayouts(request, user, permissionChecker, layout, layouts);
        if (layout != null) {
            String typeSettings;
            if (company.isCommunityLogo()) {
                long logoId = 0L;
                LayoutSet layoutSet = layout.getLayoutSet();
                if (layoutSet.isLogo()) {
                    logoId = layoutSet.getLogoId();
                } else {
                    LayoutSet siblingLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layout.getGroupId(), (!layout.isPrivateLayout() ? 1 : 0) != 0);
                    if (siblingLayoutSet.isLogo()) {
                        logoId = siblingLayoutSet.getLogoId();
                    }
                }
                if (logoId > 0L) {
                    sb = new StringBundler(5);
                    sb.append(imagePath);
                    sb.append("/layout_set_logo?img_id=");
                    sb.append(logoId);
                    sb.append("&t=");
                    sb.append(ImageServletTokenUtil.getToken((long)logoId));
                    layoutSetLogo = sb.toString();
                    Image layoutSetLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)logoId);
                    companyLogo = layoutSetLogo;
                    companyLogoHeight = layoutSetLogoImage.getHeight();
                    companyLogoWidth = layoutSetLogoImage.getWidth();
                }
            }
            plid = layout.getPlid();
            layout = (Layout)((LayoutImpl)layout).clone();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null && (typeSettings = layoutClone.get(request, plid)) != null) {
                UnicodeProperties props = new UnicodeProperties(true);
                props.load(typeSettings);
                String stateMax = props.getProperty("state-max");
                String stateMin = props.getProperty("state-min");
                String modeAbout = props.getProperty("mode-about");
                String modeConfig = props.getProperty("mode-config");
                String modeEdit = props.getProperty("mode-edit");
                String modeEditDefaults = props.getProperty("mode-edit-defaults");
                String modeEditGuest = props.getProperty("mode-edit-guest");
                String modeHelp = props.getProperty("mode-help");
                String modePreview = props.getProperty("mode-preview");
                String modePrint = props.getProperty("mode-print");
                layoutTypePortlet.setStateMax(stateMax);
                layoutTypePortlet.setStateMin(stateMin);
                layoutTypePortlet.setModeAbout(modeAbout);
                layoutTypePortlet.setModeConfig(modeConfig);
                layoutTypePortlet.setModeEdit(modeEdit);
                layoutTypePortlet.setModeEditDefaults(modeEditDefaults);
                layoutTypePortlet.setModeEditGuest(modeEditGuest);
                layoutTypePortlet.setModeHelp(modeHelp);
                layoutTypePortlet.setModePreview(modePreview);
                layoutTypePortlet.setModePrint(modePrint);
            }
            request.setAttribute("LAYOUT", (Object)layout);
            request.setAttribute("LAYOUTS", layouts);
            if (layout.isPrivateLayout()) {
                permissionChecker.setCheckGuest(false);
            }
        }
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request);
        long parentGroupId = PortalUtil.getParentGroupId((long)scopeGroupId);
        Theme theme = null;
        ColorScheme colorScheme = null;
        boolean wapTheme = BrowserSnifferUtil.isWap((HttpServletRequest)request);
        if (layout != null && group.isControlPanel()) {
            themeId = PrefsPropsUtil.getString(companyId, "control.panel.layout.regular.theme.id");
            colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)wapTheme);
            if (!wapTheme && theme.isWapTheme()) {
                theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)PropsValues.CONTROL_PANEL_LAYOUT_REGULAR_THEME_ID, (boolean)false);
                colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)false);
            }
        } else if (layout != null) {
            if (wapTheme) {
                theme = layout.getWapTheme();
                colorScheme = layout.getWapColorScheme();
            } else {
                theme = layout.getTheme();
                colorScheme = layout.getColorScheme();
            }
        } else {
            themeId = null;
            colorSchemeId = null;
            if (wapTheme) {
                themeId = ThemeImpl.getDefaultWapThemeId(companyId);
                colorSchemeId = ColorSchemeImpl.getDefaultWapColorSchemeId();
            } else {
                themeId = ThemeImpl.getDefaultRegularThemeId(companyId);
                colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
            }
            theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)wapTheme);
        }
        request.setAttribute("THEME", (Object)theme);
        request.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        boolean themeCssFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
        boolean themeImagesFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"images_fast_load", (boolean)PropsValues.THEME_IMAGES_FAST_LOAD);
        boolean themeJsBarebone = PropsValues.JAVASCRIPT_BAREBONE_ENABLED;
        if (themeJsBarebone && signedIn) {
            themeJsBarebone = false;
        }
        boolean themeJsFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"js_fast_load", (boolean)PropsValues.JAVASCRIPT_FAST_LOAD);
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle", (String)"0");
        boolean isolated = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_isolated");
        String facebookCanvasPageURL = (String)request.getAttribute("FACEBOOK_CANVAS_PAGE_URL");
        boolean widget = false;
        Boolean widgetObj = (Boolean)request.getAttribute("WIDGET");
        if (widgetObj != null) {
            widget = widgetObj;
        }
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setCDNHost(cdnHost);
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setFacebookCanvasPageURL(facebookCanvasPageURL);
        themeDisplay.setWidget(widget);
        themeDisplay.setCompany(company);
        themeDisplay.setCompanyLogo(companyLogo);
        themeDisplay.setCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setRealCompanyLogo(realCompanyLogo);
        themeDisplay.setRealCompanyLogoHeight(realCompanyLogoHeight);
        themeDisplay.setRealCompanyLogoWidth(realCompanyLogoWidth);
        themeDisplay.setUser(user);
        themeDisplay.setRealUser(realUser);
        themeDisplay.setDoAsUserId(doAsUserId);
        themeDisplay.setDoAsUserLanguageId(doAsUserLanguageId);
        themeDisplay.setDoAsGroupId(doAsGroupId);
        themeDisplay.setRefererPlid(refererPlid);
        themeDisplay.setLayoutSetLogo(layoutSetLogo);
        themeDisplay.setLayout(layout);
        themeDisplay.setLayouts(layouts);
        themeDisplay.setPlid(plid);
        themeDisplay.setLayoutTypePortlet(layoutTypePortlet);
        themeDisplay.setScopeGroupId(scopeGroupId);
        themeDisplay.setParentGroupId(parentGroupId);
        themeDisplay.setSignedIn(signedIn);
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setLocale(locale);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setTimeZone(timeZone);
        themeDisplay.setLookAndFeel(contextPath, theme, colorScheme);
        themeDisplay.setThemeCssFastLoad(themeCssFastLoad);
        themeDisplay.setThemeImagesFastLoad(themeImagesFastLoad);
        themeDisplay.setThemeJsBarebone(themeJsBarebone);
        themeDisplay.setThemeJsFastLoad(themeJsFastLoad);
        themeDisplay.setServerName(request.getServerName());
        themeDisplay.setServerPort(request.getServerPort());
        themeDisplay.setSecure(request.isSecure());
        themeDisplay.setLifecycle(lifecycle);
        themeDisplay.setLifecycleAction(lifecycle.equals("1"));
        themeDisplay.setLifecycleRender(lifecycle.equals("0"));
        themeDisplay.setLifecycleResource(lifecycle.equals("2"));
        themeDisplay.setStateExclusive(LiferayWindowState.isExclusive((HttpServletRequest)request));
        themeDisplay.setStateMaximized(LiferayWindowState.isMaximized((HttpServletRequest)request));
        themeDisplay.setStatePopUp(LiferayWindowState.isPopUp((HttpServletRequest)request));
        themeDisplay.setIsolated(isolated);
        themeDisplay.setPathApplet(contextPath.concat("/applets"));
        themeDisplay.setPathCms(contextPath.concat("/cms"));
        themeDisplay.setPathContext(contextPath);
        themeDisplay.setPathFlash(contextPath.concat("/flash"));
        themeDisplay.setPathFriendlyURLPrivateGroup(friendlyURLPrivateGroupPath);
        themeDisplay.setPathFriendlyURLPrivateUser(friendlyURLPrivateUserPath);
        themeDisplay.setPathFriendlyURLPublic(friendlyURLPublicPath);
        themeDisplay.setPathImage(imagePath);
        themeDisplay.setPathJavaScript(cdnHost.concat(contextPath).concat("/html/js"));
        themeDisplay.setPathMain(mainPath);
        themeDisplay.setPathSound(contextPath.concat("/html/sound"));
        themeDisplay.setShowAddContentIcon(false);
        themeDisplay.setShowControlPanelIcon(signedIn);
        themeDisplay.setShowHomeIcon(true);
        themeDisplay.setShowMyAccountIcon(signedIn);
        themeDisplay.setShowPageSettingsIcon(false);
        themeDisplay.setShowPortalIcon(true);
        themeDisplay.setShowSignInIcon(!signedIn);
        themeDisplay.setShowSignOutIcon(signedIn);
        themeDisplay.setShowStagingIcon(false);
        String urlControlPanel = friendlyURLPrivateGroupPath.concat("/control_panel");
        if (Validator.isNotNull((String)doAsUserId)) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsUserId", (String)doAsUserId);
        }
        if (scopeGroupId > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsGroupId", (long)scopeGroupId);
        }
        if (refererPlid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)refererPlid);
        } else if (plid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)plid);
        }
        themeDisplay.setURLControlPanel(urlControlPanel);
        PortletURLImpl createAccountURL = new PortletURLImpl(request, "58", plid, "ACTION_PHASE");
        createAccountURL.setWindowState(WindowState.MAXIMIZED);
        createAccountURL.setPortletMode(PortletMode.VIEW);
        createAccountURL.setParameter("saveLastPath", "0");
        createAccountURL.setParameter("struts_action", "/login/create_account");
        themeDisplay.setURLCreateAccount((PortletURL)createAccountURL);
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        themeDisplay.setURLCurrent(currentURL);
        String urlHome = PortalUtil.getHomeURL((HttpServletRequest)request);
        themeDisplay.setURLHome(urlHome);
        if (layout != null) {
            if (layout.isTypePortlet()) {
                boolean freeformLayout = layoutTypePortlet.getLayoutTemplateId().equals("freeform");
                themeDisplay.setFreeformLayout(freeformLayout);
                boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
                if (hasUpdateLayoutPermission) {
                    themeDisplay.setShowAddContentIconPermission(true);
                    if (!LiferayWindowState.isMaximized((HttpServletRequest)request)) {
                        themeDisplay.setShowAddContentIcon(true);
                    }
                    themeDisplay.setShowLayoutTemplatesIcon(true);
                    themeDisplay.setURLAddContent("Liferay.LayoutConfiguration.toggle('".concat("87").concat("');"));
                    themeDisplay.setURLLayoutTemplates("Liferay.LayoutConfiguration.showTemplates();");
                }
            }
            boolean hasManageLayoutsPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"MANAGE_LAYOUTS");
            if (group.isUser() && (layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_MODIFIABLE || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_MODIFIABLE)) {
                hasManageLayoutsPermission = false;
            }
            if (hasManageLayoutsPermission) {
                themeDisplay.setShowPageSettingsIcon(true);
                PortletURLImpl pageSettingsURL = new PortletURLImpl(request, "88", plid, "RENDER_PHASE");
                pageSettingsURL.setWindowState(WindowState.MAXIMIZED);
                pageSettingsURL.setPortletMode(PortletMode.VIEW);
                pageSettingsURL.setParameter("struts_action", "/layout_management/edit_pages");
                if (layout.isPrivateLayout()) {
                    pageSettingsURL.setParameter("tabs1", "private-pages");
                } else {
                    pageSettingsURL.setParameter("tabs1", "public-pages");
                }
                pageSettingsURL.setParameter("redirect", currentURL);
                pageSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                pageSettingsURL.setParameter("selPlid", String.valueOf(plid));
                themeDisplay.setURLPageSettings((PortletURL)pageSettingsURL);
            }
            if (group.hasStagingGroup() && !group.isStagingGroup()) {
                themeDisplay.setShowAddContentIcon(false);
                themeDisplay.setShowLayoutTemplatesIcon(false);
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isControlPanel()) {
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isStaged() || group.isStagingGroup()) {
                boolean hasApproveProposalPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"APPROVE_PROPOSAL");
                boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"PUBLISH_STAGING");
                if (hasApproveProposalPermission || hasManageLayoutsPermission || hasPublishStagingPermission) {
                    themeDisplay.setShowStagingIcon(true);
                }
                if (hasPublishStagingPermission) {
                    PortletURLImpl publishToLiveURL = new PortletURLImpl(request, "88", plid, "RENDER_PHASE");
                    publishToLiveURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    publishToLiveURL.setPortletMode(PortletMode.VIEW);
                    publishToLiveURL.setParameter("struts_action", "/layout_management/export_pages");
                    if (layout.isPrivateLayout()) {
                        publishToLiveURL.setParameter("tabs1", "private-pages");
                    } else {
                        publishToLiveURL.setParameter("tabs1", "public-pages");
                    }
                    publishToLiveURL.setParameter("pagesRedirect", currentURL);
                    publishToLiveURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    publishToLiveURL.setParameter("selPlid", String.valueOf(plid));
                    themeDisplay.setURLPublishToLive((PortletURL)publishToLiveURL);
                }
            }
            String myAccountNamespace = PortalUtil.getPortletNamespace((String)"2");
            String myAccountRedirect = ParamUtil.getString((HttpServletRequest)request, (String)myAccountNamespace.concat("backURL"), (String)currentURL);
            Group controlPanelGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Control Panel");
            long controlPanelPlid = LayoutLocalServiceUtil.getDefaultPlid((long)controlPanelGroup.getGroupId(), (boolean)true);
            PortletURLImpl myAccountURL = new PortletURLImpl(request, "2", controlPanelPlid, "RENDER_PHASE");
            myAccountURL.setWindowState(WindowState.MAXIMIZED);
            myAccountURL.setPortletMode(PortletMode.VIEW);
            myAccountURL.setRefererPlid(plid);
            myAccountURL.setParameter("struts_action", "/my_account/edit_user");
            myAccountURL.setParameter("backURL", myAccountRedirect);
            themeDisplay.setURLMyAccount((PortletURL)myAccountURL);
        }
        if (!user.isActive() || PrefsPropsUtil.getBoolean(companyId, "terms.of.use.required") && !user.isAgreedToTermsOfUse()) {
            themeDisplay.setShowAddContentIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
        }
        if (group.isLayoutPrototype()) {
            themeDisplay.setShowControlPanelIcon(false);
            themeDisplay.setShowHomeIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(true);
            themeDisplay.setShowPortalIcon(false);
            themeDisplay.setShowSignInIcon(false);
            themeDisplay.setShowSignOutIcon(false);
            themeDisplay.setShowStagingIcon(false);
        }
        themeDisplay.setURLPortal(portalURL.concat(contextPath));
        String urlSignIn = mainPath.concat("/portal/login");
        if (layout != null) {
            urlSignIn = HttpUtil.addParameter((String)urlSignIn, (String)"p_l_id", (long)layout.getPlid());
        }
        themeDisplay.setURLSignIn(urlSignIn);
        themeDisplay.setURLSignOut(mainPath.concat("/portal/logout"));
        PortletURLImpl updateManagerURL = new PortletURLImpl(request, "104", plid, "RENDER_PHASE");
        updateManagerURL.setWindowState(WindowState.MAXIMIZED);
        updateManagerURL.setPortletMode(PortletMode.VIEW);
        updateManagerURL.setParameter("struts_action", "/update_manager/view");
        themeDisplay.setURLUpdateManager((PortletURL)updateManagerURL);
        request.setAttribute("THEME_DISPLAY", (Object)themeDisplay);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        boolean parallelRenderEnable = true;
        if (layout != null && (portletIds = layoutTypePortlet.getPortletIds()).size() == 1 && (portlet = PortletLocalServiceUtil.getPortletById((String)(portletId = (String)portletIds.get(0)))) != null && !portlet.isAjaxable()) {
            parallelRenderEnable = false;
        }
        Boolean parallelRenderEnableObj = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_parallel", (boolean)parallelRenderEnable);
        request.setAttribute("PORTLET_PARALLEL_RENDER", (Object)parallelRenderEnableObj);
    }

    protected void updateUserLayouts(User user) throws Exception {
        Boolean hasPowerUserRole = null;
        boolean addDefaultUserPrivateLayouts = false;
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPrivateLayouts = true;
            if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this.hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPrivateLayouts = false;
                }
            }
        }
        if (addDefaultUserPrivateLayouts && !user.hasPrivateLayouts()) {
            this.addDefaultUserPrivateLayouts(user);
        }
        boolean deleteDefaultUserPrivateLayouts = false;
        if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED) {
            deleteDefaultUserPrivateLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPrivateLayouts = true;
            }
        }
        if (deleteDefaultUserPrivateLayouts && user.hasPrivateLayouts()) {
            this.deleteDefaultUserPrivateLayouts(user);
        }
        boolean addDefaultUserPublicLayouts = false;
        if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPublicLayouts = true;
            if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this.hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPublicLayouts = false;
                }
            }
        }
        if (addDefaultUserPublicLayouts && !user.hasPublicLayouts()) {
            this.addDefaultUserPublicLayouts(user);
        }
        boolean deleteDefaultUserPublicLayouts = false;
        if (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            deleteDefaultUserPublicLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPublicLayouts = true;
            }
        }
        if (deleteDefaultUserPublicLayouts && user.hasPublicLayouts()) {
            this.deleteDefaultUserPublicLayouts(user);
        }
    }
}

