/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.AutoDeployer;
import com.liferay.portal.deploy.auto.MVCPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PHPPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.deploy.auto.WAIAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class PortletAutoDeployListener
extends BaseAutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PortletAutoDeployListener.class);
    private AutoDeployer _deployer = new PortletAutoDeployer();
    private MVCPortletAutoDeployer _mvcDeployer;
    private PHPPortletAutoDeployer _phpDeployer;
    private WAIAutoDeployer _waiDeployer;

    public void deploy(File file) throws AutoDeployException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + file.getPath()));
        }
        AutoDeployer deployer = null;
        if (this.isMatchingFile(file, "WEB-INF/portlet.xml")) {
            deployer = this._deployer;
        } else if (this.isMatchingFile(file, "index_mvc.jsp")) {
            deployer = this.getMvcDeployer();
        } else if (this.isMatchingFile(file, "index.php")) {
            deployer = this.getPhpDeployer();
        } else if (!(this.isExtPlugin(file) || this.isHookPlugin(file) || this.isMatchingFile(file, "WEB-INF/liferay-layout-templates.xml") || this.isThemePlugin(file) || this.isWebPlugin(file) || !file.getName().endsWith(".war"))) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Deploying package as a web application");
            }
            deployer = this.getWaiDeployer();
        } else {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Copying portlets for " + file.getPath()));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using deployer " + deployer.getClass().getName()));
        }
        deployer.autoDeploy(file.getName());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Portlets for " + file.getPath() + " copied successfully. " + "Deployment will start in a few seconds."));
        }
    }

    protected AutoDeployer getMvcDeployer() {
        if (this._mvcDeployer == null) {
            this._mvcDeployer = new MVCPortletAutoDeployer();
        }
        return this._mvcDeployer;
    }

    protected AutoDeployer getPhpDeployer() throws AutoDeployException {
        if (this._phpDeployer == null) {
            this._phpDeployer = new PHPPortletAutoDeployer();
        }
        return this._phpDeployer;
    }

    protected AutoDeployer getWaiDeployer() throws AutoDeployException {
        if (this._waiDeployer == null) {
            this._waiDeployer = new WAIAutoDeployer();
        }
        return this._waiDeployer;
    }
}

