/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropInfo {
    private static Logger log = LoggerFactory.getLogger((Class)PropInfo.class);
    private final Name name;
    private final int type;
    private final TextValue[] values;

    public PropInfo(Name name, int type, TextValue[] values) {
        this.name = name;
        this.type = type;
        this.values = values;
    }

    public void dispose() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].dispose();
        }
    }

    private int getTargetType(PropDef def) {
        int target = def.getRequiredType();
        if (target != 0) {
            return target;
        }
        if (this.type != 0) {
            return this.type;
        }
        return 1;
    }

    private PropDef getApplicablePropertyDef(EffectiveNodeType ent) throws ConstraintViolationException {
        if (this.values.length == 1) {
            return ent.getApplicablePropertyDef(this.name, this.type);
        }
        return ent.getApplicablePropertyDef(this.name, this.type, true);
    }

    public void apply(NodeImpl node, NamePathResolver resolver, ReferenceChangeTracker refTracker) throws RepositoryException {
        PropDef def = this.getApplicablePropertyDef(node.getEffectiveNodeType());
        if (def.isProtected()) {
            log.debug("skipping protected property " + this.name);
            return;
        }
        Value[] va = new Value[this.values.length];
        int targetType = this.getTargetType(def);
        for (int i = 0; i < this.values.length; ++i) {
            va[i] = this.values[i].getValue(targetType, resolver);
        }
        if (va.length == 1 && !def.isMultiple()) {
            Throwable e = null;
            try {
                node.setProperty(this.name, va[0]);
            }
            catch (ValueFormatException vfe) {
                e = vfe;
            }
            catch (ConstraintViolationException cve) {
                e = cve;
            }
            if (e != null) {
                node.setProperty(this.name, va, this.type);
            }
        } else {
            node.setProperty(this.name, va, this.type);
        }
        if (this.type == 9) {
            refTracker.processedReference(node.getProperty(this.name));
        }
    }

    public void apply(NodeState node, BatchedItemOperations itemOps, NodeTypeRegistry ntReg, ReferenceChangeTracker refTracker) throws RepositoryException {
        PropertyState prop = null;
        PropDef def = null;
        if (node.hasPropertyName(this.name)) {
            PropertyId idExisting = new PropertyId(node.getNodeId(), this.name);
            prop = (PropertyState)itemOps.getItemState(idExisting);
            def = ntReg.getPropDef(prop.getDefinitionId());
            if (def.isProtected()) {
                log.debug("skipping protected property " + itemOps.safeGetJCRPath(idExisting));
                return;
            }
            if (!def.isAutoCreated() || prop.getType() != this.type && this.type != 0 || def.isMultiple() != prop.isMultiValued()) {
                throw new ItemExistsException(itemOps.safeGetJCRPath(prop.getPropertyId()));
            }
        } else {
            def = this.getApplicablePropertyDef(itemOps.getEffectiveNodeType(node));
            if (def.isProtected()) {
                log.debug("skipping protected property " + this.name);
                return;
            }
            prop = itemOps.createPropertyState(node, this.name, this.type, def);
        }
        if (this.values.length != 1 && !def.isMultiple()) {
            throw new ConstraintViolationException(itemOps.safeGetJCRPath(prop.getPropertyId()) + " is not multi-valued");
        }
        int targetType = this.getTargetType(def);
        InternalValue[] iva = new InternalValue[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            iva[i] = this.values[i].getInternalValue(targetType);
        }
        prop.setValues(iva);
        itemOps.validate(prop);
        if (prop.getType() == 9) {
            refTracker.processedReference(prop);
        }
        itemOps.store(prop);
    }
}

