/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.Random;

public class RandomStringUtil {
    protected static final Random rnd = new Random();
    protected static char[] alphaRange = new char[]{'A', 'Z', 'a', 'z'};
    protected static char[] alphaNumericRange = new char[]{'0', '9', 'A', 'Z', 'a', 'z'};

    public static String random(int count, char[] chars) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        while (count-- > 0) {
            result[count] = chars[rnd.nextInt(chars.length)];
        }
        return new String(result);
    }

    public static String random(int count, String chars) {
        return RandomStringUtil.random(count, chars.toCharArray());
    }

    public static String random(int count, char start, char end) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        int len = end - start + 1;
        while (count-- > 0) {
            result[count] = (char)(rnd.nextInt(len) + start);
        }
        return new String(result);
    }

    public static String randomAscii(int count) {
        return RandomStringUtil.random(count, ' ', '~');
    }

    public static String randomNumeric(int count) {
        return RandomStringUtil.random(count, '0', '9');
    }

    public static String randomRanges(int count, char ... ranges) {
        int i;
        if (count == 0) {
            return "";
        }
        int len = 0;
        int[] lens = new int[ranges.length];
        for (i = 0; i < ranges.length; i += 2) {
            int gap = ranges[i + 1] - ranges[i] + 1;
            lens[i] = len += gap;
        }
        char[] result = new char[count];
        while (count-- > 0) {
            char c = '\u0000';
            int r = rnd.nextInt(len);
            for (i = 0; i < ranges.length; i += 2) {
                if (r >= lens[i]) continue;
                r += ranges[i];
                if (i != 0) {
                    r -= lens[i - 2];
                }
                c = (char)r;
                break;
            }
            result[count] = c;
        }
        return new String(result);
    }

    public static String randomAlpha(int count) {
        return RandomStringUtil.randomRanges(count, alphaRange);
    }

    public static String randomAlphaNumeric(int count) {
        return RandomStringUtil.randomRanges(count, alphaNumericRange);
    }
}

