/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import jodd.typeconverter.BooleanConverter;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArrayConverter
implements TypeConverter<boolean[]> {
    public static boolean[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Boolean) {
                return new boolean[]{(Boolean)value};
            }
            return new boolean[]{BooleanConverter.valueOf(value.toString())};
        }
        if (type == boolean[].class) {
            return (boolean[])value;
        }
        if (type == int[].class) {
            int[] values = (int[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0;
            }
            return results;
        }
        if (type == long[].class) {
            long[] values = (long[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0L;
            }
            return results;
        }
        if (type == double[].class) {
            double[] values = (double[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0.0;
            }
            return results;
        }
        if (type == float[].class) {
            float[] values = (float[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0.0f;
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0;
            }
            return results;
        }
        if (type == short[].class) {
            short[] values = (short[])value;
            boolean[] results = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] != 0;
            }
            return results;
        }
        Object[] values = (Object[])value;
        boolean[] results = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = BooleanConverter.valueOf(values[i]);
        }
        return results;
    }

    @Override
    public boolean[] convert(Object value) {
        return BooleanArrayConverter.valueOf(value);
    }
}

