/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.util.LinkedHashMap;
import java.util.Map;
import jodd.servlet.HtmlEncoder;
import jodd.util.CharUtil;

public class HtmlTag {
    public static final char TAG_START = '<';
    public static final char TAG_END = '>';
    protected final String tag;
    protected final int nextIndex;
    protected final int firstIndex;
    protected final int lastIndex;
    protected final boolean isClosedTag;
    protected final boolean isEndTag;
    protected final int startIndex;
    protected String tagName;
    protected int attrStartIndex;
    protected Map<String, String> attributes;
    protected boolean changed;
    protected String suffix = "";

    public static HtmlTag locateNextTag(String html, int start) {
        int left = start;
        while (true) {
            if ((left = html.indexOf(60, left)) == -1) {
                return null;
            }
            int max = html.length() - 1;
            if (left == max - 1 || html.charAt(left + 1) != '!') break;
            ++left;
        }
        int right = html.indexOf(62, left);
        if (right == -1) {
            return null;
        }
        return new HtmlTag(html.substring(left, ++right), left, right);
    }

    public HtmlTag(String tag) {
        this(tag, 0, 0);
    }

    protected HtmlTag(String tag, int startIndex, int nextIndex) {
        this.tag = tag;
        this.nextIndex = nextIndex;
        this.startIndex = startIndex;
        int i = tag.length() - 1;
        if (tag.charAt(i - 1) == '/') {
            --i;
            this.isClosedTag = true;
        } else {
            this.isClosedTag = false;
        }
        this.lastIndex = i;
        i = 1;
        if (tag.charAt(i) == '/') {
            ++i;
            this.isEndTag = true;
        } else {
            this.isEndTag = false;
        }
        this.firstIndex = i;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isClosedTag() {
        return this.isClosedTag;
    }

    public boolean isEndTag() {
        return this.isEndTag;
    }

    public String getTagName() {
        if (this.tagName == null) {
            this.tagName = this.resolveTagName().toLowerCase();
        }
        return this.tagName;
    }

    protected String resolveTagName() {
        int end;
        int start;
        for (start = this.firstIndex; start < this.lastIndex && CharUtil.isWhitespace(this.tag.charAt(start)); ++start) {
        }
        if (start == this.lastIndex) {
            return "";
        }
        for (end = start; end < this.lastIndex && !CharUtil.isWhitespace(this.tag.charAt(end)); ++end) {
        }
        this.attrStartIndex = end + 1;
        return this.tag.substring(start, end);
    }

    public String getAttribute(String attrName) {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        return this.attributes.get(attrName);
    }

    public boolean hasAttribute(String attrName) {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        return this.attributes.containsKey(attrName);
    }

    public void removeAttribute(String attrName) {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        this.changed = true;
        this.attributes.remove(attrName);
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        this.changed = true;
        this.attributes.put(name.toLowerCase(), HtmlEncoder.text(value));
    }

    public void setAttribute(String name) {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        this.changed = true;
        this.attributes.put(name.toLowerCase(), null);
    }

    public int totalAttributes() {
        if (this.attributes == null) {
            this.resolveAttributes();
        }
        return this.attributes.size();
    }

    protected void resolveAttributes() {
        this.attributes = new LinkedHashMap<String, String>();
        if (this.attrStartIndex == 0) {
            this.resolveTagName();
        }
        int start = this.attrStartIndex;
        while (start < this.lastIndex) {
            int end;
            while (start < this.lastIndex && CharUtil.isWhitespace(this.tag.charAt(start))) {
                ++start;
            }
            if (start == this.lastIndex) {
                return;
            }
            for (end = start; end < this.lastIndex && !CharUtil.isWhitespace(this.tag.charAt(end)) && this.tag.charAt(end) != '='; ++end) {
            }
            String attributeName = this.tag.substring(start, end).toLowerCase();
            if (start == this.lastIndex) {
                this.attributes.put(attributeName, null);
                return;
            }
            for (start = end; start < this.lastIndex && CharUtil.isWhitespace(this.tag.charAt(start)); ++start) {
            }
            if (start == this.lastIndex) {
                return;
            }
            if (this.tag.charAt(start) != '=') {
                this.attributes.put(attributeName, null);
                continue;
            }
            ++start;
            while (start < this.lastIndex && CharUtil.isWhitespace(this.tag.charAt(start))) {
                ++start;
            }
            if (start == this.lastIndex) {
                return;
            }
            char quote = this.tag.charAt(start);
            if (quote != '\"' && quote != '\'') {
                quote = '\u0000';
            }
            for (end = ++start; end < this.lastIndex && this.tag.charAt(end) != quote; ++end) {
            }
            String value = this.tag.substring(start, end);
            this.attributes.put(attributeName, value);
            start = end + 1;
        }
    }

    public void setSuffixText(String suffix) {
        this.suffix = suffix;
    }

    public String toString() {
        if (!this.changed) {
            return this.tag + this.suffix;
        }
        StringBuilder t = new StringBuilder();
        t.append('<');
        if (this.isEndTag) {
            t.append('/');
        }
        t.append(this.getTagName()).append(' ');
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            t.append(entry.getKey());
            String value = entry.getValue();
            if (value != null) {
                t.append('=').append('\"').append(value).append('\"');
            }
            t.append(' ');
        }
        t.setLength(t.length() - 1);
        if (this.isClosedTag) {
            t.append('/');
        }
        t.append('>').append(this.suffix);
        return t.toString();
    }
}

