/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import jodd.bean.BeanUtil;
import jodd.bean.loader.BeanLoader;

public class SessionBeanLoader
implements BeanLoader {
    String prefix;

    public SessionBeanLoader() {
    }

    public SessionBeanLoader(String prefix) {
        this.prefix = prefix;
    }

    public static void loadBean(Object bean, Object session, String prefix) {
        if (session instanceof HttpSession) {
            Enumeration attribNames = ((HttpSession)session).getAttributeNames();
            while (attribNames.hasMoreElements()) {
                String attribName = (String)attribNames.nextElement();
                Object value = ((HttpSession)session).getAttribute(attribName);
                if (value == null) continue;
                if (prefix != null) {
                    attribName = prefix + Character.toUpperCase(attribName.charAt(0)) + attribName.substring(1);
                }
                BeanUtil.setPropertyForcedSilent(bean, attribName, value);
            }
        }
    }

    public void load(Object bean, Object session) {
        SessionBeanLoader.loadBean(bean, session, this.prefix);
    }
}

