/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.bean.loader.BeanLoader;
import jodd.bean.loader.MapBeanLoader;
import jodd.bean.loader.MultipartRequestBeanLoader;
import jodd.bean.loader.MultipartRequestWrapperBeanLoader;
import jodd.bean.loader.RequestBeanLoader;
import jodd.bean.loader.ResultSetBeanLoader;
import jodd.bean.loader.ServletContextBeanLoader;
import jodd.bean.loader.SessionBeanLoader;
import jodd.servlet.upload.MultipartRequest;
import jodd.servlet.upload.MultipartRequestWrapper;

public class BeanLoaderManager {
    private static final Map<Class, BeanLoader> loaders = new HashMap<Class, BeanLoader>();

    public static void unregisterAll() {
        loaders.clear();
    }

    public static void registerDefaults() {
        BeanLoaderManager.register(Map.class, new MapBeanLoader());
        BeanLoaderManager.register(ResultSet.class, new ResultSetBeanLoader());
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            BeanLoaderManager.register(HttpServletRequest.class, new RequestBeanLoader());
            Class.forName("javax.servlet.http.HttpSession");
            BeanLoaderManager.register(HttpSession.class, new SessionBeanLoader());
            Class.forName("javax.servlet.ServletContext");
            BeanLoaderManager.register(ServletContext.class, new ServletContextBeanLoader());
            BeanLoaderManager.register(MultipartRequest.class, new MultipartRequestBeanLoader());
            BeanLoaderManager.register(MultipartRequestWrapper.class, new MultipartRequestWrapperBeanLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void register(Class type, BeanLoader load) {
        loaders.put(type, load);
    }

    public static void unregister(Class type) {
        loaders.remove(type);
    }

    public static BeanLoader lookup(Class type) {
        return loaders.get(type);
    }

    public static BeanLoader lookup(Object source) {
        BeanLoader load = BeanLoaderManager.lookup(source.getClass());
        if (load == null) {
            for (Class key : loaders.keySet()) {
                if (!key.isInstance(source)) continue;
                load = BeanLoaderManager.lookup(key);
                break;
            }
        }
        return load;
    }

    static {
        BeanLoaderManager.registerDefaults();
    }
}

