/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mozilla.javascript;

import com.liferay.mozilla.javascript.Callable;
import com.liferay.mozilla.javascript.ClassCache;
import com.liferay.mozilla.javascript.Context;
import com.liferay.mozilla.javascript.ContextAction;
import com.liferay.mozilla.javascript.ContextFactory;
import com.liferay.mozilla.javascript.ScriptRuntime;
import com.liferay.mozilla.javascript.Scriptable;
import com.liferay.mozilla.javascript.VMBridge;
import com.liferay.mozilla.javascript.WrapFactory;
import java.lang.reflect.Method;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context cx, Class cl, Callable function) {
        if (!cl.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable topScope = ScriptRuntime.getTopCallScope(cx);
        ClassCache cache = ClassCache.get(topScope);
        InterfaceAdapter adapter = (InterfaceAdapter)cache.getInterfaceAdapter(cl);
        ContextFactory cf = cx.getFactory();
        if (adapter == null) {
            boolean canCallFunction;
            block7: {
                Method[] methods = cl.getMethods();
                if (methods.length == 0) {
                    throw Context.reportRuntimeError2("msg.no.empty.interface.conversion", String.valueOf(function), cl.getClass().getName());
                }
                canCallFunction = false;
                Class<?>[] argTypes = methods[0].getParameterTypes();
                for (int i = 1; i != methods.length; ++i) {
                    Class<?>[] types2 = methods[i].getParameterTypes();
                    if (types2.length != argTypes.length) break block7;
                    for (int j = 0; j != argTypes.length; ++j) {
                        if (types2[j] == argTypes[j]) {
                            continue;
                        }
                        break block7;
                    }
                }
                canCallFunction = true;
            }
            if (!canCallFunction) {
                throw Context.reportRuntimeError2("msg.no.function.interface.conversion", String.valueOf(function), cl.getClass().getName());
            }
            adapter = new InterfaceAdapter(cf, cl);
            cache.cacheInterfaceAdapter(cl, adapter);
        }
        return VMBridge.instance.newInterfaceProxy(adapter.proxyHelper, cf, adapter, function, topScope);
    }

    private InterfaceAdapter(ContextFactory cf, Class cl) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(cf, new Class[]{cl});
    }

    public Object invoke(ContextFactory cf, final Object target, final Scriptable topScope, final Method method, final Object[] args) {
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return InterfaceAdapter.this.invokeImpl(cx, target, topScope, method, args);
            }
        };
        return cf.call(action);
    }

    Object invokeImpl(Context cx, Object target, Scriptable topScope, Method method, Object[] args) {
        int N = args == null ? 0 : args.length;
        Callable function = (Callable)target;
        Scriptable thisObj = topScope;
        Object[] jsargs = new Object[N + 1];
        jsargs[N] = method.getName();
        if (N != 0) {
            WrapFactory wf = cx.getWrapFactory();
            for (int i = 0; i != N; ++i) {
                jsargs[i] = wf.wrap(cx, topScope, args[i], null);
            }
        }
        Object result = function.call(cx, topScope, thisObj, jsargs);
        Class<?> javaResultType = method.getReturnType();
        result = javaResultType == Void.TYPE ? null : Context.jsToJava(result, javaResultType);
        return result;
    }
}

