/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import java.io.Serializable;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWorkflowHandler
implements WorkflowHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseWorkflowHandler.class);

    @Override
    public AssetRenderer getAssetRenderer(long classPK) throws PortalException, SystemException {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK, 0);
        }
        return null;
    }

    @Override
    public AssetRendererFactory getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    @Override
    public String getIconPath(LiferayPortletRequest liferayPortletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        return this.getIconPath(themeDisplay);
    }

    @Override
    public String getSummary(long classPK) {
        block3: {
            try {
                AssetRenderer assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getSummary();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String getTitle(long classPK) {
        block3: {
            try {
                AssetRenderer assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getTitle();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public PortletURL getURLEdit(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        block3: {
            try {
                AssetRenderer assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLEdit(liferayPortletRequest, liferayPortletResponse);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String getURLViewInContext(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        block3: {
            try {
                AssetRenderer assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, noSuchEntryRedirect);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String render(long classPK, RenderRequest renderRequest, RenderResponse renderResponse, String template) {
        block3: {
            try {
                AssetRenderer assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.render(renderRequest, renderResponse, template);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public void startWorkflowInstance(long companyId, long groupId, long userId, long classPK, Object model, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        WorkflowInstanceLinkLocalServiceUtil.startWorkflowInstance(companyId, groupId, userId, this.getClassName(), classPK, workflowContext);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/page.png";
    }
}

