/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeIterator
implements Iterator {
    protected final List<Iterator> allIterators = new ArrayList<Iterator>();
    protected int currentIterator = -1;

    public CompositeIterator() {
    }

    public CompositeIterator(Iterator ... iterators) {
        for (Iterator iterator : iterators) {
            this.add(iterator);
        }
    }

    public void add(Iterator iterator) {
        if (this.allIterators.contains(iterator)) {
            throw new IllegalArgumentException("Same iterator already added to this composite.");
        }
        this.allIterators.add(iterator);
    }

    public boolean hasNext() {
        for (Iterator iterator : this.allIterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        for (int i = 0; i < this.allIterators.size(); ++i) {
            Iterator iterator = this.allIterators.get(i);
            if (!iterator.hasNext()) continue;
            this.currentIterator = i;
            return iterator.next();
        }
        throw new NoSuchElementException("All iterators exhausted");
    }

    public void remove() {
        if (this.currentIterator == -1) {
            throw new IllegalStateException("The next() method has not yet been called.");
        }
        this.allIterators.get(this.currentIterator).remove();
    }
}

