/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload.impl;

import java.io.File;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.FileUploadFactory;
import jodd.servlet.upload.MultipartRequestInputStream;
import jodd.servlet.upload.impl.AdaptiveFileUpload;

public class AdaptiveFileUploadFactory
implements FileUploadFactory {
    protected int memoryThreshold = 8192;
    protected File uploadPath;
    protected int maxFileSize = 102400;
    protected boolean breakOnError;
    protected String[] fileExtensions;
    protected boolean allowFileExtensions = true;

    public FileUpload create(MultipartRequestInputStream input) {
        return new AdaptiveFileUpload(input, this.memoryThreshold, this.uploadPath, this.maxFileSize, this.breakOnError, this.fileExtensions, this.allowFileExtensions);
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        if (memoryThreshold >= 0) {
            this.memoryThreshold = memoryThreshold;
        }
    }

    public AdaptiveFileUploadFactory memoryThreshold(int memoryThreshold) {
        this.setMemoryThreshold(memoryThreshold);
        return this;
    }

    public File getUploadPath() {
        return this.uploadPath;
    }

    public void setUploadPath(File uploadPath) {
        this.uploadPath = uploadPath;
    }

    public AdaptiveFileUploadFactory uploadPath(File uploadPath) {
        this.uploadPath = uploadPath;
        return this;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public AdaptiveFileUploadFactory maxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public void setBreakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
    }

    public AdaptiveFileUploadFactory breakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public AdaptiveFileUploadFactory setFileExtensions(String[] fileExtensions, boolean allow) {
        this.fileExtensions = fileExtensions;
        this.allowFileExtensions = allow;
        return this;
    }
}

