/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jodd.mail.EmailMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonEmail {
    public static final String X_PRIORITY = "X-Priority";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    protected static final String[] NONE = new String[0];
    protected String from;
    protected String[] to = NONE;
    protected String[] replyTo = NONE;
    protected String[] cc = NONE;
    protected String[] bcc = NONE;
    protected String subject;
    protected LinkedList<EmailMessage> messages = new LinkedList();
    protected Map<String, String> headers;
    protected Date sentDate;

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setTo(String to) {
        if (to == null) {
            return;
        }
        this.to = new String[]{to};
    }

    public void setTo(String ... tos) {
        if (tos == null) {
            return;
        }
        this.to = tos;
    }

    public String[] getTo() {
        return this.to;
    }

    public void setReplyTo(String replyTo) {
        if (replyTo == null) {
            return;
        }
        this.replyTo = new String[]{replyTo};
    }

    public void setReplyTo(String[] replyTo) {
        if (replyTo == null) {
            return;
        }
        this.replyTo = replyTo;
    }

    public String[] getReplyTo() {
        return this.replyTo;
    }

    public void setCc(String cc) {
        if (cc == null) {
            return;
        }
        this.cc = new String[]{cc};
    }

    public void setCc(String ... ccs) {
        if (ccs == null) {
            return;
        }
        this.cc = ccs;
    }

    public String[] getCc() {
        return this.cc;
    }

    public void setBcc(String bcc) {
        if (bcc == null) {
            return;
        }
        this.bcc = new String[]{bcc};
    }

    public void setBcc(String ... bccs) {
        if (bccs == null) {
            return;
        }
        this.bcc = bccs;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public LinkedList<EmailMessage> getAllMessages() {
        return this.messages;
    }

    public void addMessage(EmailMessage emailMessage) {
        this.messages.add(emailMessage);
    }

    public void addMessage(String text, String mimeType, String encoding) {
        this.messages.add(new EmailMessage(text, mimeType, encoding));
    }

    public void addMessage(String text, String mimeType) {
        this.messages.add(new EmailMessage(text, mimeType));
    }

    protected Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void setPriority(int priority) {
        this.setHeader(X_PRIORITY, String.valueOf(priority));
    }

    public int getPriority() {
        if (this.headers == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.headers.get(X_PRIORITY));
        }
        catch (NumberFormatException nfex) {
            return -1;
        }
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        return this.sentDate;
    }
}

