/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import jodd.io.FileUtil;
import jodd.io.findfile.FindFileException;
import jodd.util.StringUtil;

public class FindFile {
    protected boolean recursive;
    protected boolean includeDirs = true;
    protected boolean includeFiles = true;
    protected LinkedList<File> fileList;
    protected boolean listSubfilesAfterFolder = true;

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public FindFile recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public FindFile includeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
        return this;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    public FindFile includeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
        return this;
    }

    public FindFile includeFilesAndFolders() {
        this.includeDirs = true;
        this.includeFiles = true;
        return this;
    }

    public FindFile() {
    }

    public FindFile(String searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(String[] searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(File searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(URI searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(URI[] searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(URL searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile(URL[] searchPath) {
        this.searchPath(searchPath);
    }

    public FindFile searchPath(String searchPath) {
        if (searchPath.indexOf(File.pathSeparatorChar) != -1) {
            String[] paths;
            for (String path : paths = StringUtil.split(searchPath, File.pathSeparator)) {
                this.searchPath(path);
            }
            return this;
        }
        this.searchPath(new File(searchPath));
        return this;
    }

    public FindFile searchPath(String[] searchPaths) {
        for (String searchPath : searchPaths) {
            this.searchPath(searchPath);
        }
        return this;
    }

    public FindFile searchPath(File searchPath) {
        if (!searchPath.exists()) {
            return this;
        }
        if (this.fileList == null) {
            this.fileList = new LinkedList();
        }
        if (!searchPath.isDirectory()) {
            this.fileList.add(searchPath);
            return this;
        }
        this.listFiles(searchPath);
        return this;
    }

    public FindFile searchPath(URI searchPath) {
        this.searchPath(new File(searchPath));
        return this;
    }

    public FindFile searchPath(URI[] searchPath) {
        for (URI uri : searchPath) {
            this.searchPath(uri);
        }
        return this;
    }

    public FindFile searchPath(URL searchPath) {
        File file = FileUtil.toFile(searchPath);
        if (file == null) {
            throw new FindFileException("Search path is not a valid file URL: '" + searchPath + "'.");
        }
        this.searchPath(file);
        return this;
    }

    public FindFile searchPath(URL[] searchPath) {
        for (URL url : searchPath) {
            this.searchPath(url);
        }
        return this;
    }

    public boolean isListSubfilesAfterFolder() {
        return this.listSubfilesAfterFolder;
    }

    public void setListSubfilesAfterFolder(boolean listSubfilesAfterFolder) {
        this.listSubfilesAfterFolder = listSubfilesAfterFolder;
    }

    public FindFile listSubfilesAfterFolder(boolean value) {
        this.listSubfilesAfterFolder = value;
        return this;
    }

    public File nextFile() {
        File currentFile;
        block3: {
            if (this.fileList == null) {
                return null;
            }
            do {
                if (this.fileList.isEmpty()) {
                    this.fileList = null;
                    return null;
                }
                currentFile = this.fileList.removeFirst();
                if (!currentFile.isDirectory()) break block3;
                if (!this.recursive) continue;
                this.listFiles(currentFile);
            } while (!this.includeDirs || !this.acceptFile(currentFile));
            return currentFile;
        }
        return currentFile;
    }

    protected void listFiles(File directory) {
        LinkedList<File> subFiles;
        LinkedList<File> subFolders;
        File[] list = directory.listFiles();
        if (!this.listSubfilesAfterFolder) {
            subFolders = this.fileList;
            subFiles = this.fileList;
        } else {
            subFolders = new LinkedList();
            subFiles = new LinkedList();
        }
        for (File currentFile : list) {
            if (currentFile.isFile()) {
                if (!this.includeFiles || !this.acceptFile(currentFile)) continue;
                subFiles.addLast(currentFile);
                continue;
            }
            if (!currentFile.isDirectory()) continue;
            subFolders.addLast(currentFile);
        }
        if (this.listSubfilesAfterFolder) {
            if (!subFiles.isEmpty()) {
                this.fileList.addAll(0, subFiles);
            }
            if (!subFolders.isEmpty()) {
                this.fileList.addAll(0, subFolders);
            }
        }
    }

    protected boolean acceptFile(File currentFile) {
        return true;
    }
}

