/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.RepeatableFileInputStream;
import org.jets3t.service.model.BaseS3Object;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.utils.Mimetypes;
import org.jets3t.service.utils.ServiceUtils;

public class S3Object
extends BaseS3Object {
    private final Log log = LogFactory.getLog((Class)S3Object.class);
    private static final long serialVersionUID = -2883501141593631181L;
    public static final String METADATA_HEADER_LAST_MODIFIED_DATE = "Last-Modified";
    public static final String METADATA_HEADER_DATE = "Date";
    public static final String METADATA_HEADER_OWNER = "Owner";
    public static final String METADATA_HEADER_ETAG = "ETag";
    public static final String METADATA_HEADER_HASH_MD5 = "md5-hash";
    public static final String METADATA_HEADER_ORIGINAL_HASH_MD5 = "original-md5-hash";
    public static final String METADATA_HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String METADATA_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String METADATA_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String METADATA_HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String METADATA_HEADER_STORAGE_CLASS = "Storage-Class";
    public static final String METADATA_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String METADATA_HEADER_CONTENT_LANGUAGE = "Content-Language";
    private String key = null;
    private String bucketName = null;
    private transient InputStream dataInputStream = null;
    private AccessControlList acl = null;
    private boolean isMetadataComplete = false;
    private File dataInputFile = null;

    public S3Object(S3Bucket bucket, File file) throws FileNotFoundException {
        this(bucket, file.getName());
        this.setContentLength(file.length());
        this.setContentType(Mimetypes.getInstance().getMimetype(file));
        if (!file.canRead()) {
            throw new FileNotFoundException("Cannot read from file: " + file.getAbsolutePath());
        }
        this.setDataInputFile(file);
    }

    public S3Object(S3Bucket bucket, String key, String dataString) throws UnsupportedEncodingException {
        this(bucket, key);
        ByteArrayInputStream bais = new ByteArrayInputStream(dataString.getBytes("UTF-8"));
        this.setDataInputStream(bais);
        this.setContentLength(bais.available());
        this.setContentType("text/plain; charset=utf-8");
    }

    public S3Object(String key) {
        this.key = key;
    }

    public S3Object(S3Bucket bucket, String key) {
        if (bucket != null) {
            this.bucketName = bucket.getName();
        }
        this.key = key;
    }

    public String toString() {
        return "S3Object [key=" + this.getKey() + ",bucket=" + (this.bucketName == null ? "<Unknown>" : this.bucketName) + ",lastModified=" + this.getLastModifiedDate() + ", dataInputStream=" + this.dataInputStream + "] Metadata=" + this.getMetadataMap();
    }

    public InputStream getDataInputStream() throws S3ServiceException {
        if (this.dataInputStream == null && this.dataInputFile != null) {
            try {
                this.dataInputStream = new RepeatableFileInputStream(this.dataInputFile);
            }
            catch (FileNotFoundException e) {
                throw new S3ServiceException("Cannot open file input stream", e);
            }
        }
        return this.dataInputStream;
    }

    public void setDataInputStream(InputStream dataInputStream) {
        this.dataInputFile = null;
        this.dataInputStream = dataInputStream;
    }

    public void setDataInputFile(File dataInputFile) {
        this.dataInputStream = null;
        this.dataInputFile = dataInputFile;
    }

    public void closeDataInputStream() throws IOException {
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
    }

    public String getETag() {
        String etag = (String)this.getMetadata(METADATA_HEADER_ETAG);
        if (etag != null && etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    public void setETag(String etag) {
        this.addMetadata(METADATA_HEADER_ETAG, etag);
    }

    public String getMd5HashAsHex() {
        return (String)this.getMetadata(METADATA_HEADER_HASH_MD5);
    }

    public String getMd5HashAsBase64() {
        String md5HashBase64 = (String)this.getMetadata(METADATA_HEADER_CONTENT_MD5);
        if (md5HashBase64 == null) {
            if (this.getETag() != null) {
                return ServiceUtils.toBase64(ServiceUtils.fromHex(this.getETag()));
            }
            if (this.getMd5HashAsHex() != null) {
                return ServiceUtils.toBase64(ServiceUtils.fromHex(this.getMd5HashAsHex()));
            }
        }
        return md5HashBase64;
    }

    public void setMd5Hash(byte[] md5Hash) {
        this.addMetadata(METADATA_HEADER_HASH_MD5, ServiceUtils.toHex(md5Hash));
        this.addMetadata(METADATA_HEADER_CONTENT_MD5, ServiceUtils.toBase64(md5Hash));
    }

    public Date getLastModifiedDate() {
        Date lastModifiedDate = (Date)this.getMetadata(METADATA_HEADER_LAST_MODIFIED_DATE);
        if (lastModifiedDate == null) {
            lastModifiedDate = (Date)this.getMetadata(METADATA_HEADER_DATE);
        }
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.addMetadata(METADATA_HEADER_LAST_MODIFIED_DATE, lastModifiedDate);
    }

    public S3Owner getOwner() {
        return (S3Owner)this.getMetadata(METADATA_HEADER_OWNER);
    }

    public void setOwner(S3Owner owner) {
        this.addMetadata(METADATA_HEADER_OWNER, owner);
    }

    public long getContentLength() {
        Object contentLength = this.getMetadata(METADATA_HEADER_CONTENT_LENGTH);
        if (contentLength == null) {
            return 0L;
        }
        return Long.parseLong(contentLength.toString());
    }

    public void setContentLength(long size) {
        this.addMetadata(METADATA_HEADER_CONTENT_LENGTH, String.valueOf(size));
    }

    public String getStorageClass() {
        return (String)this.getMetadata(METADATA_HEADER_STORAGE_CLASS);
    }

    public void setStorageClass(String storageClass) {
        this.addMetadata(METADATA_HEADER_STORAGE_CLASS, storageClass);
    }

    public String getContentType() {
        return (String)this.getMetadata(METADATA_HEADER_CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.addMetadata(METADATA_HEADER_CONTENT_TYPE, contentType);
    }

    public String getContentLanguage() {
        return (String)this.getMetadata(METADATA_HEADER_CONTENT_LANGUAGE);
    }

    public void setContentLanguage(String contentLanguage) {
        this.addMetadata(METADATA_HEADER_CONTENT_LANGUAGE, contentLanguage);
    }

    public String getContentDisposition() {
        return (String)this.getMetadata(METADATA_HEADER_CONTENT_DISPOSITION);
    }

    public void setContentDisposition(String contentDisposition) {
        this.addMetadata(METADATA_HEADER_CONTENT_DISPOSITION, contentDisposition);
    }

    public String getContentEncoding() {
        return (String)this.getMetadata(METADATA_HEADER_CONTENT_ENCODING);
    }

    public void setContentEncoding(String contentEncoding) {
        this.addMetadata(METADATA_HEADER_CONTENT_ENCODING, contentEncoding);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                this.addMetadata("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                this.addMetadata("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                this.addMetadata("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                this.addMetadata("x-amz-acl", "authenticated-read");
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isMetadataComplete() {
        return this.isMetadataComplete;
    }

    public void setMetadataComplete(boolean isMetadataComplete) {
        this.isMetadataComplete = isMetadataComplete;
    }

    public void addMetadata(String name, Object value) {
        try {
            if (METADATA_HEADER_LAST_MODIFIED_DATE.equals(name) && !(value instanceof Date)) {
                value = ServiceUtils.parseIso8601Date(value.toString());
            } else if (METADATA_HEADER_DATE.equals(name) && !(value instanceof Date)) {
                value = ServiceUtils.parseIso8601Date(value.toString());
            }
        }
        catch (ParseException e) {
            this.log.error((Object)("Unable to parse value we expect to be a valid date: " + name + "=" + value), (Throwable)e);
        }
        super.addMetadata(name, value);
    }

    public void addAllMetadata(Map metadata) {
        Iterator iter = metadata.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.addMetadata(entry.getKey().toString(), entry.getValue());
        }
    }
}

