/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;

public class UnmarshalCache {
    private final Ruby runtime;
    private final List<IRubyObject> links = new ArrayList<IRubyObject>();
    private final List<RubySymbol> symbols = new ArrayList<RubySymbol>();

    public UnmarshalCache(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public void register(IRubyObject value2) {
        this.selectCache(value2).add(value2);
    }

    private List selectCache(IRubyObject value2) {
        return value2 instanceof RubySymbol ? this.symbols : this.links;
    }

    public boolean isLinkType(int c) {
        return c == 59 || c == 64;
    }

    public IRubyObject readLink(UnmarshalStream input, int type2) throws IOException {
        int i = input.unmarshalInt();
        if (type2 == 64) {
            return this.linkedByIndex(i);
        }
        assert (type2 == 59);
        return this.symbolByIndex(i);
    }

    private IRubyObject linkedByIndex(int index2) {
        try {
            return this.links.get(index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newArgumentError("dump format error (unlinked, index: " + index2 + ")");
        }
    }

    private RubySymbol symbolByIndex(int index2) {
        try {
            return this.symbols.get(index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newTypeError("bad symbol");
        }
    }
}

