/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.localcache;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.LuceneFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.DirectoryWrapper;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.compass.core.CompassException;
import org.compass.core.lucene.engine.store.localcache.LocalCacheManager;
import org.compass.core.transaction.context.TransactionContextCallback;

public class LocalDirectoryCache
extends Directory
implements DirectoryWrapper {
    private static final Log log = LogFactory.getLog(LocalDirectoryCache.class);
    private String subIndex;
    private int bufferSize = 16384;
    private Directory dir;
    private Directory localCacheDir;
    private LocalCacheManager localCacheManager;
    private ScheduledFuture cleanupTaskFuture;
    private Object[] monitors = new Object[100];

    public LocalDirectoryCache(String subIndex, Directory dir, Directory localCacheDir, LocalCacheManager localCacheManager) {
        this(subIndex, dir, localCacheDir, 16384, localCacheManager);
    }

    public LocalDirectoryCache(String subIndex, Directory dir, Directory localCacheDir, int bufferSize, LocalCacheManager localCacheManager) {
        this.subIndex = subIndex;
        this.dir = dir;
        this.localCacheDir = localCacheDir;
        this.bufferSize = bufferSize;
        this.localCacheManager = localCacheManager;
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new Object();
        }
        this.cleanupTaskFuture = localCacheManager.getSearchEngineFactory().getExecutorManager().scheduleWithFixedDelay(new CleanupTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public Directory getWrappedDirectory() {
        return this.dir;
    }

    public void deleteFile(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            this.dir.deleteFile(name);
            if (log.isTraceEnabled()) {
                log.trace((Object)this.logMessage("Deleting [" + name + "] from actual directory"));
            }
            return;
        }
        if (this.localCacheDir.fileExists(name)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)this.logMessage("Deleting [" + name + "] from local cache"));
            }
            this.localCacheDir.deleteFile(name);
        }
        if (this.localCacheManager.getSearchEngineFactory().getLuceneIndexManager().getStore().isUseCompoundFile() && IndexFileNameFilter.getFilter().isCFSFile(name)) {
            return;
        }
        this.dir.deleteFile(name);
        if (log.isTraceEnabled()) {
            log.trace((Object)this.logMessage("Deleting [" + name + "] from actual directory"));
        }
    }

    public boolean fileExists(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            return this.dir.fileExists(name);
        }
        if (this.localCacheDir.fileExists(name)) {
            return true;
        }
        return this.dir.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            return this.dir.fileLength(name);
        }
        this.fetchFileIfNotExists(name);
        return this.localCacheDir.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        return this.dir.fileModified(name);
    }

    public String[] list() throws IOException {
        return this.dir.list();
    }

    public void renameFile(String from, String to) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(from)) {
            this.dir.renameFile(from, to);
            return;
        }
        this.fetchFileIfNotExists(from);
        this.localCacheDir.renameFile(from, to);
        this.dir.renameFile(from, to);
    }

    public void touchFile(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            this.dir.touchFile(name);
            return;
        }
        this.fetchFileIfNotExists(name);
        this.localCacheDir.touchFile(name);
        this.dir.touchFile(name);
    }

    public Lock makeLock(String name) {
        return this.dir.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.dir.clearLock(name);
    }

    public void setLockFactory(LockFactory lockFactory) {
        this.dir.setLockFactory(lockFactory);
    }

    public LockFactory getLockFactory() {
        return this.dir.getLockFactory();
    }

    public String getLockID() {
        return this.dir.getLockID();
    }

    public void close() throws IOException {
        this.cleanupTaskFuture.cancel(true);
        this.localCacheDir.close();
        this.dir.close();
    }

    public IndexInput openInput(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            return this.dir.openInput(name);
        }
        this.fetchFileIfNotExists(name);
        return this.localCacheDir.openInput(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        if (this.shouldPerformOperationOnActualDirectory(name)) {
            return this.dir.createOutput(name);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)this.logMessage("Creating [" + name + "] in local cache"));
        }
        return new LocalCacheIndexOutput(name, this.localCacheDir.createOutput(name));
    }

    private boolean shouldPerformOperationOnActualDirectory(String name) {
        return LuceneFileNames.isStaticFile(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFileIfNotExists(String name) throws IOException {
        Object object = this.monitors[Math.abs(name.hashCode()) % this.monitors.length];
        synchronized (object) {
            if (this.localCacheDir.fileExists(name)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)this.logMessage("Fetching [" + name + "] to local cache"));
            }
            this.copy(this.dir, this.localCacheDir, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Directory src, Directory dist, String name) throws IOException {
        byte[] buf = new byte[this.bufferSize];
        IndexOutput os = null;
        IndexInput is = null;
        try {
            int toRead;
            os = dist.createOutput(name);
            is = src.openInput(name);
            long len = is.length();
            for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                toRead = readCount + (long)this.bufferSize > len ? (int)(len - readCount) : this.bufferSize;
                is.readBytes(buf, 0, toRead);
                os.writeBytes(buf, toRead);
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWrapper() throws IOException {
        String[] list;
        if (log.isTraceEnabled()) {
            log.trace((Object)this.logMessage("Clearing local cache"));
        }
        for (String name : list = this.localCacheDir.list()) {
            Object object = this.monitors[Math.abs(name.hashCode()) % this.monitors.length];
            synchronized (object) {
                if (this.localCacheDir.fileExists(name)) {
                    this.localCacheDir.deleteFile(name);
                }
            }
        }
    }

    private String logMessage(String message) {
        return "[" + this.subIndex + "] " + message;
    }

    public class LocalCacheIndexOutput
    extends IndexOutput {
        private String name;
        private IndexOutput localCacheIndexOutput;

        public LocalCacheIndexOutput(String name, IndexOutput localCacheIndexOutput) {
            this.name = name;
            this.localCacheIndexOutput = localCacheIndexOutput;
        }

        public void writeByte(byte b) throws IOException {
            this.localCacheIndexOutput.writeByte(b);
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.localCacheIndexOutput.writeBytes(b, offset, length);
        }

        public void seek(long size) throws IOException {
            this.localCacheIndexOutput.seek(size);
        }

        public long length() throws IOException {
            return this.localCacheIndexOutput.length();
        }

        public long getFilePointer() {
            return this.localCacheIndexOutput.getFilePointer();
        }

        public void flush() throws IOException {
            this.localCacheIndexOutput.flush();
        }

        public void close() throws IOException {
            this.localCacheIndexOutput.close();
            if (LocalDirectoryCache.this.localCacheManager.getSearchEngineFactory().getLuceneIndexManager().getStore().isUseCompoundFile() && IndexFileNameFilter.getFilter().isCFSFile(this.name)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)LocalDirectoryCache.this.logMessage("Creating [" + this.name + "] in actual directory"));
            }
            LocalDirectoryCache.this.copy(LocalDirectoryCache.this.localCacheDir, LocalDirectoryCache.this.dir, this.name);
        }
    }

    public class CleanupTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String[] remoteList;
            String[] currentList;
            try {
                currentList = LocalDirectoryCache.this.localCacheDir.list();
                remoteList = LocalDirectoryCache.this.localCacheManager.getSearchEngineFactory().getTransactionContext().execute(new TransactionContextCallback<String[]>(){

                    @Override
                    public String[] doInTransaction() throws CompassException {
                        try {
                            return LocalDirectoryCache.this.dir.list();
                        }
                        catch (IOException e) {
                            log.error((Object)LocalDirectoryCache.this.logMessage("Failed to list directory"), (Throwable)e);
                            return null;
                        }
                    }
                });
                if (remoteList == null) {
                    return;
                }
            }
            catch (IOException e) {
                log.error((Object)LocalDirectoryCache.this.logMessage("Failed to list directory"), (Throwable)e);
                return;
            }
            HashSet<String> filesToCleanUp = new HashSet<String>();
            filesToCleanUp.addAll(Arrays.asList(currentList));
            for (String aRemoteList : remoteList) {
                filesToCleanUp.remove(aRemoteList);
            }
            for (String name : filesToCleanUp) {
                Object object = LocalDirectoryCache.this.monitors[Math.abs(name.hashCode()) % LocalDirectoryCache.this.monitors.length];
                synchronized (object) {
                    block13: {
                        try {
                            if (LocalDirectoryCache.this.localCacheManager.getSearchEngineFactory().getLuceneIndexManager().getStore().isUseCompoundFile() && IndexFileNameFilter.getFilter().isCFSFile(name)) {
                                continue;
                            }
                            if (LocalDirectoryCache.this.localCacheDir.fileExists(name)) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)LocalDirectoryCache.this.logMessage("Clean [" + name + "] from local cache"));
                                }
                                LocalDirectoryCache.this.localCacheDir.deleteFile(name);
                            }
                        }
                        catch (IOException e) {
                            if (!log.isDebugEnabled()) break block13;
                            log.debug((Object)LocalDirectoryCache.this.logMessage("Failed to clean local file [" + name + "]"), (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

