/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.lucene.engine.queryparser.QueryHolder;

public class LuceneSearchEngineQueryStringBuilder
implements SearchEngineQueryBuilder.SearchEngineQueryStringBuilder {
    private LuceneSearchEngineFactory searchEngineFactory;
    private Analyzer analyzer;
    private String defaultSearchProperty;
    private String queryString;
    private QueryParser.Operator operator;
    private LuceneQueryParser queryParser;
    private boolean forceAnalyzer;

    public LuceneSearchEngineQueryStringBuilder(LuceneSearchEngineFactory searchEngineFactory, String queryString) {
        this.searchEngineFactory = searchEngineFactory;
        this.queryString = queryString;
        this.analyzer = searchEngineFactory.getAnalyzerManager().getSearchAnalyzer();
        this.queryParser = searchEngineFactory.getQueryParserManager().getDefaultQueryParser();
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzer(String analyzer) {
        this.analyzer = this.searchEngineFactory.getAnalyzerManager().getAnalyzerMustExist(analyzer);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzerByAlias(String alias) {
        this.analyzer = this.searchEngineFactory.getAnalyzerManager().getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
        this.defaultSearchProperty = defaultSearchProperty;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder useAndDefaultOperator() {
        this.operator = QueryParser.Operator.AND;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder useOrDefaultOperator() {
        this.operator = QueryParser.Operator.OR;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder forceAnalyzer() {
        this.forceAnalyzer = true;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setQueryParser(String queryParser) {
        this.queryParser = this.searchEngineFactory.getQueryParserManager().getQueryParser(queryParser);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder useSpellCheck() {
        return this.setQueryParser("spellcheck");
    }

    public SearchEngineQuery toQuery() {
        String defaultSearch = this.defaultSearchProperty;
        if (defaultSearch == null) {
            defaultSearch = this.searchEngineFactory.getLuceneSettings().getDefaultSearchPropery();
        }
        QueryHolder qQuery = this.queryParser.parse(defaultSearch, this.operator, this.analyzer, this.forceAnalyzer, this.queryString);
        return new LuceneSearchEngineQuery(this.searchEngineFactory, qQuery, defaultSearch);
    }
}

