/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.json;

import java.util.Iterator;
import org.compass.core.Resource;
import org.compass.core.converter.mapping.json.AbstractDynamicJsonMappingConverter;
import org.compass.core.json.JsonObject;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.json.JsonObjectMapping;
import org.compass.core.mapping.json.Naming;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractJsonObjectMappingConverter
extends AbstractDynamicJsonMappingConverter {
    protected boolean doMarshall(Resource resource, JsonObject jsonObject, JsonObjectMapping mapping, MarshallingContext context) {
        boolean store = false;
        Iterator<Mapping> it = mapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            Object value = jsonObject.opt(m.getName());
            if (value != null && jsonObject.isNullValue(value)) {
                value = null;
            }
            store |= m.getConverter().marshall(resource, value, m, context);
        }
        if (mapping.isDynamic()) {
            Iterator<String> keyIt = jsonObject.keys();
            while (keyIt.hasNext()) {
                String key = keyIt.next();
                if (mapping.getMapping(key) != null) continue;
                Naming oldNaming = null;
                if (mapping.getDynamicNaming() != null) {
                    oldNaming = (Naming)((Object)context.setAttribute("$jsonDynamicNaming", (Object)mapping.getDynamicNaming()));
                }
                this.doConvertDynamicValue(resource, key, jsonObject.opt(key), context);
                if (mapping.getDynamicNaming() == null) continue;
                context.setAttribute("$jsonDynamicNaming", (Object)oldNaming);
            }
        }
        return store;
    }
}

