/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.importers.mediawiki;

import com.liferay.documentlibrary.service.DLLocalServiceUtil;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.wiki.ImportFilesException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.translators.MediaWikiToCreoleTranslator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiImporter
implements WikiImporter {
    public static final String SHARED_IMAGES_CONTENT = "See attachments";
    public static final String SHARED_IMAGES_TITLE = "SharedImages";
    private static final String[] _SPECIAL_MEDIA_WIKI_DIRS = new String[]{"thumb", "temp", "archive"};
    private static final String _WORK_IN_PROGRESS = "{{Work in progress}}";
    private static final String _WORK_IN_PROGRESS_TAG = "work in progress";
    private static Log _log = LogFactoryUtil.getLog(MediaWikiImporter.class);
    private static Pattern _categoriesPattern = Pattern.compile("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*");
    private static Pattern _parentPattern = Pattern.compile("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}");
    private static Pattern _redirectPattern = Pattern.compile("#REDIRECT \\[\\[([^\\]]*)\\]\\]");
    private MediaWikiToCreoleTranslator _translator = new MediaWikiToCreoleTranslator();

    @Override
    public void importPages(long userId, WikiNode node, File[] files, Map<String, String[]> options) throws PortalException {
        if (files.length < 1 || files[0] == null || !files[0].exists()) {
            throw new PortalException("The pages file is mandatory");
        }
        File pagesFile = files[0];
        File usersFile = files[1];
        File imagesFile = files[2];
        try {
            Document doc = SAXReaderUtil.read((File)pagesFile);
            Map<String, String> usersMap = this.readUsersFile(usersFile);
            Element root = doc.getRootElement();
            List<String> specialNamespaces = this.readSpecialNamespaces(root);
            this.processSpecialPages(userId, node, root, specialNamespaces);
            this.processRegularPages(userId, node, root, specialNamespaces, usersMap, imagesFile, options);
            this.processImages(userId, node, imagesFile);
            this.moveFrontPage(userId, node, options);
        }
        catch (DocumentException documentException) {
            throw new ImportFilesException("Invalid XML file provided");
        }
        catch (IOException iOException) {
            throw new ImportFilesException("Error reading the files provided");
        }
        catch (PortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected long getUserId(long userId, WikiNode node, String author, Map<String, String> usersMap) throws PortalException, SystemException {
        User user = null;
        String emailAddress = usersMap.get(author);
        try {
            user = Validator.isNull((String)emailAddress) ? UserLocalServiceUtil.getUserByScreenName((long)node.getCompanyId(), (String)author.toLowerCase()) : UserLocalServiceUtil.getUserByEmailAddress((long)node.getCompanyId(), (String)emailAddress);
        }
        catch (NoSuchUserException noSuchUserException) {
            user = UserLocalServiceUtil.getUserById((long)userId);
        }
        return user.getUserId();
    }

    protected void importPage(long userId, String author, WikiNode node, String title, String content, String summary, Map<String, String> usersMap) throws PortalException {
        try {
            long authorUserId = this.getUserId(userId, node, author, usersMap);
            String parentTitle = this.readParentTitle(content);
            String redirectTitle = this.readRedirectTitle(content);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAssetTagNames(this.readAssetTagNames(userId, node, content));
            content = Validator.isNull((String)redirectTitle) ? this._translator.translate(content) : "[[" + redirectTitle + "]]";
            WikiPage page = null;
            try {
                page = WikiPageLocalServiceUtil.getPage((long)node.getNodeId(), (String)title);
            }
            catch (NoSuchPageException noSuchPageException) {
                page = WikiPageLocalServiceUtil.addPage((long)authorUserId, (long)node.getNodeId(), (String)title, (String)"New", null, (boolean)true, (ServiceContext)serviceContext);
            }
            WikiPageLocalServiceUtil.updatePage((long)authorUserId, (long)node.getNodeId(), (String)title, (double)page.getVersion(), (String)content, (String)summary, (boolean)true, (String)"creole", (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            throw new PortalException("Error importing page " + title, (Throwable)e);
        }
    }

    protected boolean isSpecialMediaWikiPage(String title, List<String> specialNamespaces) {
        for (String namespace : specialNamespaces) {
            if (!title.startsWith(String.valueOf(namespace) + ":")) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidImage(String[] paths, byte[] bytes) {
        if (ArrayUtil.contains((Object[])_SPECIAL_MEDIA_WIKI_DIRS, (Object)paths[0])) {
            return false;
        }
        if (paths.length > 1 && ArrayUtil.contains((Object[])_SPECIAL_MEDIA_WIKI_DIRS, (Object)paths[1])) {
            return false;
        }
        String fileName = paths[paths.length - 1];
        try {
            DLLocalServiceUtil.validate((String)fileName, (boolean)true, (byte[])bytes);
        }
        catch (PortalException portalException) {
            return false;
        }
        catch (SystemException systemException) {
            return false;
        }
        return true;
    }

    protected void moveFrontPage(long userId, WikiNode node, Map<String, String[]> options) {
        block4: {
            String frontPageTitle = MapUtil.getString(options, (String)"OPTIONS_FRONT_PAGE");
            if (Validator.isNotNull((String)frontPageTitle)) {
                frontPageTitle = this.normalizeTitle(frontPageTitle);
                try {
                    if (WikiPageLocalServiceUtil.getPagesCount((long)node.getNodeId(), (String)frontPageTitle, (boolean)true) > 0) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setAddCommunityPermissions(true);
                        serviceContext.setAddGuestPermissions(true);
                        WikiPageLocalServiceUtil.movePage((long)userId, (long)node.getNodeId(), (String)frontPageTitle, (String)WikiPageConstants.FRONT_PAGE, (boolean)false, (ServiceContext)serviceContext);
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    StringBundler sb = new StringBundler(4);
                    sb.append("Could not move ");
                    sb.append(WikiPageConstants.FRONT_PAGE);
                    sb.append(" to the title provided: ");
                    sb.append(frontPageTitle);
                    _log.warn((Object)sb.toString(), (Throwable)e);
                }
            }
        }
    }

    protected String normalize(String categoryName, int length) {
        categoryName = AssetUtil.toWord(categoryName.trim());
        return StringUtil.shorten((String)categoryName, (int)length);
    }

    protected String normalizeDescription(String description) {
        description = description.replaceAll(_categoriesPattern.pattern(), "");
        return this.normalize(description, 300);
    }

    protected String normalizeTitle(String title) {
        title = title.replaceAll(PropsValues.WIKI_PAGE_TITLES_REMOVE_REGEXP, "");
        return StringUtil.shorten((String)title, (int)75);
    }

    protected void processImages(long userId, WikiNode node, File imagesFile) throws Exception {
        if (imagesFile == null || !imagesFile.exists()) {
            return;
        }
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)imagesFile);
        List entries = zipReader.getEntries();
        int total = entries.size();
        if (total > 0) {
            try {
                WikiPageLocalServiceUtil.getPage((long)node.getNodeId(), (String)SHARED_IMAGES_TITLE);
            }
            catch (NoSuchPageException noSuchPageException) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                WikiPageLocalServiceUtil.addPage((long)userId, (long)node.getNodeId(), (String)SHARED_IMAGES_TITLE, (String)SHARED_IMAGES_CONTENT, null, (boolean)true, (ServiceContext)serviceContext);
            }
        }
        ArrayList<ObjectValuePair> attachments = new ArrayList<ObjectValuePair>();
        int percentage = 50;
        int i = 0;
        while (i < entries.size()) {
            String entry;
            String key = entry = (String)entries.get(i);
            byte[] value = zipReader.getEntryAsByteArray(entry);
            String[] paths = StringUtil.split((String)key, (String)"/");
            if (!this.isValidImage(paths, value)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Ignoring " + key));
                }
            } else {
                String fileName = paths[paths.length - 1].toLowerCase();
                attachments.add(new ObjectValuePair((Object)fileName, (Object)value));
                ++count;
                if (i % 5 == 0) {
                    WikiPageLocalServiceUtil.addPageAttachments((long)node.getNodeId(), (String)SHARED_IMAGES_TITLE, attachments);
                    attachments.clear();
                    percentage = Math.min(50 + i * 50 / total, 99);
                    progressTracker.updateProgress(percentage);
                }
            }
            ++i;
        }
        if (!attachments.isEmpty()) {
            WikiPageLocalServiceUtil.addPageAttachments((long)node.getNodeId(), (String)SHARED_IMAGES_TITLE, attachments);
        }
        zipReader.close();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported " + count + " images into " + node.getName()));
        }
    }

    protected void processRegularPages(long userId, WikiNode node, Element root, List<String> specialNamespaces, Map<String, String> usersMap, File imagesFile, Map<String, String[]> options) {
        boolean importLatestVersion = MapUtil.getBoolean(options, (String)"OPTIONS_IMPORT_LATEST_VERSION");
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        List pages = root.elements("page");
        int total = pages.size();
        Iterator itr = root.elements("page").iterator();
        int percentage = 10;
        int maxPercentage = 50;
        if (imagesFile == null || !imagesFile.exists()) {
            maxPercentage = 99;
        }
        int percentageRange = maxPercentage - percentage;
        int i = 0;
        while (itr.hasNext()) {
            Element pageEl = (Element)itr.next();
            String title = pageEl.elementText("title");
            title = this.normalizeTitle(title);
            percentage = Math.min(10 + i * percentageRange / total, maxPercentage);
            progressTracker.updateProgress(percentage);
            if (!this.isSpecialMediaWikiPage(title, specialNamespaces)) {
                ArrayList<Element> revisionEls = pageEl.elements("revision");
                if (importLatestVersion) {
                    Element lastRevisionEl = (Element)revisionEls.get(revisionEls.size() - 1);
                    revisionEls = new ArrayList<Element>();
                    revisionEls.add(lastRevisionEl);
                }
                for (Element curRevisionEl : revisionEls) {
                    String author = curRevisionEl.element("contributor").elementText("username");
                    String content = curRevisionEl.elementText("text");
                    String summary = curRevisionEl.elementText("comment");
                    try {
                        this.importPage(userId, author, node, title, content, summary, usersMap);
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) continue;
                        StringBundler sb = new StringBundler(3);
                        sb.append("Page with title ");
                        sb.append(title);
                        sb.append(" could not be imported");
                        _log.warn((Object)sb.toString(), (Throwable)e);
                    }
                }
                ++count;
            }
            ++i;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported " + count + " pages into " + node.getName()));
        }
    }

    protected void processSpecialPages(long userId, WikiNode node, Element root, List<String> specialNamespaces) throws PortalException {
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        List pages = root.elements("page");
        int total = pages.size();
        Iterator itr = pages.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Element page = (Element)itr.next();
            String title = page.elementText("title");
            if (!title.startsWith("Category:")) {
                if (this.isSpecialMediaWikiPage(title, specialNamespaces)) {
                    root.remove(page);
                }
            } else {
                String categoryName = title.substring("Category:".length());
                categoryName = this.normalize(categoryName, 75);
                String description = page.element("revision").elementText("text");
                description = this.normalizeDescription(description);
                try {
                    AssetTag assetTag = null;
                    try {
                        assetTag = AssetTagLocalServiceUtil.getTag((long)node.getCompanyId(), (String)categoryName);
                    }
                    catch (NoSuchTagException noSuchTagException) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setAddCommunityPermissions(true);
                        serviceContext.setAddGuestPermissions(true);
                        serviceContext.setScopeGroupId(node.getGroupId());
                        assetTag = AssetTagLocalServiceUtil.addTag((long)userId, (String)categoryName, null, (ServiceContext)serviceContext);
                    }
                    if (Validator.isNotNull((String)description)) {
                        AssetTagPropertyLocalServiceUtil.addTagProperty((long)userId, (long)assetTag.getTagId(), (String)"description", (String)description);
                    }
                }
                catch (SystemException se) {
                    _log.error((Object)se, (Throwable)se);
                }
                if (i % 5 == 0) {
                    progressTracker.updateProgress(i * 10 / total);
                }
            }
            ++i;
        }
    }

    protected String[] readAssetTagNames(long userId, WikiNode node, String content) throws PortalException, SystemException {
        Matcher matcher = _categoriesPattern.matcher(content);
        ArrayList<String> assetTagNames = new ArrayList<String>();
        while (matcher.find()) {
            String categoryName = matcher.group(1);
            categoryName = this.normalize(categoryName, 75);
            AssetTag assetTag = null;
            try {
                assetTag = AssetTagLocalServiceUtil.getTag((long)node.getGroupId(), (String)categoryName);
            }
            catch (NoSuchTagException noSuchTagException) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(node.getGroupId());
                assetTag = AssetTagLocalServiceUtil.addTag((long)userId, (String)categoryName, null, (ServiceContext)serviceContext);
            }
            assetTagNames.add(assetTag.getName());
        }
        if (content.indexOf(_WORK_IN_PROGRESS) != -1) {
            assetTagNames.add(_WORK_IN_PROGRESS_TAG);
        }
        return assetTagNames.toArray(new String[assetTagNames.size()]);
    }

    protected String readParentTitle(String content) {
        Matcher matcher = _parentPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this.normalizeTitle(redirectTitle);
            redirectTitle = String.valueOf(redirectTitle) + " (disambiguation)";
        }
        return redirectTitle;
    }

    protected String readRedirectTitle(String content) {
        Matcher matcher = _redirectPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this.normalizeTitle(redirectTitle);
        }
        return redirectTitle;
    }

    protected List<String> readSpecialNamespaces(Element root) throws ImportFilesException {
        ArrayList<String> namespaces = new ArrayList<String>();
        Element siteinfoEl = root.element("siteinfo");
        if (siteinfoEl == null) {
            throw new ImportFilesException("Invalid pages XML file");
        }
        for (Element namespace : siteinfoEl.element("namespaces").elements("namespace")) {
            if (namespace.attribute("key").getData().equals("0")) continue;
            namespaces.add(namespace.getText());
        }
        return namespaces;
    }

    protected Map<String, String> readUsersFile(File usersFile) throws IOException {
        if (usersFile == null || !usersFile.exists()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> usersMap = new HashMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(usersFile));
        String line = unsyncBufferedReader.readLine();
        while (line != null) {
            String[] array = StringUtil.split((String)line);
            if (array.length == 2 && Validator.isNotNull((String)array[0]) && Validator.isNotNull((String)array[1])) {
                usersMap.put(array[0], array[1]);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Ignoring line " + line + " because it does not contain exactly 2 columns"));
            }
            line = unsyncBufferedReader.readLine();
        }
        return usersMap;
    }
}

