/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("display-settings")) {
            this.updateDisplaySettings(actionRequest, preferences);
        } else if (tabs2.equals("email-from")) {
            this.updateEmailFrom(actionRequest, preferences);
        } else if (tabs2.equals("page-added-email")) {
            this.updateEmailPageAdded(actionRequest, preferences);
        } else if (tabs2.equals("page-updated-email")) {
            this.updateEmailPageUpdated(actionRequest, preferences);
        } else if (tabs2.equals("rss")) {
            this.updateRSS(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/wiki/configuration.jsp";
    }

    protected void updateDisplaySettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean enablePageRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enablePageRatings");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        boolean enableCommentRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableCommentRatings");
        String visibleNodes = ParamUtil.getString((PortletRequest)actionRequest, (String)"visibleNodes");
        String hiddenNodes = ParamUtil.getString((PortletRequest)actionRequest, (String)"hiddenNodes");
        if (Validator.isNull((String)visibleNodes)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"visibleNodesCount");
        } else {
            preferences.setValue("enable-page-ratings", String.valueOf(enablePageRatings));
            preferences.setValue("enable-comments", String.valueOf(enableComments));
            preferences.setValue("enable-comment-ratings", String.valueOf(enableCommentRatings));
            preferences.setValue("visible-nodes", visibleNodes);
            preferences.setValue("hidden-nodes", hiddenNodes);
        }
    }

    protected void updateEmailFrom(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String emailFromName = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromName");
        String emailFromAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress) && !Validator.isVariableTerm((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        } else {
            preferences.setValue("email-from-name", emailFromName);
            preferences.setValue("email-from-address", emailFromAddress);
        }
    }

    protected void updateEmailPageAdded(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailPageAddedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailPageAddedEnabled");
        String emailPageAddedSubjectPrefix = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageAddedSubjectPrefix");
        String emailPageAddedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageAddedBody");
        String emailPageAddedSignature = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageAddedSignature");
        if (Validator.isNull((String)emailPageAddedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailPageAddedSubjectPrefix");
        } else if (Validator.isNull((String)emailPageAddedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailPageAddedBody");
        } else {
            preferences.setValue("email-page-added-enabled", String.valueOf(emailPageAddedEnabled));
            preferences.setValue("email-page-added-subject-prefix", emailPageAddedSubjectPrefix);
            preferences.setValue("email-page-added-body", emailPageAddedBody);
            preferences.setValue("email-page-added-signature", emailPageAddedSignature);
        }
    }

    protected void updateEmailPageUpdated(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailPageUpdatedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailPageUpdatedEnabled");
        String emailPageUpdatedSubjectPrefix = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageUpdatedSubjectPrefix");
        String emailPageUpdatedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageUpdatedBody");
        String emailPageUpdatedSignature = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailPageUpdatedSignature");
        if (Validator.isNull((String)emailPageUpdatedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailPageUpdatedSubjectPrefix");
        } else if (Validator.isNull((String)emailPageUpdatedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailPageUpdatedBody");
        } else {
            preferences.setValue("email-page-updated-enabled", String.valueOf(emailPageUpdatedEnabled));
            preferences.setValue("email-page-updated-subject-prefix", emailPageUpdatedSubjectPrefix);
            preferences.setValue("email-page-updated-body", emailPageUpdatedBody);
            preferences.setValue("email-page-updated-signature", emailPageUpdatedSignature);
        }
    }

    protected void updateRSS(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        int rssDelta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"rssDelta");
        String rssDisplayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssDisplayStyle");
        preferences.setValue("rss-delta", String.valueOf(rssDelta));
        preferences.setValue("rss-display-style", rssDisplayStyle);
    }
}

