/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.social.RelationUserIdException;
import com.liferay.portlet.social.model.SocialRelation;
import com.liferay.portlet.social.model.SocialRelationConstants;
import com.liferay.portlet.social.service.base.SocialRelationLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialRelationLocalServiceImpl
extends SocialRelationLocalServiceBaseImpl {
    public SocialRelation addRelation(long userId1, long userId2, int type) throws PortalException, SystemException {
        SocialRelation biRelation;
        if (userId1 == userId2) {
            throw new RelationUserIdException();
        }
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        User user2 = this.userPersistence.findByPrimaryKey(userId2);
        if (user1.getCompanyId() != user2.getCompanyId()) {
            throw new RelationUserIdException();
        }
        SocialRelation relation = this.socialRelationPersistence.fetchByU1_U2_T(userId1, userId2, type);
        if (relation == null) {
            long relationId = this.counterLocalService.increment();
            relation = this.socialRelationPersistence.create(relationId);
            relation.setCompanyId(user1.getCompanyId());
            relation.setCreateDate(System.currentTimeMillis());
            relation.setUserId1(userId1);
            relation.setUserId2(userId2);
            relation.setType(type);
            this.socialRelationPersistence.update((BaseModel)relation, false);
        }
        if (SocialRelationConstants.isTypeBi((int)type) && (biRelation = this.socialRelationPersistence.fetchByU1_U2_T(userId2, userId1, type)) == null) {
            long biRelationId = this.counterLocalService.increment();
            biRelation = this.socialRelationPersistence.create(biRelationId);
            biRelation.setCompanyId(user1.getCompanyId());
            biRelation.setCreateDate(System.currentTimeMillis());
            biRelation.setUserId1(userId2);
            biRelation.setUserId2(userId1);
            biRelation.setType(type);
            this.socialRelationPersistence.update((BaseModel)biRelation, false);
        }
        return relation;
    }

    public void deleteRelation(long relationId) throws PortalException, SystemException {
        SocialRelation relation = this.socialRelationPersistence.findByPrimaryKey(relationId);
        this.deleteRelation(relation);
    }

    public void deleteRelation(long userId1, long userId2, int type) throws PortalException, SystemException {
        SocialRelation relation = this.socialRelationPersistence.findByU1_U2_T(userId1, userId2, type);
        this.deleteRelation(relation);
    }

    public void deleteRelation(SocialRelation relation) throws PortalException, SystemException {
        this.socialRelationPersistence.remove((BaseModel)relation);
        if (SocialRelationConstants.isTypeBi((int)relation.getType())) {
            SocialRelation biRelation = this.socialRelationPersistence.findByU1_U2_T(relation.getUserId2(), relation.getUserId1(), relation.getType());
            this.socialRelationPersistence.remove((BaseModel)biRelation);
        }
    }

    public void deleteRelations(long userId) throws SystemException {
        this.socialRelationPersistence.removeByUserId1(userId);
        this.socialRelationPersistence.removeByUserId2(userId);
    }

    public SocialRelation getRelation(long relationId) throws PortalException, SystemException {
        return this.socialRelationPersistence.findByPrimaryKey(relationId);
    }

    public SocialRelation getRelation(long userId1, long userId2, int type) throws PortalException, SystemException {
        return this.socialRelationPersistence.findByU1_U2_T(userId1, userId2, type);
    }

    public List<SocialRelation> getRelations(long userId, int type, int start, int end) throws SystemException {
        return this.socialRelationPersistence.findByU1_T(userId, type, start, end);
    }

    public int getRelationsCount(long userId, int type) throws SystemException {
        return this.socialRelationPersistence.countByU1_T(userId, type);
    }

    public boolean hasRelation(long userId1, long userId2, int type) throws SystemException {
        SocialRelation relation = this.socialRelationPersistence.fetchByU1_U2_T(userId1, userId2, type);
        return relation != null;
    }

    public boolean isRelatable(long userId1, long userId2, int type) throws SystemException {
        if (userId1 == userId2) {
            return false;
        }
        User user1 = this.userPersistence.fetchByPrimaryKey(userId1);
        if (user1 == null || user1.isDefaultUser()) {
            return false;
        }
        User user2 = this.userPersistence.fetchByPrimaryKey(userId2);
        if (user2 == null || user2.isDefaultUser()) {
            return false;
        }
        return !this.hasRelation(userId1, userId2, type);
    }
}

