/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialEquityActionMapping;
import com.liferay.portlet.social.model.SocialEquitySetting;
import com.liferay.portlet.social.model.impl.SocialEquitySettingImpl;
import com.liferay.portlet.social.service.base.SocialEquitySettingLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialEquitySettingLocalServiceImpl
extends SocialEquitySettingLocalServiceBaseImpl {
    public static final String CACHE_NAME = SocialEquitySettingLocalServiceImpl.class.getName();
    private static PortalCache _portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME);

    public List<SocialEquitySetting> getEquitySettings(long groupId, String className, String actionId) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getEquitySettings(groupId, classNameId, actionId);
    }

    public List<SocialEquitySetting> getEquitySettings(long groupId, long classNameId, String actionId) throws SystemException {
        String key = this.encodeKey(classNameId, actionId);
        List socialEquitySettings = (List)_portalCache.get(key);
        if (socialEquitySettings != null) {
            return socialEquitySettings;
        }
        String className = PortalUtil.getClassName((long)classNameId);
        SocialEquityActionMapping equityActionMapping = ResourceActionsUtil.getSocialEquityActionMapping(className, actionId);
        if (equityActionMapping == null) {
            socialEquitySettings = Collections.EMPTY_LIST;
            _portalCache.put(key, (Object)socialEquitySettings);
            return socialEquitySettings;
        }
        List equitySettings = this.socialEquitySettingPersistence.findByG_C_A(groupId, classNameId, actionId);
        if ((equitySettings = ListUtil.copy((List)equitySettings)).isEmpty()) {
            if (equityActionMapping.getInformationValue() > 0) {
                SocialEquitySetting informationEquitySetting = this.getInformationEquitySetting(actionId, equityActionMapping);
                equitySettings.add(informationEquitySetting);
            }
            if (equityActionMapping.getParticipationValue() > 0) {
                SocialEquitySetting participationEquitySetting = this.getParticipationEquitySetting(actionId, equityActionMapping);
                equitySettings.add(participationEquitySetting);
            }
        } else if (equitySettings.size() == 1) {
            SocialEquitySetting equitySetting = (SocialEquitySetting)equitySettings.get(0);
            if (equityActionMapping.getInformationValue() > 0 && equitySetting.getType() == 2) {
                SocialEquitySetting informationEquitySetting = this.getInformationEquitySetting(actionId, equityActionMapping);
                equitySettings.add(informationEquitySetting);
            } else if (equityActionMapping.getParticipationValue() > 0 && equitySetting.getType() == 1) {
                SocialEquitySetting participationEquitySetting = this.getParticipationEquitySetting(actionId, equityActionMapping);
                equitySettings.add(participationEquitySetting);
            }
        }
        _portalCache.put(key, (Object)socialEquitySettings);
        return equitySettings;
    }

    public void updateEquitySettings(long groupId, String className, List<SocialEquityActionMapping> equityActionMappings) throws PortalException, SystemException {
        for (SocialEquityActionMapping equityActionMapping : equityActionMappings) {
            this.updateEquitySettings(groupId, className, equityActionMapping);
        }
    }

    protected String encodeKey(long classNameId, String actionId) {
        StringBundler sb = new StringBundler(5);
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(classNameId);
        sb.append("#");
        sb.append(actionId);
        return sb.toString();
    }

    protected SocialEquitySetting getInformationEquitySetting(String actionId, SocialEquityActionMapping equityActionMapping) {
        SocialEquitySettingImpl equitySetting = new SocialEquitySettingImpl();
        equitySetting.setActionId(actionId);
        equitySetting.setDailyLimit(equityActionMapping.getInformationDailyLimit());
        equitySetting.setLifespan(equityActionMapping.getInformationLifespan());
        equitySetting.setType(1);
        equitySetting.setUniqueEntry(equityActionMapping.isUnique());
        equitySetting.setValue(equityActionMapping.getInformationValue());
        return equitySetting;
    }

    protected SocialEquitySetting getParticipationEquitySetting(String actionId, SocialEquityActionMapping equityActionMapping) {
        SocialEquitySettingImpl equitySetting = new SocialEquitySettingImpl();
        equitySetting.setActionId(actionId);
        equitySetting.setDailyLimit(equityActionMapping.getParticipationDailyLimit());
        equitySetting.setLifespan(equityActionMapping.getParticipationLifespan());
        equitySetting.setType(2);
        equitySetting.setUniqueEntry(equityActionMapping.isUnique());
        equitySetting.setValue(equityActionMapping.getParticipationValue());
        return equitySetting;
    }

    protected void updateEquitySettings(long groupId, String className, SocialEquityActionMapping equityActionMapping) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List<SocialEquitySetting> equitySettings = this.getEquitySettings(groupId, className, equityActionMapping.getActionId());
        for (SocialEquitySetting equitySetting : equitySettings) {
            if (equityActionMapping.equals(equitySetting)) continue;
            equitySetting.update(equityActionMapping);
            if (equitySetting.getPrimaryKey() == 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                equitySetting.setEquitySettingId(this.counterLocalService.increment());
                equitySetting.setGroupId(groupId);
                equitySetting.setCompanyId(group.getCompanyId());
                equitySetting.setClassNameId(classNameId);
            }
            this.socialEquitySettingPersistence.update((BaseModel)equitySetting, false);
        }
        String key = this.encodeKey(classNameId, equityActionMapping.getActionId());
        _portalCache.remove(key);
    }
}

