/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.util.Encryptor;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginUtil {
    private static Log _log = LogFactoryUtil.getLog(LoginUtil.class);

    public static String getLogin(HttpServletRequest request, String paramName, Company company) throws SystemException {
        String login = request.getParameter(paramName);
        if (login == null || login.equals("null")) {
            login = GetterUtil.getString((String)CookieKeys.getCookie(request, "LOGIN"));
            if (PropsValues.COMPANY_LOGIN_PREPOPULATE_DOMAIN && Validator.isNull((String)login) && company.getAuthType().equals("emailAddress")) {
                login = "@" + company.getMx();
            }
        }
        return login;
    }

    public static PortletURL getLoginURL(HttpServletRequest request, long plid) throws PortletModeException, WindowStateException {
        PortletURLImpl portletURL = new PortletURLImpl(request, "58", plid, "RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setParameter("saveLastPath", "0");
        portletURL.setParameter("struts_action", "/login/login");
        return portletURL;
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String login, String password, boolean rememberMe, String authType) throws Exception {
        boolean secure;
        Cookie screenNameCookie;
        Cookie loginCookie;
        Cookie rememberMeCookie;
        Cookie passwordCookie;
        Cookie idCookie;
        Cookie companyIdCookie;
        CookieKeys.validateSupportCookie(request);
        HttpSession session = request.getSession();
        long userId = GetterUtil.getLong((String)login);
        int authResult = -1;
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        HashMap<String, String[]> headerMap = new HashMap<String, String[]>();
        Enumeration enu1 = request.getHeaderNames();
        while (enu1.hasMoreElements()) {
            String name = (String)enu1.nextElement();
            Enumeration enu2 = request.getHeaders(name);
            ArrayList<String> headers = new ArrayList<String>();
            while (enu2.hasMoreElements()) {
                String value = (String)enu2.nextElement();
                headers.add(value);
            }
            headerMap.put(name, headers.toArray(new String[headers.size()]));
        }
        Map parameterMap = request.getParameterMap();
        if (Validator.isNull((String)authType)) {
            authType = company.getAuthType();
        }
        if (authType.equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap);
            userId = UserLocalServiceUtil.getUserIdByEmailAddress((long)company.getCompanyId(), (String)login);
        } else if (authType.equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap);
            userId = UserLocalServiceUtil.getUserIdByScreenName((long)company.getCompanyId(), (String)login);
        } else if (authType.equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)userId, (String)password, headerMap, (Map)parameterMap);
        }
        if (authResult == 1) {
            Boolean httpsInitial;
            if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
                Object protectedAttributeValue;
                String protectedAttributeName;
                int n;
                int n2;
                String[] stringArray;
                HashMap<String, Object> protectedAttributes;
                String[] protectedAttributeNames;
                block28: {
                    protectedAttributeNames = PropsValues.SESSION_PHISHING_PROTECTED_ATTRIBUTES;
                    protectedAttributes = new HashMap<String, Object>();
                    stringArray = protectedAttributeNames;
                    n2 = protectedAttributeNames.length;
                    n = 0;
                    while (n < n2) {
                        protectedAttributeName = stringArray[n];
                        protectedAttributeValue = session.getAttribute(protectedAttributeName);
                        if (protectedAttributeValue != null) {
                            protectedAttributes.put(protectedAttributeName, protectedAttributeValue);
                        }
                        ++n;
                    }
                    try {
                        session.invalidate();
                    }
                    catch (IllegalStateException ise) {
                        if (!_log.isWarnEnabled()) break block28;
                        _log.warn((Object)ise.getMessage());
                    }
                }
                session = request.getSession(true);
                stringArray = protectedAttributeNames;
                n2 = protectedAttributeNames.length;
                n = 0;
                while (n < n2) {
                    protectedAttributeName = stringArray[n];
                    protectedAttributeValue = protectedAttributes.get(protectedAttributeName);
                    if (protectedAttributeValue != null) {
                        session.setAttribute(protectedAttributeName, protectedAttributeValue);
                    }
                    ++n;
                }
            }
            String domain = CookieKeys.getDomain(request);
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String userIdString = String.valueOf(userId);
            session.setAttribute("j_username", (Object)userIdString);
            session.setAttribute("j_password", (Object)user.getPassword());
            session.setAttribute("j_remoteuser", (Object)userIdString);
            if (PropsValues.SESSION_STORE_PASSWORD) {
                session.setAttribute("USER_PASSWORD", (Object)password);
            }
            companyIdCookie = new Cookie("COMPANY_ID", String.valueOf(company.getCompanyId()));
            if (Validator.isNotNull((String)domain)) {
                companyIdCookie.setDomain(domain);
            }
            companyIdCookie.setPath("/");
            idCookie = new Cookie("ID", UserLocalServiceUtil.encryptUserId((String)userIdString));
            if (Validator.isNotNull((String)domain)) {
                idCookie.setDomain(domain);
            }
            idCookie.setPath("/");
            passwordCookie = new Cookie("PASSWORD", Encryptor.encrypt((Key)company.getKeyObj(), (String)password));
            if (Validator.isNotNull((String)domain)) {
                passwordCookie.setDomain(domain);
            }
            passwordCookie.setPath("/");
            rememberMeCookie = new Cookie("REMEMBER_ME", Boolean.TRUE.toString());
            if (Validator.isNotNull((String)domain)) {
                rememberMeCookie.setDomain(domain);
            }
            rememberMeCookie.setPath("/");
            int loginMaxAge = PropsValues.COMPANY_SECURITY_AUTO_LOGIN_MAX_AGE;
            if (PropsValues.SESSION_DISABLED) {
                rememberMe = true;
            }
            if (rememberMe) {
                companyIdCookie.setMaxAge(loginMaxAge);
                idCookie.setMaxAge(loginMaxAge);
                passwordCookie.setMaxAge(loginMaxAge);
                rememberMeCookie.setMaxAge(loginMaxAge);
            } else {
                companyIdCookie.setMaxAge(-1);
                idCookie.setMaxAge(-1);
                passwordCookie.setMaxAge(-1);
                rememberMeCookie.setMaxAge(0);
            }
            loginCookie = new Cookie("LOGIN", login);
            if (Validator.isNotNull((String)domain)) {
                loginCookie.setDomain(domain);
            }
            loginCookie.setMaxAge(loginMaxAge);
            loginCookie.setPath("/");
            screenNameCookie = new Cookie("SCREEN_NAME", Encryptor.encrypt((Key)company.getKeyObj(), (String)user.getScreenName()));
            if (Validator.isNotNull((String)domain)) {
                screenNameCookie.setDomain(domain);
            }
            screenNameCookie.setMaxAge(loginMaxAge);
            screenNameCookie.setPath("/");
            secure = request.isSecure();
            if (secure && ((httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL")) == null || !httpsInitial.booleanValue())) {
                secure = false;
            }
        } else {
            throw new AuthException();
        }
        CookieKeys.addCookie(request, response, companyIdCookie, secure);
        CookieKeys.addCookie(request, response, idCookie, secure);
        CookieKeys.addCookie(request, response, passwordCookie, secure);
        CookieKeys.addCookie(request, response, rememberMeCookie, secure);
        CookieKeys.addCookie(request, response, loginCookie, secure);
        CookieKeys.addCookie(request, response, screenNameCookie, secure);
    }

    public static void sendPassword(ActionRequest actionRequest) throws Exception {
        String toAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        LoginUtil.sendPassword(actionRequest, null, null, toAddress, null, null);
    }

    public static void sendPassword(ActionRequest actionRequest, String fromName, String fromAddress, String toAddress, String subject, String body) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isSendPassword()) {
            return;
        }
        String remoteAddr = request.getRemoteAddr();
        String remoteHost = request.getRemoteHost();
        String userAgent = request.getHeader("User-Agent");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        UserLocalServiceUtil.sendPassword((long)company.getCompanyId(), (String)toAddress, (String)remoteAddr, (String)remoteHost, (String)userAgent, (String)fromName, (String)fromAddress, (String)subject, (String)body, (ServiceContext)serviceContext);
        SessionMessages.add((PortletRequest)actionRequest, (String)"request_processed", (Object)toAddress);
    }
}

