/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.imagegallery.DuplicateImageNameException;
import com.liferay.portlet.imagegallery.ImageNameException;
import com.liferay.portlet.imagegallery.ImageSizeException;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGImageImpl;
import com.liferay.portlet.imagegallery.service.base.IGImageLocalServiceBaseImpl;
import com.liferay.portlet.imagegallery.util.comparator.ImageModifiedDateComparator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageLocalServiceImpl
extends IGImageLocalServiceBaseImpl {
    public IGImage addImage(long userId, long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String fileName = file.getName();
            byte[] bytes = FileUtil.getBytes((File)file);
            return this.addImage(userId, groupId, folderId, name, description, fileName, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public IGImage addImage(long userId, long groupId, long folderId, String name, String description, String fileName, byte[] bytes, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String extension = FileUtil.getExtension((String)fileName);
            if (Validator.isNotNull((String)name) && StringUtil.endsWith((String)name, (String)extension)) {
                name = FileUtil.stripExtension((String)name);
            }
            String nameWithExtension = String.valueOf(name) + "." + extension;
            this.validate(groupId, folderId, nameWithExtension, fileName, bytes);
            User user = this.userPersistence.findByPrimaryKey(userId);
            RenderedImage renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
            Date now = new Date();
            long imageId = this.counterLocalService.increment();
            if (Validator.isNull((String)name)) {
                name = String.valueOf(imageId);
            }
            IGImage image = this.igImagePersistence.create(imageId);
            image.setUuid(serviceContext.getUuid());
            image.setGroupId(groupId);
            image.setCompanyId(user.getCompanyId());
            image.setUserId(user.getUserId());
            image.setCreateDate(serviceContext.getCreateDate(now));
            image.setModifiedDate(serviceContext.getModifiedDate(now));
            image.setFolderId(folderId);
            image.setName(name);
            image.setDescription(description);
            image.setSmallImageId(this.counterLocalService.increment());
            image.setLargeImageId(this.counterLocalService.increment());
            if (PropsValues.IG_IMAGE_CUSTOM_1_MAX_DIMENSION > 0) {
                image.setCustom1ImageId(this.counterLocalService.increment());
            }
            if (PropsValues.IG_IMAGE_CUSTOM_2_MAX_DIMENSION > 0) {
                image.setCustom2ImageId(this.counterLocalService.increment());
            }
            image.setExpandoBridgeAttributes(serviceContext);
            this.igImagePersistence.update((BaseModel)image, false);
            if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
                this.addImageResources(image, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
            } else {
                this.addImageResources(image, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
            }
            this.saveImages(image.getLargeImageId(), renderedImage, image.getSmallImageId(), image.getCustom1ImageId(), image.getCustom2ImageId(), bytes, contentType);
            this.updateAsset(userId, image, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), contentType);
            this.socialActivityLocalService.addActivity(userId, image.getGroupId(), IGImage.class.getName(), imageId, 1, "", 0L);
            Indexer indexer = IndexerRegistryUtil.getIndexer(IGImage.class);
            indexer.reindex((Object)image);
            return image;
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public IGImage addImage(long userId, long groupId, long folderId, String name, String description, String fileName, InputStream is, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            return this.addImage(userId, groupId, folderId, name, description, fileName, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addImageResources(IGImage image, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(image.getCompanyId(), image.getGroupId(), image.getUserId(), IGImage.class.getName(), image.getImageId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addImageResources(IGImage image, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(image.getCompanyId(), image.getGroupId(), image.getUserId(), IGImage.class.getName(), image.getImageId(), communityPermissions, guestPermissions);
    }

    public void addImageResources(long imageId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.addImageResources(image, addCommunityPermissions, addGuestPermissions);
    }

    public void addImageResources(long imageId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.addImageResources(image, communityPermissions, guestPermissions);
    }

    public void deleteImage(IGImage image) throws PortalException, SystemException {
        this.igImagePersistence.remove((BaseModel)image);
        this.resourceLocalService.deleteResource(image.getCompanyId(), IGImage.class.getName(), 4, image.getImageId());
        this.imageLocalService.deleteImage(image.getSmallImageId());
        this.imageLocalService.deleteImage(image.getLargeImageId());
        this.imageLocalService.deleteImage(image.getCustom1ImageId());
        this.imageLocalService.deleteImage(image.getCustom2ImageId());
        this.assetEntryLocalService.deleteEntry(IGImage.class.getName(), image.getImageId());
        this.expandoValueLocalService.deleteValues(IGImage.class.getName(), image.getImageId());
        this.socialActivityLocalService.deleteActivities(IGImage.class.getName(), image.getImageId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(IGImage.class);
        indexer.delete((Object)image);
    }

    public void deleteImage(long imageId) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.deleteImage(image);
    }

    public void deleteImages(long groupId, long folderId) throws PortalException, SystemException {
        List images = this.igImagePersistence.findByG_F(groupId, folderId);
        for (IGImage image : images) {
            this.deleteImage(image);
        }
    }

    public int getFoldersImagesCount(long groupId, List<Long> folderIds) throws SystemException {
        return this.igImagePersistence.countByG_F(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()])));
    }

    public List<IGImage> getGroupImages(long groupId, int start, int end) throws SystemException {
        return this.igImagePersistence.findByGroupId(groupId, start, end, (OrderByComparator)new ImageModifiedDateComparator());
    }

    public List<IGImage> getGroupImages(long groupId, long userId, int start, int end) throws SystemException {
        ImageModifiedDateComparator orderByComparator = new ImageModifiedDateComparator();
        if (userId <= 0L) {
            return this.igImagePersistence.findByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.igImagePersistence.findByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupImagesCount(long groupId) throws SystemException {
        return this.igImagePersistence.countByGroupId(groupId);
    }

    public int getGroupImagesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.igImagePersistence.countByGroupId(groupId);
        }
        return this.igImagePersistence.countByG_U(groupId, userId);
    }

    public IGImage getImage(long imageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByPrimaryKey(imageId);
    }

    public IGImage getImageByCustom1ImageId(long custom1ImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByCustom1ImageId(custom1ImageId);
    }

    public IGImage getImageByCustom2ImageId(long custom2ImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByCustom2ImageId(custom2ImageId);
    }

    public IGImage getImageByFolderIdAndNameWithExtension(long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        long imageId;
        IGImage image;
        String name = FileUtil.stripExtension((String)nameWithExtension);
        List images = this.igImagePersistence.findByG_F_N(groupId, folderId, name);
        if (images.size() <= 0 && Validator.isNumber((String)name) && (image = this.igImagePersistence.fetchByPrimaryKey(imageId = GetterUtil.getLong((String)name))) != null) {
            images.add(image);
        }
        for (IGImage image2 : images) {
            if (!nameWithExtension.equals(image2.getNameWithExtension())) continue;
            return image2;
        }
        throw new NoSuchImageException();
    }

    public IGImage getImageByLargeImageId(long largeImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByLargeImageId(largeImageId);
    }

    public IGImage getImageBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findBySmallImageId(smallImageId);
    }

    public IGImage getImageByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        return this.igImagePersistence.findByUUID_G(uuid, groupId);
    }

    public List<IGImage> getImages(long groupId, long folderId) throws SystemException {
        return this.igImagePersistence.findByG_F(groupId, folderId);
    }

    public List<IGImage> getImages(long groupId, long folderId, int start, int end) throws SystemException {
        return this.igImagePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<IGImage> getImages(long groupId, long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.igImagePersistence.findByG_F(groupId, folderId, start, end, obc);
    }

    public int getImagesCount(long groupId, long folderId) throws SystemException {
        return this.igImagePersistence.countByG_F(groupId, folderId);
    }

    public List<IGImage> getNoAssetImages() throws SystemException {
        return this.igImageFinder.findByNoAssets();
    }

    public void updateAsset(long userId, IGImage image, long[] assetCategoryIds, String[] assetTagNames, String contentType) throws PortalException, SystemException {
        Image largeImage = this.imageLocalService.getImage(image.getLargeImageId());
        if (largeImage == null) {
            return;
        }
        if (contentType == null) {
            contentType = MimeTypesUtil.getContentType((String)largeImage.getType());
        }
        this.assetEntryLocalService.updateEntry(userId, image.getGroupId(), IGImage.class.getName(), image.getImageId(), image.getUuid(), assetCategoryIds, assetTagNames, true, null, null, null, null, contentType, image.getName(), image.getDescription(), null, null, largeImage.getHeight(), largeImage.getWidth(), null, false);
    }

    public IGImage updateImage(long userId, long imageId, long groupId, long folderId, String name, String description, byte[] bytes, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
            folderId = this.getFolder(image, folderId);
            RenderedImage renderedImage = null;
            if (bytes != null) {
                renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
                this.validate(bytes);
            }
            if (Validator.isNotNull((String)name) && !name.equals(image.getName())) {
                String nameWithExtension = IGImageImpl.getNameWithExtension(name, image.getImageType());
                this.validate(groupId, folderId, nameWithExtension);
            } else {
                name = image.getName();
            }
            image.setModifiedDate(serviceContext.getModifiedDate(null));
            image.setFolderId(folderId);
            image.setName(name);
            image.setDescription(description);
            image.setExpandoBridgeAttributes(serviceContext);
            this.igImagePersistence.update((BaseModel)image, false);
            if (renderedImage != null) {
                this.saveImages(image.getLargeImageId(), renderedImage, image.getSmallImageId(), image.getCustom1ImageId(), image.getCustom2ImageId(), bytes, contentType);
            }
            long[] assetCategoryIds = serviceContext.getAssetCategoryIds();
            String[] assetTagNames = serviceContext.getAssetTagNames();
            this.updateAsset(userId, image, assetCategoryIds, assetTagNames, contentType);
            this.socialActivityLocalService.addActivity(userId, image.getGroupId(), IGImage.class.getName(), imageId, 2, "", 0L);
            Indexer indexer = IndexerRegistryUtil.getIndexer(IGImage.class);
            indexer.reindex((Object)image);
            return image;
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public IGImage updateImage(long userId, long imageId, long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = null;
            if (file != null && file.exists()) {
                bytes = FileUtil.getBytes((File)file);
            }
            return this.updateImage(userId, imageId, groupId, folderId, name, description, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public IGImage updateImage(long userId, long imageId, long groupId, long folderId, String name, String description, InputStream is, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = null;
            if (is != null) {
                bytes = FileUtil.getBytes((InputStream)is);
            }
            return this.updateImage(userId, imageId, groupId, folderId, name, description, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void updateSmallImage(long smallImageId, long largeImageId) throws PortalException, SystemException {
        try {
            RenderedImage renderedImage = null;
            Image largeImage = this.imageLocalService.getImage(largeImageId);
            byte[] bytes = largeImage.getTextObj();
            String contentType = largeImage.getType();
            if (bytes != null) {
                renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
            }
            if (renderedImage != null) {
                this.saveScaledImage(renderedImage, smallImageId, contentType, PrefsPropsUtil.getInteger("ig.image.thumbnail.max.dimension"));
            }
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    protected long getFolder(IGImage image, long folderId) throws SystemException {
        IGFolder newFolder;
        if (image.getFolderId() != folderId && folderId != 0L && ((newFolder = this.igFolderPersistence.fetchByPrimaryKey(folderId)) == null || image.getGroupId() != newFolder.getGroupId())) {
            folderId = image.getFolderId();
        }
        return folderId;
    }

    protected void saveImages(long largeImageId, RenderedImage renderedImage, long smallImageId, long custom1ImageId, long custom2ImageId, byte[] bytes, String contentType) throws PortalException, SystemException {
        try {
            this.imageLocalService.updateImage(largeImageId, bytes);
            this.saveScaledImage(renderedImage, smallImageId, contentType, PrefsPropsUtil.getInteger("ig.image.thumbnail.max.dimension"));
            if (custom1ImageId > 0L) {
                this.saveScaledImage(renderedImage, custom1ImageId, contentType, PropsValues.IG_IMAGE_CUSTOM_1_MAX_DIMENSION);
            }
            if (custom2ImageId > 0L) {
                this.saveScaledImage(renderedImage, custom2ImageId, contentType, PropsValues.IG_IMAGE_CUSTOM_2_MAX_DIMENSION);
            }
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void saveScaledImage(RenderedImage renderedImage, long imageId, String contentType, int dimension) throws IOException, PortalException, SystemException {
        RenderedImage thumbnail = ImageProcessorUtil.scale((RenderedImage)renderedImage, (int)dimension, (int)dimension);
        this.imageLocalService.updateImage(imageId, ImageProcessorUtil.getBytes((RenderedImage)thumbnail, (String)contentType));
    }

    protected void validate(byte[] bytes) throws ImageSizeException, SystemException {
        if (PrefsPropsUtil.getLong("ig.image.max.size") > 0L && (bytes == null || (long)bytes.length > PrefsPropsUtil.getLong("ig.image.max.size"))) {
            throw new ImageSizeException();
        }
    }

    protected void validate(long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        if (nameWithExtension.indexOf("\\\\") != -1 || nameWithExtension.indexOf("//") != -1 || nameWithExtension.indexOf(":") != -1 || nameWithExtension.indexOf("*") != -1 || nameWithExtension.indexOf("?") != -1 || nameWithExtension.indexOf("\"") != -1 || nameWithExtension.indexOf("<") != -1 || nameWithExtension.indexOf(">") != -1 || nameWithExtension.indexOf("|") != -1 || nameWithExtension.indexOf("[") != -1 || nameWithExtension.indexOf("]") != -1 || nameWithExtension.indexOf("'") != -1) {
            throw new ImageNameException();
        }
        boolean validImageExtension = false;
        String[] imageExtensions = PrefsPropsUtil.getStringArray("ig.image.extensions", ",");
        int i = 0;
        while (i < imageExtensions.length) {
            if ("*".equals(imageExtensions[i]) || StringUtil.endsWith((String)nameWithExtension, (String)imageExtensions[i])) {
                validImageExtension = true;
                break;
            }
            ++i;
        }
        if (!validImageExtension) {
            throw new ImageNameException();
        }
        String name = FileUtil.stripExtension((String)nameWithExtension);
        String imageType = FileUtil.getExtension((String)nameWithExtension);
        List images = this.igImagePersistence.findByG_F_N(groupId, folderId, name);
        if (imageType.equals("jpeg")) {
            imageType = "jpg";
        } else if (imageType.equals("tif")) {
            imageType = "tiff";
        }
        for (IGImage image : images) {
            if (!imageType.equals(image.getImageType())) continue;
            throw new DuplicateImageNameException();
        }
    }

    protected void validate(long groupId, long folderId, String nameWithExtension, String fileName, byte[] bytes) throws PortalException, SystemException {
        if (Validator.isNotNull((String)fileName)) {
            String extension = FileUtil.getExtension((String)fileName);
            if (Validator.isNull((String)nameWithExtension)) {
                nameWithExtension = fileName;
            } else if (!StringUtil.endsWith((String)nameWithExtension, (String)extension)) {
                throw new ImageNameException();
            }
        }
        this.validate(groupId, folderId, nameWithExtension);
        this.validate(bytes);
    }
}

