/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderModelImpl;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderImpl
extends DLFolderModelImpl
implements DLFolder {
    public List<DLFolder> getAncestors() throws PortalException, SystemException {
        ArrayList<DLFolder> ancestors = new ArrayList<DLFolder>();
        DLFolderImpl folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            ancestors.add(folder);
        }
        return ancestors;
    }

    public DLFolder getParentFolder() throws PortalException, SystemException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return DLFolderLocalServiceUtil.getFolder((long)this.getParentFolderId());
    }

    public String getPath() throws PortalException, SystemException {
        StringBuilder sb = new StringBuilder();
        DLFolderImpl folder = this;
        while (true) {
            sb.insert(0, folder.getName());
            sb.insert(0, "/");
            if (folder.getParentFolderId() == 0L) break;
            folder = DLFolderLocalServiceUtil.getFolder((long)folder.getParentFolderId());
        }
        return sb.toString();
    }

    public String[] getPathArray() throws PortalException, SystemException {
        String path = this.getPath();
        path = path.substring(1, path.length());
        return StringUtil.split((String)path, (String)"/");
    }

    public boolean hasLock(long userId) {
        try {
            return LockLocalServiceUtil.hasLock((long)userId, (String)DLFileEntry.class.getName(), (long)this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLocked() {
        try {
            return LockLocalServiceUtil.isLocked((String)DLFolder.class.getName(), (long)this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

