/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class BookmarksPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "bookmarks";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("bookmarks", "categories");
    private static PortletDataHandlerBoolean _foldersAndEntries = new PortletDataHandlerBoolean("bookmarks", "folders-and-entries", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("bookmarks", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("bookmarks", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries, _categories, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries, _categories, _ratings, _tags};
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(BookmarksPortletDataHandlerImpl.class, "deleteData")) {
            BookmarksFolderLocalServiceUtil.deleteFolders((long)context.getScopeGroupId());
            BookmarksEntryLocalServiceUtil.deleteEntries((long)context.getScopeGroupId(), (long)0L);
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.bookmarks", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("bookmarks-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element foldersElement = rootElement.addElement("folders");
        Element entriesElement = rootElement.addElement("entries");
        List folders = BookmarksFolderUtil.findByGroupId((long)context.getScopeGroupId());
        for (BookmarksFolder folder : folders) {
            this.exportFolder(context, foldersElement, entriesElement, folder);
        }
        List entries = BookmarksEntryUtil.findByG_F((long)context.getScopeGroupId(), (long)0L);
        for (BookmarksEntry entry : entries) {
            this.exportEntry(context, null, entriesElement, entry);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.bookmarks", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element foldersElement = rootElement.element("folders");
        for (Element folderElement : foldersElement.elements("folder")) {
            String path = folderElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            BookmarksFolder folder = (BookmarksFolder)context.getZipEntryAsObject(path);
            this.importFolder(context, folder);
        }
        Element entriesElement = rootElement.element("entries");
        for (Element entryElement : entriesElement.elements("entry")) {
            String path = entryElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            BookmarksEntry entry = (BookmarksEntry)context.getZipEntryAsObject(path);
            this.importEntry(context, entry);
        }
        return null;
    }

    protected void exportFolder(PortletDataContext context, Element foldersElement, Element entriesElement, BookmarksFolder folder) throws Exception {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            this.exportParentFolder(context, foldersElement, folder.getParentFolderId());
            String path = this.getFolderPath(context, folder);
            if (context.isPathNotProcessed(path)) {
                Element folderElement = foldersElement.addElement("folder");
                folderElement.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addPermissions(BookmarksFolder.class, folder.getFolderId());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List entries = BookmarksEntryUtil.findByG_F((long)folder.getGroupId(), (long)folder.getFolderId());
        for (BookmarksEntry entry : entries) {
            this.exportEntry(context, foldersElement, entriesElement, entry);
        }
    }

    protected void exportEntry(PortletDataContext context, Element foldersElement, Element entriesElement, BookmarksEntry entry) throws Exception {
        String path;
        if (!context.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        if (foldersElement != null) {
            this.exportParentFolder(context, foldersElement, entry.getFolderId());
        }
        if (context.isPathNotProcessed(path = this.getEntryPath(context, entry))) {
            Element entryElement = entriesElement.addElement("entry");
            entryElement.addAttribute("path", path);
            context.addPermissions(BookmarksEntry.class, entry.getEntryId());
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                context.addAssetCategories(BookmarksEntry.class, entry.getEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(BookmarksEntry.class, entry.getEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addAssetTags(BookmarksEntry.class, entry.getEntryId());
            }
            entry.setUserUuid(entry.getUserUuid());
            context.addZipEntry(path, (Object)entry);
        }
    }

    protected void exportParentFolder(PortletDataContext context, Element foldersElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderUtil.findByPrimaryKey((long)folderId);
        this.exportParentFolder(context, foldersElement, folder.getParentFolderId());
        String path = this.getFolderPath(context, folder);
        if (context.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            folderElement.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addPermissions(BookmarksFolder.class, folder.getFolderId());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected String getEntryPath(PortletDataContext context, BookmarksEntry entry) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("28"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getFolderPath(PortletDataContext context, BookmarksFolder folder) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("28"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getSourcePortletPath("28"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEntry(PortletDataContext context, BookmarksEntry entry) throws Exception {
        long userId = context.getUserId(entry.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(BookmarksFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)entry.getFolderId(), (long)entry.getFolderId());
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(BookmarksEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(BookmarksEntry.class, entry.getEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(entry.getCreateDate());
        serviceContext.setModifiedDate(entry.getModifiedDate());
        if (folderId != 0L && folderId == entry.getFolderId()) {
            String path = this.getImportFolderPath(context, folderId);
            BookmarksFolder folder = (BookmarksFolder)context.getZipEntryAsObject(path);
            this.importFolder(context, folder);
            folderId = MapUtil.getLong((Map)folderPKs, (long)entry.getFolderId(), (long)entry.getFolderId());
        }
        BookmarksEntry importedEntry = null;
        if (context.isDataStrategyMirror()) {
            BookmarksEntry existingEntry = BookmarksEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)context.getScopeGroupId());
            if (existingEntry == null) {
                serviceContext.setUuid(entry.getUuid());
                importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
            } else {
                importedEntry = BookmarksEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (long)context.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
            }
        } else {
            importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
        }
        context.importPermissions(BookmarksEntry.class, entry.getEntryId(), importedEntry.getEntryId());
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(BookmarksEntry.class, entry.getEntryId(), importedEntry.getEntryId());
        }
    }

    protected void importFolder(PortletDataContext context, BookmarksFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(BookmarksFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(folder.getCreateDate());
        serviceContext.setModifiedDate(folder.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = this.getImportFolderPath(context, parentFolderId);
            BookmarksFolder parentFolder = (BookmarksFolder)context.getZipEntryAsObject(path);
            this.importFolder(context, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        BookmarksFolder importedFolder = null;
        if (context.isDataStrategyMirror()) {
            BookmarksFolder existingFolder = BookmarksFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getScopeGroupId());
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = BookmarksFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        folderPKs.put(folder.getFolderId(), importedFolder.getFolderId());
        context.importPermissions(BookmarksFolder.class, folder.getFolderId(), importedFolder.getFolderId());
    }
}

