/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordPressImporter {
    private static final String _DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String _EXPORT_FILE = "wordpress.xml";
    private static final Namespace _NS_CONTENT = SAXReaderUtil.createNamespace((String)"content", (String)"http://purl.org/rss/1.0/modules/content/");
    private static final Namespace _NS_DC = SAXReaderUtil.createNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private static final Namespace _NS_WP = SAXReaderUtil.createNamespace((String)"wp", (String)"http://wordpress.org/export/1.0/");
    private static final String _USER_MAP_FILE = "wordpress-user-map.xml";
    private static Log _log = LogFactoryUtil.getLog(WordPressImporter.class);

    public static void importData(PortletDataContext context) throws PortalException, SystemException {
        Map<String, Long> userMap = WordPressImporter.getWordPressUserMap(context);
        String path = WordPressImporter.getWordPressPath(context, _EXPORT_FILE);
        String fileData = context.getZipEntryAsString(path);
        if (Validator.isNull((String)fileData)) {
            return;
        }
        Document wordPressDoc = null;
        try {
            wordPressDoc = SAXReaderUtil.read((String)fileData);
        }
        catch (DocumentException de) {
            _log.error((Object)("Reading " + path), (Throwable)de);
            return;
        }
        User defaultUser = UserLocalServiceUtil.getDefaultUser((long)context.getCompanyId());
        Element root = wordPressDoc.getRootElement();
        List entryEls = root.element("channel").elements("item");
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_DATE_FORMAT);
        dateFormat.setTimeZone(TimeZoneUtil.getTimeZone((String)"UTC"));
        for (Element entryEl : entryEls) {
            WordPressImporter.importEntry(context, defaultUser, userMap, dateFormat, entryEl);
        }
    }

    protected static String getWordPressPath(PortletDataContext context, String fileName) {
        return context.getSourcePortletPath("33").concat("/").concat(fileName);
    }

    protected static Map<String, Long> getWordPressUserMap(PortletDataContext context) {
        HashMap<String, Long> userMap = new HashMap<String, Long>();
        String path = WordPressImporter.getWordPressPath(context, _USER_MAP_FILE);
        String fileData = context.getZipEntryAsString(path);
        if (Validator.isNull((String)fileData)) {
            return userMap;
        }
        Document doc = null;
        try {
            doc = SAXReaderUtil.read((String)fileData);
        }
        catch (DocumentException de) {
            _log.error((Object)de.getMessage(), (Throwable)de);
            return userMap;
        }
        Element root = doc.getRootElement();
        List userEls = root.elements("wordpress-user");
        for (Element userEl : userEls) {
            try {
                User user = UserUtil.findByC_EA((long)context.getCompanyId(), (String)userEl.attributeValue("email-address"));
                userMap.put(userEl.getTextTrim(), user.getUserId());
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("User for {" + context.getCompanyId() + ", " + userEl.attributeValue("email-address") + "}"), (Throwable)e);
            }
        }
        return userMap;
    }

    protected static void importComment(PortletDataContext context, User defaultUser, MBMessageDisplay messageDisplay, Map<Long, Long> messageIdMap, BlogsEntry entry, Element commentEl) throws PortalException, SystemException {
        MBThread thread = messageDisplay.getThread();
        long commentId = GetterUtil.getLong((String)commentEl.elementTextTrim(SAXReaderUtil.createQName((String)"comment_id", (Namespace)_NS_WP)));
        String commentContent = commentEl.elementTextTrim(SAXReaderUtil.createQName((String)"comment_content", (Namespace)_NS_WP));
        if (Validator.isNull((String)commentContent)) {
            return;
        }
        String commentAuthor = commentEl.elementTextTrim(SAXReaderUtil.createQName((String)"comment_author", (Namespace)_NS_WP));
        commentAuthor = commentAuthor.substring(0, Math.min(75, commentAuthor.length()));
        long commentParentId = GetterUtil.getLong((String)commentEl.elementTextTrim(SAXReaderUtil.createQName((String)"comment_parent", (Namespace)_NS_WP)));
        commentParentId = commentParentId == 0L ? messageDisplay.getMessage().getMessageId() : messageIdMap.get(commentParentId).longValue();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        MBMessage message = MBMessageLocalServiceUtil.addDiscussionMessage((long)defaultUser.getUserId(), (String)commentAuthor, (long)context.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (long)thread.getThreadId(), (long)commentParentId, null, (String)commentContent, (ServiceContext)serviceContext);
        messageIdMap.put(commentId, message.getMessageId());
    }

    protected static void importEntry(PortletDataContext context, User defaultUser, Map<String, Long> userMap, DateFormat dateFormat, Element entryEl) throws PortalException, SystemException {
        boolean allowPingbacks;
        String title;
        long userId = context.getUserId(null);
        String creator = entryEl.elementText(SAXReaderUtil.createQName((String)"creator", (Namespace)_NS_DC));
        if (userMap.containsKey(creator)) {
            userId = userMap.get(creator);
        }
        if (Validator.isNull((String)(title = entryEl.elementTextTrim("title")))) {
            title = entryEl.elementTextTrim(SAXReaderUtil.createQName((String)"post_name", (Namespace)_NS_WP));
        }
        String content = entryEl.elementText(SAXReaderUtil.createQName((String)"encoded", (Namespace)_NS_CONTENT));
        if (Validator.isNull((String)(content = content.replaceAll("\\n", "\n<br />")))) {
            content = "<br />";
        }
        String dateText = entryEl.elementTextTrim(SAXReaderUtil.createQName((String)"post_date_gmt", (Namespace)_NS_WP));
        Date postDate = new Date();
        try {
            postDate = dateFormat.parse(dateText);
        }
        catch (ParseException pe) {
            _log.warn((Object)("Parse " + dateText), (Throwable)pe);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(postDate);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        String pingStatusText = entryEl.elementTextTrim(SAXReaderUtil.createQName((String)"ping_status", (Namespace)_NS_WP));
        boolean allowTrackbacks = allowPingbacks = pingStatusText.equalsIgnoreCase("open");
        String statusText = entryEl.elementTextTrim(SAXReaderUtil.createQName((String)"status", (Namespace)_NS_WP));
        int workflowAction = 1;
        if (statusText.equalsIgnoreCase("draft")) {
            workflowAction = 2;
        }
        String[] assetTagNames = null;
        String categoryText = entryEl.elementTextTrim("category");
        if (Validator.isNotNull((String)categoryText)) {
            assetTagNames = new String[]{categoryText};
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setScopeGroupId(context.getGroupId());
        serviceContext.setWorkflowAction(workflowAction);
        BlogsEntry entry = null;
        try {
            entry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)title, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, null, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)("Add entry " + title), (Throwable)e);
            return;
        }
        MBMessageDisplay messageDisplay = MBMessageLocalServiceUtil.getDiscussionMessageDisplay((long)userId, (long)context.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (int)0);
        HashMap<Long, Long> messageIdMap = new HashMap<Long, Long>();
        List commentNodes = entryEl.selectNodes("wp:comment", "wp:comment_parent/text()");
        for (Node commentNode : commentNodes) {
            Element commentEl = (Element)commentNode;
            WordPressImporter.importComment(context, defaultUser, messageDisplay, messageIdMap, entry, commentEl);
        }
    }
}

