/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPublisherUtil {
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherUtil.class);

    public static void addAndStoreSelection(ActionRequest actionRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)referringPortletResource);
        String selectionStyle = preferences.getValue("selection-style", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        AssetPublisherUtil.addSelection(className, assetEntry.getEntryId(), assetEntryOrder, preferences);
        preferences.store();
    }

    public static void addRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        AssetPublisherUtil._getRecentFolderIds(portletRequest).put(className, classPK);
    }

    public static void addSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String assetEntryType = ParamUtil.getString((PortletRequest)actionRequest, (String)"assetEntryType");
        long assetEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        AssetPublisherUtil.addSelection(assetEntryType, assetEntryId, assetEntryOrder, preferences);
    }

    public static void addSelection(String assetEntryType, long assetEntryId, int assetEntryOrder, PortletPreferences preferences) throws Exception {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)assetEntryId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), 0);
        Object[] assetEntryXmls = preferences.getValues("asset-entry-xml", new String[0]);
        String assetEntryXml = AssetPublisherUtil._getAssetEntryXml(assetEntryType, assetRenderer.getUuid());
        if (assetEntryOrder > -1) {
            assetEntryXmls[assetEntryOrder] = assetEntryXml;
        } else {
            assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
        }
        preferences.setValues("asset-entry-xml", (String[])assetEntryXmls);
    }

    public static AssetEntryQuery getAssetEntryQuery(PortletPreferences preferences, long scopeGroupId) throws Exception {
        String[] queryValues;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        String[] allAssetTagNames = new String[]{};
        String[] anyAssetTagNames = new String[]{};
        String[] notAllAssetTagNames = new String[]{};
        String[] notAnyAssetTagNames = new String[]{};
        int i = 0;
        while ((queryValues = preferences.getValues("queryValues" + i, null)) != null && queryValues.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)preferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)preferences.getValue("queryAndOperator" + i, ""));
            String queryName = preferences.getValue("queryName" + i, "");
            if (Validator.equals((Object)queryName, (Object)"assetCategories")) {
                long[] assetCategoryIds = GetterUtil.getLongValues((String[])queryValues);
                if (queryContains && queryAndOperator) {
                    allAssetCategoryIds = assetCategoryIds;
                } else if (queryContains && !queryAndOperator) {
                    anyAssetCategoryIds = assetCategoryIds;
                } else if (!queryContains && queryAndOperator) {
                    notAllAssetCategoryIds = assetCategoryIds;
                } else {
                    notAnyAssetCategoryIds = assetCategoryIds;
                }
            } else if (queryContains && queryAndOperator) {
                allAssetTagNames = queryValues;
            } else if (queryContains && !queryAndOperator) {
                anyAssetTagNames = queryValues;
            } else if (!queryContains && queryAndOperator) {
                notAllAssetTagNames = queryValues;
            } else {
                notAnyAssetTagNames = queryValues;
            }
            ++i;
        }
        long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long)scopeGroupId, (String[])allAssetTagNames);
        long[] anyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long)scopeGroupId, (String[])anyAssetTagNames);
        long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long)scopeGroupId, (String[])notAllAssetTagNames);
        long[] notAnyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long)scopeGroupId, (String[])notAnyAssetTagNames);
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        assetEntryQuery.setAllTagIds(allAssetTagIds);
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        assetEntryQuery.setNotAllTagIds(notAllAssetTagIds);
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
        return assetEntryQuery;
    }

    public static String[] getAssetTagNames(PortletPreferences preferences, long scopeGroupId) throws Exception {
        String[] queryValues;
        String[] allAssetTagNames = new String[]{};
        int i = 0;
        while ((queryValues = preferences.getValues("queryValues" + i, null)) != null && queryValues.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)preferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)preferences.getValue("queryAndOperator" + i, ""));
            String queryName = preferences.getValue("queryName" + i, "");
            if (!Validator.equals((Object)queryName, (Object)"assetCategories") && queryContains && queryAndOperator) {
                allAssetTagNames = queryValues;
            }
            ++i;
        }
        return allAssetTagNames;
    }

    public static long[] getClassNameIds(PortletPreferences preferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)preferences.getValue("any-asset-type", Boolean.TRUE.toString()));
        long[] classNameIds = null;
        classNameIds = !anyAssetType && preferences.getValues("class-name-ids", null) != null ? GetterUtil.getLongValues((String[])preferences.getValues("class-name-ids", null)) : availableClassNameIds;
        return classNameIds;
    }

    public static long[] getGroupIds(PortletPreferences preferences, long scopeGroupId, Layout layout) {
        long[] groupIds = new long[]{scopeGroupId};
        boolean defaultScope = GetterUtil.getBoolean((String)preferences.getValue("default-scope", null), (boolean)true);
        if (!defaultScope) {
            String[] scopeIds = preferences.getValues("scope-ids", new String[]{"group_" + scopeGroupId});
            groupIds = new long[scopeIds.length];
            int i = 0;
            while (i < scopeIds.length) {
                try {
                    String[] scopeIdFragments = StringUtil.split((String)scopeIds[i], (String)"_");
                    if (scopeIdFragments[0].equals("Layout")) {
                        long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdFragments[1]);
                        Layout scopeIdLayout = LayoutLocalServiceUtil.getLayout((long)scopeGroupId, (boolean)layout.isPrivateLayout(), (long)scopeIdLayoutId);
                        Group scopeIdGroup = scopeIdLayout.getScopeGroup();
                        groupIds[i] = scopeIdGroup.getGroupId();
                    } else {
                        long scopeIdGroupId;
                        groupIds[i] = scopeIdFragments[1].equals("default") ? scopeGroupId : (scopeIdGroupId = GetterUtil.getLong((String)scopeIdFragments[1]));
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return groupIds;
    }

    public static long getRecentFolderId(PortletRequest portletRequest, String className) {
        Long classPK = AssetPublisherUtil._getRecentFolderIds(portletRequest).get(className);
        if (classPK == null) {
            return 0L;
        }
        return classPK;
    }

    public static void removeAndStoreSelection(List<String> assetEntryUuids, PortletPreferences preferences) throws Exception {
        if (assetEntryUuids.size() == 0) {
            return;
        }
        Object[] assetEntryXmls = preferences.getValues("asset-entry-xml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        preferences.setValues("asset-entry-xml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        preferences.store();
    }

    public static void removeRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        if (AssetPublisherUtil.getRecentFolderId(portletRequest, className) == classPK) {
            AssetPublisherUtil._getRecentFolderIds(portletRequest).remove(className);
        }
    }

    private static String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioe);
            }
        }
        return xml;
    }

    private static Map<String, Long> _getRecentFolderIds(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String key = AssetPublisherUtil.class + "_" + themeDisplay.getScopeGroupId();
        HashMap<String, Long> recentFolderIds = (HashMap<String, Long>)session.getAttribute(key);
        if (recentFolderIds == null) {
            recentFolderIds = new HashMap<String, Long>();
        }
        session.setAttribute(key, recentFolderIds);
        return recentFolderIds;
    }
}

