/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.annotation;

import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement annotatedElement) {
        Transactional annotation = null;
        LinkedList candidateQueue = new LinkedList();
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            candidateQueue.offer(method.getDeclaringClass());
            annotation = this._deepSearchMethods(method, candidateQueue);
        } else {
            candidateQueue.offer((Class)annotatedElement);
            annotation = this._deepSearchTypes(candidateQueue);
        }
        if (annotation == null) {
            return null;
        }
        RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
        int isolationLevel = annotation.isolation().value();
        if (isolationLevel == -2) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_PORTAL);
        } else {
            ruleBasedTransactionAttribute.setIsolationLevel(isolationLevel);
        }
        ruleBasedTransactionAttribute.setPropagationBehavior(annotation.propagation().value());
        ruleBasedTransactionAttribute.setReadOnly(annotation.readOnly());
        ruleBasedTransactionAttribute.setTimeout(annotation.timeout());
        ArrayList<Object> rollBackAttributes = new ArrayList<Object>();
        Class[] rollbackFor = annotation.rollbackFor();
        int i = 0;
        while (i < rollbackFor.length) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackFor[i]);
            rollBackAttributes.add(rollbackRuleAttribute);
            ++i;
        }
        String[] rollbackForClassName = annotation.rollbackForClassName();
        int i2 = 0;
        while (i2 < rollbackForClassName.length) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClassName[i2]);
            rollBackAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        Class[] noRollbackFor = annotation.noRollbackFor();
        int i3 = 0;
        while (i3 < noRollbackFor.length) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackFor[i3]);
            rollBackAttributes.add(noRollbackRuleAttribute);
            ++i3;
        }
        String[] noRollbackForClassName = annotation.noRollbackForClassName();
        int i4 = 0;
        while (i4 < noRollbackForClassName.length) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClassName[i4]);
            rollBackAttributes.add(noRollbackRuleAttribute);
            ++i4;
        }
        ruleBasedTransactionAttribute.getRollbackRules().addAll(rollBackAttributes);
        return ruleBasedTransactionAttribute;
    }

    private Transactional _deepSearchMethods(Method method, Queue<Class<?>> candidateQueue) {
        Transactional annotation = method.getAnnotation(Transactional.class);
        if (annotation != null) {
            return annotation;
        }
        if (candidateQueue.isEmpty()) {
            return null;
        }
        Class<?> clazz = candidateQueue.poll();
        if (method.getDeclaringClass() != clazz) {
            try {
                Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = specificMethod.getAnnotation(Transactional.class);
                if (annotation != null) {
                    return annotation;
                }
            }
            catch (Exception exception) {}
        }
        if ((annotation = clazz.getAnnotation(Transactional.class)) == null) {
            this._queueSuperTypes(clazz, candidateQueue);
            return this._deepSearchMethods(method, candidateQueue);
        }
        return annotation;
    }

    private Transactional _deepSearchTypes(Queue<Class<?>> candidateQueue) {
        if (candidateQueue.isEmpty()) {
            return null;
        }
        Class<?> clazz = candidateQueue.poll();
        Transactional annotation = clazz.getAnnotation(Transactional.class);
        if (annotation == null) {
            this._queueSuperTypes(clazz, candidateQueue);
            return this._deepSearchTypes(candidateQueue);
        }
        return annotation;
    }

    private void _queueSuperTypes(Class<?> clazz, Queue<Class<?>> candidateQueue) {
        Class<?>[] interfaces;
        Class<?> supperClass = clazz.getSuperclass();
        if (supperClass != null && supperClass != Object.class) {
            candidateQueue.offer(supperClass);
        }
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            candidateQueue.offer(inter);
            ++n2;
        }
    }
}

