/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.ui;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.List;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class InputPermissionsParamsTagUtil {
    public static String getDefaultViewRole(String modelName, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Layout layout = themeDisplay.getLayout();
        Group layoutGroup = layout.getGroup();
        List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(modelName);
        if (layoutGroup.isControlPanel()) {
            Group group = themeDisplay.getScopeGroup();
            if (!group.hasPrivateLayouts() && guestDefaultActions.contains("VIEW")) {
                return "Guest";
            }
        } else {
            if (layout.isPublicLayout() && guestDefaultActions.contains("VIEW")) {
                return "Guest";
            }
            Group parentGroup = GroupLocalServiceUtil.getGroup((long)themeDisplay.getParentGroupId());
            Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole((long)parentGroup.getGroupId());
            return defaultGroupRole.getName();
        }
        return "";
    }

    public static void doEndTag(String modelName, PageContext pageContext) throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            Group group = themeDisplay.getScopeGroup();
            List<String> supportedActions = ResourceActionsUtil.getModelResourceActions(modelName);
            List<String> communityDefaultActions = ResourceActionsUtil.getModelResourceCommunityDefaultActions(modelName);
            List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(modelName);
            List<String> guestUnsupportedActions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelName);
            StringBundler sb = new StringBundler();
            int i = 0;
            while (i < supportedActions.size()) {
                String action = supportedActions.get(i);
                boolean communityChecked = communityDefaultActions.contains(action);
                boolean guestChecked = guestDefaultActions.contains(action);
                boolean guestDisabled = guestUnsupportedActions.contains(action);
                if (guestDisabled) {
                    guestChecked = false;
                }
                if ((group.isCommunity() || group.isOrganization()) && communityChecked) {
                    sb.append("&");
                    sb.append(renderResponse.getNamespace());
                    sb.append("communityPermissions=");
                    sb.append(HttpUtil.encodeURL((String)action));
                }
                if (guestChecked) {
                    sb.append("&");
                    sb.append(renderResponse.getNamespace());
                    sb.append("guestPermissions=");
                    sb.append(HttpUtil.encodeURL((String)action));
                }
                ++i;
            }
            String inputPermissionsViewRole = InputPermissionsParamsTagUtil.getDefaultViewRole(modelName, themeDisplay);
            sb.append("&");
            sb.append(renderResponse.getNamespace());
            sb.append("inputPermissionsViewRole=");
            sb.append(HttpUtil.encodeURL((String)inputPermissionsViewRole));
            pageContext.getOut().print(sb.toString());
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

