/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.NoSuchTeamException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.TeamImpl;
import com.liferay.portal.model.impl.TeamModelImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.model.impl.UserModelImpl;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.AccountPersistence;
import com.liferay.portal.service.persistence.AddressPersistence;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.BrowserTrackerPersistence;
import com.liferay.portal.service.persistence.ClassNamePersistence;
import com.liferay.portal.service.persistence.ClusterGroupPersistence;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ContactPersistence;
import com.liferay.portal.service.persistence.CountryPersistence;
import com.liferay.portal.service.persistence.EmailAddressPersistence;
import com.liferay.portal.service.persistence.GroupPersistence;
import com.liferay.portal.service.persistence.ImagePersistence;
import com.liferay.portal.service.persistence.LayoutPersistence;
import com.liferay.portal.service.persistence.LayoutPrototypePersistence;
import com.liferay.portal.service.persistence.LayoutSetPersistence;
import com.liferay.portal.service.persistence.LayoutSetPrototypePersistence;
import com.liferay.portal.service.persistence.ListTypePersistence;
import com.liferay.portal.service.persistence.LockPersistence;
import com.liferay.portal.service.persistence.MembershipRequestPersistence;
import com.liferay.portal.service.persistence.OrgGroupPermissionPersistence;
import com.liferay.portal.service.persistence.OrgGroupRolePersistence;
import com.liferay.portal.service.persistence.OrgLaborPersistence;
import com.liferay.portal.service.persistence.OrganizationPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyRelPersistence;
import com.liferay.portal.service.persistence.PasswordTrackerPersistence;
import com.liferay.portal.service.persistence.PermissionPersistence;
import com.liferay.portal.service.persistence.PhonePersistence;
import com.liferay.portal.service.persistence.PluginSettingPersistence;
import com.liferay.portal.service.persistence.PortletItemPersistence;
import com.liferay.portal.service.persistence.PortletPersistence;
import com.liferay.portal.service.persistence.PortletPreferencesPersistence;
import com.liferay.portal.service.persistence.RegionPersistence;
import com.liferay.portal.service.persistence.ReleasePersistence;
import com.liferay.portal.service.persistence.ResourceActionPersistence;
import com.liferay.portal.service.persistence.ResourceCodePersistence;
import com.liferay.portal.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.RolePersistence;
import com.liferay.portal.service.persistence.ServiceComponentPersistence;
import com.liferay.portal.service.persistence.ShardPersistence;
import com.liferay.portal.service.persistence.SubscriptionPersistence;
import com.liferay.portal.service.persistence.TeamPersistence;
import com.liferay.portal.service.persistence.TicketPersistence;
import com.liferay.portal.service.persistence.UserGroupGroupRolePersistence;
import com.liferay.portal.service.persistence.UserGroupPersistence;
import com.liferay.portal.service.persistence.UserGroupRolePersistence;
import com.liferay.portal.service.persistence.UserIdMapperPersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.UserTrackerPathPersistence;
import com.liferay.portal.service.persistence.UserTrackerPersistence;
import com.liferay.portal.service.persistence.WebDAVPropsPersistence;
import com.liferay.portal.service.persistence.WebsitePersistence;
import com.liferay.portal.service.persistence.WorkflowDefinitionLinkPersistence;
import com.liferay.portal.service.persistence.WorkflowInstanceLinkPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamPersistenceImpl
extends BasePersistenceImpl<Team>
implements TeamPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TeamImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_GROUPID = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_G_N = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_N = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_GET_USERS = new FinderPath(UserModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED_USERS_TEAMS, "Users_Teams", "getUsers", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_GET_USERS_SIZE = new FinderPath(UserModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED_USERS_TEAMS, "Users_Teams", "getUsersSize", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_CONTAINS_USER = new FinderPath(UserModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED_USERS_TEAMS, "Users_Teams", "containsUser", new String[]{Long.class.getName(), Long.class.getName()});
    @BeanReference(type=AccountPersistence.class)
    protected AccountPersistence accountPersistence;
    @BeanReference(type=AddressPersistence.class)
    protected AddressPersistence addressPersistence;
    @BeanReference(type=BrowserTrackerPersistence.class)
    protected BrowserTrackerPersistence browserTrackerPersistence;
    @BeanReference(type=ClassNamePersistence.class)
    protected ClassNamePersistence classNamePersistence;
    @BeanReference(type=ClusterGroupPersistence.class)
    protected ClusterGroupPersistence clusterGroupPersistence;
    @BeanReference(type=CompanyPersistence.class)
    protected CompanyPersistence companyPersistence;
    @BeanReference(type=ContactPersistence.class)
    protected ContactPersistence contactPersistence;
    @BeanReference(type=CountryPersistence.class)
    protected CountryPersistence countryPersistence;
    @BeanReference(type=EmailAddressPersistence.class)
    protected EmailAddressPersistence emailAddressPersistence;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=ImagePersistence.class)
    protected ImagePersistence imagePersistence;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutPrototypePersistence.class)
    protected LayoutPrototypePersistence layoutPrototypePersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=LayoutSetPrototypePersistence.class)
    protected LayoutSetPrototypePersistence layoutSetPrototypePersistence;
    @BeanReference(type=ListTypePersistence.class)
    protected ListTypePersistence listTypePersistence;
    @BeanReference(type=LockPersistence.class)
    protected LockPersistence lockPersistence;
    @BeanReference(type=MembershipRequestPersistence.class)
    protected MembershipRequestPersistence membershipRequestPersistence;
    @BeanReference(type=OrganizationPersistence.class)
    protected OrganizationPersistence organizationPersistence;
    @BeanReference(type=OrgGroupPermissionPersistence.class)
    protected OrgGroupPermissionPersistence orgGroupPermissionPersistence;
    @BeanReference(type=OrgGroupRolePersistence.class)
    protected OrgGroupRolePersistence orgGroupRolePersistence;
    @BeanReference(type=OrgLaborPersistence.class)
    protected OrgLaborPersistence orgLaborPersistence;
    @BeanReference(type=PasswordPolicyPersistence.class)
    protected PasswordPolicyPersistence passwordPolicyPersistence;
    @BeanReference(type=PasswordPolicyRelPersistence.class)
    protected PasswordPolicyRelPersistence passwordPolicyRelPersistence;
    @BeanReference(type=PasswordTrackerPersistence.class)
    protected PasswordTrackerPersistence passwordTrackerPersistence;
    @BeanReference(type=PermissionPersistence.class)
    protected PermissionPersistence permissionPersistence;
    @BeanReference(type=PhonePersistence.class)
    protected PhonePersistence phonePersistence;
    @BeanReference(type=PluginSettingPersistence.class)
    protected PluginSettingPersistence pluginSettingPersistence;
    @BeanReference(type=PortletPersistence.class)
    protected PortletPersistence portletPersistence;
    @BeanReference(type=PortletItemPersistence.class)
    protected PortletItemPersistence portletItemPersistence;
    @BeanReference(type=PortletPreferencesPersistence.class)
    protected PortletPreferencesPersistence portletPreferencesPersistence;
    @BeanReference(type=RegionPersistence.class)
    protected RegionPersistence regionPersistence;
    @BeanReference(type=ReleasePersistence.class)
    protected ReleasePersistence releasePersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=ResourceActionPersistence.class)
    protected ResourceActionPersistence resourceActionPersistence;
    @BeanReference(type=ResourceCodePersistence.class)
    protected ResourceCodePersistence resourceCodePersistence;
    @BeanReference(type=ResourcePermissionPersistence.class)
    protected ResourcePermissionPersistence resourcePermissionPersistence;
    @BeanReference(type=RolePersistence.class)
    protected RolePersistence rolePersistence;
    @BeanReference(type=ServiceComponentPersistence.class)
    protected ServiceComponentPersistence serviceComponentPersistence;
    @BeanReference(type=ShardPersistence.class)
    protected ShardPersistence shardPersistence;
    @BeanReference(type=SubscriptionPersistence.class)
    protected SubscriptionPersistence subscriptionPersistence;
    @BeanReference(type=TicketPersistence.class)
    protected TicketPersistence ticketPersistence;
    @BeanReference(type=TeamPersistence.class)
    protected TeamPersistence teamPersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserGroupPersistence.class)
    protected UserGroupPersistence userGroupPersistence;
    @BeanReference(type=UserGroupGroupRolePersistence.class)
    protected UserGroupGroupRolePersistence userGroupGroupRolePersistence;
    @BeanReference(type=UserGroupRolePersistence.class)
    protected UserGroupRolePersistence userGroupRolePersistence;
    @BeanReference(type=UserIdMapperPersistence.class)
    protected UserIdMapperPersistence userIdMapperPersistence;
    @BeanReference(type=UserTrackerPersistence.class)
    protected UserTrackerPersistence userTrackerPersistence;
    @BeanReference(type=UserTrackerPathPersistence.class)
    protected UserTrackerPathPersistence userTrackerPathPersistence;
    @BeanReference(type=WebDAVPropsPersistence.class)
    protected WebDAVPropsPersistence webDAVPropsPersistence;
    @BeanReference(type=WebsitePersistence.class)
    protected WebsitePersistence websitePersistence;
    @BeanReference(type=WorkflowDefinitionLinkPersistence.class)
    protected WorkflowDefinitionLinkPersistence workflowDefinitionLinkPersistence;
    @BeanReference(type=WorkflowInstanceLinkPersistence.class)
    protected WorkflowInstanceLinkPersistence workflowInstanceLinkPersistence;
    protected ContainsUser containsUser;
    protected AddUser addUser;
    protected ClearUsers clearUsers;
    protected RemoveUser removeUser;
    private static final String _SQL_SELECT_TEAM = "SELECT team FROM Team team";
    private static final String _SQL_SELECT_TEAM_WHERE = "SELECT team FROM Team team WHERE ";
    private static final String _SQL_COUNT_TEAM = "SELECT COUNT(team) FROM Team team";
    private static final String _SQL_COUNT_TEAM_WHERE = "SELECT COUNT(team) FROM Team team WHERE ";
    private static final String _SQL_GETUSERS = "SELECT {User_.*} FROM User_ INNER JOIN Users_Teams ON (Users_Teams.userId = User_.userId) WHERE (Users_Teams.teamId = ?)";
    private static final String _SQL_GETUSERSSIZE = "SELECT COUNT(*) AS COUNT_VALUE FROM Users_Teams WHERE teamId = ?";
    private static final String _SQL_CONTAINSUSER = "SELECT COUNT(*) AS COUNT_VALUE FROM Users_Teams WHERE teamId = ? AND userId = ?";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "team.groupId = ?";
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "team.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_1 = "team.name IS NULL";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "team.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(team.name IS NULL OR team.name = ?)";
    private static final String _FILTER_SQL_SELECT_TEAM_WHERE = "SELECT DISTINCT {team.*} FROM Team team WHERE ";
    private static final String _FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {Team.*} FROM (SELECT DISTINCT team.teamId FROM Team team WHERE ";
    private static final String _FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN Team ON TEMP_TABLE.teamId = Team.teamId";
    private static final String _FILTER_SQL_COUNT_TEAM_WHERE = "SELECT COUNT(DISTINCT team.teamId) AS COUNT_VALUE FROM Team team WHERE ";
    private static final String _FILTER_COLUMN_PK = "team.teamId";
    private static final String _FILTER_COLUMN_USERID = "team.userId";
    private static final String _FILTER_ENTITY_ALIAS = "team";
    private static final String _FILTER_ENTITY_TABLE = "Team";
    private static final String _ORDER_BY_ENTITY_ALIAS = "team.";
    private static final String _ORDER_BY_ENTITY_TABLE = "Team.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Team exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Team exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(TeamPersistenceImpl.class);

    public void cacheResult(Team team) {
        EntityCacheUtil.putResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(team.getPrimaryKey()), (Object)team);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(team.getGroupId()), team.getName()}, (Object)team);
    }

    public void cacheResult(List<Team> teams) {
        for (Team team : teams) {
            if (EntityCacheUtil.getResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(team.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(team);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)TeamImpl.class.getName());
        EntityCacheUtil.clearCache((String)TeamImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(Team team) {
        EntityCacheUtil.removeResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(team.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(team.getGroupId()), team.getName()});
    }

    public Team create(long teamId) {
        TeamImpl team = new TeamImpl();
        team.setNew(true);
        team.setPrimaryKey(teamId);
        return team;
    }

    public Team remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public Team remove(long teamId) throws NoSuchTeamException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Team team = (Team)session.get(TeamImpl.class, (Serializable)new Long(teamId));
            if (team == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + teamId));
                }
                throw new NoSuchTeamException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + teamId);
            }
            Team team2 = (Team)this.remove((BaseModel)team);
            return team2;
        }
        catch (NoSuchTeamException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team removeImpl(Team team) throws SystemException {
        team = this.toUnwrappedModel(team);
        try {
            try {
                this.clearUsers.clear(team.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)team);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        TeamModelImpl teamModelImpl = (TeamModelImpl)team;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(teamModelImpl.getGroupId()), teamModelImpl.getName()});
        EntityCacheUtil.removeResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(team.getPrimaryKey()));
        return team;
    }

    public Team updateImpl(Team team, boolean merge) throws SystemException {
        team = this.toUnwrappedModel(team);
        boolean isNew = team.isNew();
        TeamModelImpl teamModelImpl = (TeamModelImpl)team;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)team, (boolean)merge);
                team.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(team.getPrimaryKey()), (Object)team);
        if (!(isNew || team.getGroupId() == teamModelImpl.getOriginalGroupId() && Validator.equals((Object)team.getName(), (Object)teamModelImpl.getOriginalName()))) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(teamModelImpl.getOriginalGroupId()), teamModelImpl.getOriginalName()});
        }
        if (isNew || team.getGroupId() != teamModelImpl.getOriginalGroupId() || !Validator.equals((Object)team.getName(), (Object)teamModelImpl.getOriginalName())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(team.getGroupId()), team.getName()}, (Object)team);
        }
        return team;
    }

    protected Team toUnwrappedModel(Team team) {
        if (team instanceof TeamImpl) {
            return team;
        }
        TeamImpl teamImpl = new TeamImpl();
        teamImpl.setNew(team.isNew());
        teamImpl.setPrimaryKey(team.getPrimaryKey());
        teamImpl.setTeamId(team.getTeamId());
        teamImpl.setCompanyId(team.getCompanyId());
        teamImpl.setUserId(team.getUserId());
        teamImpl.setUserName(team.getUserName());
        teamImpl.setCreateDate(team.getCreateDate());
        teamImpl.setModifiedDate(team.getModifiedDate());
        teamImpl.setGroupId(team.getGroupId());
        teamImpl.setName(team.getName());
        teamImpl.setDescription(team.getDescription());
        return teamImpl;
    }

    public Team findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public Team findByPrimaryKey(long teamId) throws NoSuchTeamException, SystemException {
        Team team = this.fetchByPrimaryKey(teamId);
        if (team == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + teamId));
            }
            throw new NoSuchTeamException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + teamId);
        }
        return team;
    }

    public Team fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public Team fetchByPrimaryKey(long teamId) throws SystemException {
        Team team = (Team)EntityCacheUtil.getResult((boolean)TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, (Serializable)Long.valueOf(teamId), (SessionFactory)this);
        if (team == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    team = (Team)session.get(TeamImpl.class, (Serializable)new Long(teamId));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (team != null) {
                    this.cacheResult(team);
                }
                this.closeSession(session);
            }
        }
        return team;
    }

    public List<Team> findByGroupId(long groupId) throws SystemException {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<Team> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<Team> findByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY team.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public Team findByGroupId_First(long groupId, OrderByComparator orderByComparator) throws NoSuchTeamException, SystemException {
        List<Team> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchTeamException(msg.toString());
        }
        return list.get(0);
    }

    public Team findByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws NoSuchTeamException, SystemException {
        int count = this.countByGroupId(groupId);
        List<Team> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchTeamException(msg.toString());
        }
        return list.get(0);
    }

    public Team[] findByGroupId_PrevAndNext(long teamId, long groupId, OrderByComparator orderByComparator) throws NoSuchTeamException, SystemException {
        Team team = this.findByPrimaryKey(teamId);
        Session session = null;
        try {
            session = this.openSession();
            Team[] array = new TeamImpl[]{this.getByGroupId_PrevAndNext(session, team, groupId, orderByComparator, true), team, this.getByGroupId_PrevAndNext(session, team, groupId, orderByComparator, false)};
            Team[] teamArray = array;
            return teamArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team getByGroupId_PrevAndNext(Session session, Team team, long groupId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_TEAM_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY team.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)team);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Team)list.get(1);
        }
        return null;
    }

    public List<Team> filterFindByGroupId(long groupId) throws SystemException {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<Team> filterFindByGroupId(long groupId, int start, int end) throws SystemException {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<Team> filterFindByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY team.name ASC");
        } else {
            query.append(" ORDER BY Team.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)Team.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, TeamImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, TeamImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Team findByG_N(long groupId, String name) throws NoSuchTeamException, SystemException {
        Team team = this.fetchByG_N(groupId, name);
        if (team == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchTeamException(msg.toString());
        }
        return team;
    }

    public Team fetchByG_N(long groupId, String name) throws SystemException {
        return this.fetchByG_N(groupId, name, true);
    }

    public Team fetchByG_N(long groupId, String name, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_G_N_GROUPID_2);
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            query.append(" ORDER BY team.name ASC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (name != null) {
                    qPos.add(name);
                }
                List list = q.list();
                result = list;
                Team team = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (Object)list);
                } else {
                    team = (Team)list.get(0);
                    this.cacheResult(team);
                    if (team.getGroupId() != groupId || team.getName() == null || !team.getName().equals(name)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (Object)team);
                    }
                }
                Team team2 = team;
                return team2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Team)result;
    }

    public List<Team> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<Team> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<Team> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_TEAM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_TEAM.concat(" ORDER BY team.name ASC");
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (Team team : this.findByGroupId(groupId)) {
            this.remove((BaseModel)team);
        }
    }

    public void removeByG_N(long groupId, String name) throws NoSuchTeamException, SystemException {
        Team team = this.findByG_N(groupId, name);
        this.remove((BaseModel)team);
    }

    public void removeAll() throws SystemException {
        for (Team team : this.findAll()) {
            this.remove((BaseModel)team);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_TEAM_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)Team.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_N(long groupId, String name) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, name};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_N, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_G_N_GROUPID_2);
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_N, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_TEAM);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<User> getUsers(long pk) throws SystemException {
        return this.getUsers(pk, -1, -1);
    }

    public List<User> getUsers(long pk, int start, int end) throws SystemException {
        return this.getUsers(pk, start, end, null);
    }

    public List<User> getUsers(long pk, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{pk, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_USERS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    String sql = null;
                    sql = orderByComparator != null ? _SQL_GETUSERS.concat(" ORDER BY ").concat(orderByComparator.getOrderBy()) : _SQL_GETUSERS;
                    SQLQuery q = session.createSQLQuery(sql);
                    q.addEntity("User_", UserImpl.class);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_GET_USERS, (Object[])finderArgs);
                } else {
                    this.userPersistence.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_USERS, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public int getUsersSize(long pk) throws SystemException {
        Object[] finderArgs = new Object[]{pk};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_USERS_SIZE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    SQLQuery q = session.createSQLQuery(_SQL_GETUSERSSIZE);
                    q.addScalar("COUNT_VALUE", Type.LONG);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_USERS_SIZE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public boolean containsUser(long pk, long userPK) throws SystemException {
        Object[] finderArgs = new Object[]{pk, userPK};
        Boolean value = (Boolean)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_CONTAINS_USER, (Object[])finderArgs, (SessionFactory)this);
        if (value == null) {
            try {
                try {
                    value = this.containsUser.contains(pk, userPK);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_CONTAINS_USER, (Object[])finderArgs, (Object)value);
            }
        }
        return value;
    }

    public boolean containsUsers(long pk) throws SystemException {
        return this.getUsersSize(pk) > 0;
    }

    public void addUser(long pk, long userPK) throws SystemException {
        try {
            try {
                this.addUser.add(pk, userPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void addUser(long pk, User user) throws SystemException {
        try {
            try {
                this.addUser.add(pk, user.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void addUsers(long pk, long[] userPKs) throws SystemException {
        try {
            try {
                long[] lArray = userPKs;
                int n = userPKs.length;
                int n2 = 0;
                while (n2 < n) {
                    long userPK = lArray[n2];
                    this.addUser.add(pk, userPK);
                    ++n2;
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void addUsers(long pk, List<User> users) throws SystemException {
        try {
            try {
                for (User user : users) {
                    this.addUser.add(pk, user.getPrimaryKey());
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void clearUsers(long pk) throws SystemException {
        try {
            try {
                this.clearUsers.clear(pk);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void removeUser(long pk, long userPK) throws SystemException {
        try {
            try {
                this.removeUser.remove(pk, userPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void removeUser(long pk, User user) throws SystemException {
        try {
            try {
                this.removeUser.remove(pk, user.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void removeUsers(long pk, long[] userPKs) throws SystemException {
        try {
            try {
                long[] lArray = userPKs;
                int n = userPKs.length;
                int n2 = 0;
                while (n2 < n) {
                    long userPK = lArray[n2];
                    this.removeUser.remove(pk, userPK);
                    ++n2;
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void removeUsers(long pk, List<User> users) throws SystemException {
        try {
            try {
                for (User user : users) {
                    this.removeUser.remove(pk, user.getPrimaryKey());
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void setUsers(long pk, long[] userPKs) throws SystemException {
        try {
            try {
                Set userPKSet = SetUtil.fromArray((long[])userPKs);
                List<User> users = this.getUsers(pk);
                for (User user : users) {
                    if (userPKSet.remove(user.getPrimaryKey())) continue;
                    this.removeUser.remove(pk, user.getPrimaryKey());
                }
                for (Long userPK : userPKSet) {
                    this.addUser.add(pk, userPK);
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void setUsers(long pk, List<User> users) throws SystemException {
        try {
            try {
                long[] userPKs = new long[users.size()];
                int i = 0;
                while (i < users.size()) {
                    User user = users.get(i);
                    userPKs[i] = user.getPrimaryKey();
                    ++i;
                }
                this.setUsers(pk, userPKs);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"Users_Teams");
        }
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.Team")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        this.containsUser = new ContainsUser(this);
        this.addUser = new AddUser(this);
        this.clearUsers = new ClearUsers(this);
        this.removeUser = new RemoveUser(this);
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)TeamImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }

    protected class AddUser {
        private SqlUpdate _sqlUpdate;
        private TeamPersistenceImpl _persistenceImpl;

        protected AddUser(TeamPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)TeamPersistenceImpl.this.getDataSource(), (String)"INSERT INTO Users_Teams (teamId, userId) VALUES (?, ?)", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void add(long teamId, long userId) throws SystemException {
            if (!this._persistenceImpl.containsUser.contains(teamId, userId)) {
                ModelListener listener;
                ModelListener[] userListeners = TeamPersistenceImpl.this.userPersistence.getListeners();
                ModelListener[] modelListenerArray = TeamPersistenceImpl.this.listeners;
                int n = modelListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeAddAssociation((Object)teamId, User.class.getName(), (Object)userId);
                    ++n2;
                }
                modelListenerArray = userListeners;
                n = userListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeAddAssociation((Object)userId, Team.class.getName(), (Object)teamId);
                    ++n2;
                }
                this._sqlUpdate.update(new Object[]{new Long(teamId), new Long(userId)});
                modelListenerArray = TeamPersistenceImpl.this.listeners;
                n = modelListenerArray.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterAddAssociation((Object)teamId, User.class.getName(), (Object)userId);
                    ++n2;
                }
                modelListenerArray = userListeners;
                n = userListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterAddAssociation((Object)userId, Team.class.getName(), (Object)teamId);
                    ++n2;
                }
            }
        }
    }

    protected class ClearUsers {
        private SqlUpdate _sqlUpdate;

        protected ClearUsers(TeamPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)TeamPersistenceImpl.this.getDataSource(), (String)"DELETE FROM Users_Teams WHERE teamId = ?", (int[])new int[]{-5});
        }

        protected void clear(long teamId) throws SystemException {
            ModelListener listener;
            int n;
            int n2;
            ModelListener[] modelListenerArray;
            ModelListener[] userListeners = TeamPersistenceImpl.this.userPersistence.getListeners();
            List<User> users = null;
            if (TeamPersistenceImpl.this.listeners.length > 0 || userListeners.length > 0) {
                users = TeamPersistenceImpl.this.getUsers(teamId);
                for (User user : users) {
                    modelListenerArray = TeamPersistenceImpl.this.listeners;
                    n2 = modelListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onBeforeRemoveAssociation((Object)teamId, User.class.getName(), (Object)user.getPrimaryKey());
                        ++n;
                    }
                    modelListenerArray = userListeners;
                    n2 = userListeners.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onBeforeRemoveAssociation((Object)user.getPrimaryKey(), Team.class.getName(), (Object)teamId);
                        ++n;
                    }
                }
            }
            this._sqlUpdate.update(new Object[]{new Long(teamId)});
            if (TeamPersistenceImpl.this.listeners.length > 0 || userListeners.length > 0) {
                for (User user : users) {
                    modelListenerArray = TeamPersistenceImpl.this.listeners;
                    n2 = modelListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onAfterRemoveAssociation((Object)teamId, User.class.getName(), (Object)user.getPrimaryKey());
                        ++n;
                    }
                    modelListenerArray = userListeners;
                    n2 = userListeners.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onAfterRemoveAssociation((Object)user.getPrimaryKey(), Team.class.getName(), (Object)teamId);
                        ++n;
                    }
                }
            }
        }
    }

    protected class ContainsUser {
        private MappingSqlQuery<Integer> _mappingSqlQuery;

        protected ContainsUser(TeamPersistenceImpl persistenceImpl) {
            this._mappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery((DataSource)TeamPersistenceImpl.this.getDataSource(), (String)TeamPersistenceImpl._SQL_CONTAINSUSER, (int[])new int[]{-5, -5}, (RowMapper)RowMapper.COUNT);
        }

        protected boolean contains(long teamId, long userId) {
            Integer count;
            List results = this._mappingSqlQuery.execute(new Object[]{new Long(teamId), new Long(userId)});
            return results.size() > 0 && (count = (Integer)results.get(0)) > 0;
        }
    }

    protected class RemoveUser {
        private SqlUpdate _sqlUpdate;
        private TeamPersistenceImpl _persistenceImpl;

        protected RemoveUser(TeamPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)TeamPersistenceImpl.this.getDataSource(), (String)"DELETE FROM Users_Teams WHERE teamId = ? AND userId = ?", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void remove(long teamId, long userId) throws SystemException {
            if (this._persistenceImpl.containsUser.contains(teamId, userId)) {
                ModelListener listener;
                ModelListener[] userListeners = TeamPersistenceImpl.this.userPersistence.getListeners();
                ModelListener[] modelListenerArray = TeamPersistenceImpl.this.listeners;
                int n = modelListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeRemoveAssociation((Object)teamId, User.class.getName(), (Object)userId);
                    ++n2;
                }
                modelListenerArray = userListeners;
                n = userListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeRemoveAssociation((Object)userId, Team.class.getName(), (Object)teamId);
                    ++n2;
                }
                this._sqlUpdate.update(new Object[]{new Long(teamId), new Long(userId)});
                modelListenerArray = TeamPersistenceImpl.this.listeners;
                n = modelListenerArray.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterRemoveAssociation((Object)teamId, User.class.getName(), (Object)userId);
                    ++n2;
                }
                modelListenerArray = userListeners;
                n = userListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterRemoveAssociation((Object)userId, Team.class.getName(), (Object)teamId);
                    ++n2;
                }
            }
        }
    }
}

