/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.GroupNameException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.RequiredGroupException;
import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.GroupLocalServiceBaseImpl;
import com.liferay.portal.util.FriendlyURLNormalizer;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.GroupNameComparator;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.util.UniqueList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupLocalServiceImpl
extends GroupLocalServiceBaseImpl {
    protected File publicLARFile;
    private static Log _log = LogFactoryUtil.getLog(GroupLocalServiceImpl.class);
    private Map<String, Group> _systemGroupsMap = new HashMap<String, Group>();

    public GroupLocalServiceImpl() {
        this.initImportLARFile();
    }

    public Group addGroup(long userId, String className, long classPK, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(userId, className, classPK, 0L, name, description, type, friendlyURL, active, serviceContext);
    }

    public Group addGroup(long userId, String className, long classPK, long liveGroupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        User userScreenName;
        User user = this.userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString((String)className);
        long classNameId = PortalUtil.getClassNameId((String)className);
        String friendlyName = name;
        if (className.equals(Organization.class.getName())) {
            Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
            friendlyName = organization.getName();
            name = String.valueOf(classPK);
        }
        long groupId = 0L;
        do {
            groupId = this.counterLocalService.increment();
        } while ((userScreenName = this.userPersistence.fetchByC_SN(user.getCompanyId(), String.valueOf(groupId))) != null);
        boolean staging = this.isStaging(serviceContext);
        long groupClassNameId = PortalUtil.getClassNameId(Group.class);
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            classNameId = groupClassNameId;
            classPK = groupId;
        } else if (className.equals(Organization.class.getName()) && staging) {
            classPK = liveGroupId;
        } else {
            name = String.valueOf(classPK);
        }
        long parentGroupId = 0L;
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutLocalService.getLayout(classPK);
            parentGroupId = layout.getGroupId();
        }
        friendlyURL = this.getFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyName, friendlyURL);
        if (staging) {
            name = name.concat(" (Staging)");
            friendlyURL = friendlyURL.concat("-staging");
        }
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateName(groupId, user.getCompanyId(), name);
        }
        this.validateFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyURL);
        Group group = this.groupPersistence.create(groupId);
        group.setCompanyId(user.getCompanyId());
        group.setCreatorUserId(userId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setParentGroupId(parentGroupId);
        group.setLiveGroupId(liveGroupId);
        group.setName(name);
        group.setDescription(description);
        group.setType(type);
        group.setFriendlyURL(friendlyURL);
        group.setActive(active);
        this.groupPersistence.update((BaseModel)group, false);
        this.layoutSetLocalService.addLayoutSet(groupId, true);
        this.layoutSetLocalService.addLayoutSet(groupId, false);
        if (classNameId == groupClassNameId && !user.isDefaultUser()) {
            this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
            Role role = this.roleLocalService.getRole(group.getCompanyId(), "Community Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
            this.userLocalService.addGroupUsers(group.getGroupId(), new long[]{userId});
            if (serviceContext != null) {
                this.updateAsset(userId, group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
            }
        } else if (className.equals(Organization.class.getName()) && !user.isDefaultUser()) {
            this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
        }
        return group;
    }

    public void addRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.addGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void addUserGroups(long userId, long[] groupIds) throws SystemException {
        this.userPersistence.addGroups(userId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkCompanyGroup(long companyId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Company.class);
        int count = this.groupPersistence.countByC_C_C(companyId, classNameId, companyId);
        if (count == 0) {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.groupLocalService.addGroup(defaultUserId, Company.class.getName(), companyId, null, null, 0, null, true, null);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemGroups(long companyId) throws PortalException, SystemException {
        String[] systemGroups;
        for (Group group : this.groupFinder.findBySystem(companyId)) {
            this._systemGroupsMap.put(String.valueOf(companyId) + group.getName(), group);
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        String[] stringArray = systemGroups = PortalUtil.getSystemGroups();
        int n = systemGroups.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutSet layoutSet;
            String name = stringArray[n2];
            Group group = this._systemGroupsMap.get(String.valueOf(companyId) + name);
            try {
                if (group == null) {
                    group = this.groupPersistence.findByC_N(companyId, name);
                }
            }
            catch (NoSuchGroupException noSuchGroupException) {
                int type = 1;
                String friendlyURL = null;
                if (name.equals("Control Panel")) {
                    type = 3;
                    friendlyURL = "/control_panel";
                } else if (name.equals("Guest")) {
                    friendlyURL = "/guest";
                }
                group = this.groupLocalService.addGroup(defaultUserId, null, 0L, name, null, type, friendlyURL, true, null);
            }
            if (group.isControlPanel() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).getPageCount() == 0) {
                this.addControlPanelLayouts(group);
            }
            if (group.getName().equals("Guest") && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false)).getPageCount() == 0) {
                this.addDefaultGuestPublicLayouts(group);
            }
            this._systemGroupsMap.put(String.valueOf(companyId) + name, group);
            ++n2;
        }
    }

    @Override
    public void deleteGroup(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (PortalUtil.isSystemGroup((String)group.getName())) {
            throw new RequiredGroupException(String.valueOf(groupId));
        }
        try {
            this.layoutSetLocalService.deleteLayoutSet(groupId, true);
        }
        catch (NoSuchLayoutSetException noSuchLayoutSetException) {}
        try {
            this.layoutSetLocalService.deleteLayoutSet(groupId, false);
        }
        catch (NoSuchLayoutSetException noSuchLayoutSetException) {}
        this.userGroupRoleLocalService.deleteUserGroupRolesByGroupId(groupId);
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByGroupId(groupId);
        this.membershipRequestLocalService.deleteMembershipRequests(group.getGroupId());
        this.subscriptionLocalService.deleteSubscriptions(group.getCompanyId(), BlogsEntry.class.getName(), group.getGroupId());
        this.subscriptionLocalService.deleteSubscriptions(group.getCompanyId(), JournalArticle.class.getName(), group.getGroupId());
        this.teamLocalService.deleteTeams(group.getGroupId());
        this.unscheduleStaging(group);
        if (group.hasStagingGroup()) {
            this.deleteGroup(group.getStagingGroup().getGroupId());
        }
        if (group.isCommunity()) {
            this.assetEntryLocalService.deleteEntry(Group.class.getName(), groupId);
        }
        this.blogsEntryLocalService.deleteEntries(groupId);
        this.blogsStatsUserLocalService.deleteStatsUserByGroupId(groupId);
        this.bookmarksFolderLocalService.deleteFolders(groupId);
        this.calEventLocalService.deleteEvents(groupId);
        this.dlFolderLocalService.deleteFolders(groupId);
        this.igFolderLocalService.deleteFolders(groupId);
        this.journalArticleLocalService.deleteArticles(groupId);
        this.journalTemplateLocalService.deleteTemplates(groupId);
        this.journalStructureLocalService.deleteStructures(groupId);
        this.mbBanLocalService.deleteBansByGroupId(groupId);
        this.mbCategoryLocalService.deleteCategories(groupId);
        this.mbStatsUserLocalService.deleteStatsUsersByGroupId(groupId);
        this.pollsQuestionLocalService.deleteQuestions(groupId);
        this.shoppingCartLocalService.deleteGroupCarts(groupId);
        this.shoppingCategoryLocalService.deleteCategories(groupId);
        this.shoppingCouponLocalService.deleteCoupons(groupId);
        this.shoppingOrderLocalService.deleteOrders(groupId);
        this.scFrameworkVersionLocalService.deleteFrameworkVersions(groupId);
        this.scProductEntryLocalService.deleteProductEntries(groupId);
        this.wikiNodeLocalService.deleteNodes(groupId);
        for (Resource resource : this.resourceFinder.findByC_P(group.getCompanyId(), String.valueOf(groupId))) {
            this.resourceLocalService.deleteResource(resource);
        }
        if (!group.isStagingGroup() && (group.isCommunity() || group.isOrganization())) {
            this.resourceLocalService.deleteResource(group.getCompanyId(), Group.class.getName(), 4, group.getGroupId());
        }
        this.groupPersistence.remove((BaseModel)group);
        PermissionCacheUtil.clearCache();
    }

    public Group getCompanyGroup(long companyId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Company.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, companyId);
    }

    public List<Group> getCompanyGroups(long companyId, int start, int end) throws SystemException {
        return this.groupPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyGroupsCount(long companyId) throws SystemException {
        return this.groupPersistence.countByCompanyId(companyId);
    }

    public Group getFriendlyURLGroup(long companyId, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            throw new NoSuchGroupException();
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.findByC_F(companyId, friendlyURL);
    }

    @Override
    public Group getGroup(long groupId) throws PortalException, SystemException {
        return this.groupPersistence.findByPrimaryKey(groupId);
    }

    public Group getGroup(long companyId, String name) throws PortalException, SystemException {
        Group group = this._systemGroupsMap.get(String.valueOf(companyId) + name);
        if (group != null) {
            return group;
        }
        return this.groupPersistence.findByC_N(companyId, name);
    }

    public List<Group> getGroups(long[] groupIds) throws PortalException, SystemException {
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            Group group = this.getGroup(groupId);
            groups.add(group);
            ++n2;
        }
        return groups;
    }

    public Group getLayoutGroup(long companyId, long plid) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Layout.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, plid);
    }

    public Group getLayoutPrototypeGroup(long companyId, long layoutPrototypeId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(LayoutPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutPrototypeId);
    }

    public Group getLayoutSetPrototypeGroup(long companyId, long layoutSetPrototypeId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(LayoutSetPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutSetPrototypeId);
    }

    public List<Group> getLiveGroups() throws SystemException {
        return this.groupFinder.findByLiveGroups();
    }

    public List<Group> getNoLayoutsGroups(String className, boolean privateLayout, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.groupFinder.findByNoLayouts(classNameId, privateLayout, start, end);
    }

    public List<Group> getNullFriendlyURLGroups() throws SystemException {
        return this.groupFinder.findByNullFriendlyURL();
    }

    public Group getOrganizationGroup(long companyId, long organizationId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Organization.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, organizationId);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        int i = 0;
        while (i < organizations.size()) {
            Organization organization = organizations.get(i);
            Group group = organization.getGroup();
            organizationGroups.add(group);
            ++i;
        }
        return organizationGroups;
    }

    public List<Group> getOrganizationsRelatedGroups(List<Organization> organizations) throws SystemException {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        int i = 0;
        while (i < organizations.size()) {
            Organization organization = organizations.get(i);
            List groups = this.organizationPersistence.getGroups(organization.getOrganizationId());
            organizationGroups.addAll(groups);
            ++i;
        }
        return organizationGroups;
    }

    public List<Group> getRoleGroups(long roleId) throws SystemException {
        return this.rolePersistence.getGroups(roleId);
    }

    public Group getStagingGroup(long liveGroupId) throws PortalException, SystemException {
        return this.groupPersistence.findByLiveGroupId(liveGroupId);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(User.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userId);
    }

    public Group getUserGroupGroup(long companyId, long userGroupId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(UserGroup.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userGroupId);
    }

    public List<Group> getUserGroups(long userId) throws PortalException, SystemException {
        return this.getUserGroups(userId, false);
    }

    public List<Group> getUserGroups(long userId, boolean inherit) throws PortalException, SystemException {
        return this.getUserGroups(userId, inherit, -1, -1);
    }

    public List<Group> getUserGroups(long userId, int start, int end) throws PortalException, SystemException {
        return this.getUserGroups(userId, false, start, end);
    }

    public List<Group> getUserGroups(long userId, boolean inherit, int start, int end) throws PortalException, SystemException {
        if (inherit) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
            groupParams.put("usersGroups", new Long(userId));
            return this.search(user.getCompanyId(), null, null, groupParams, start, end);
        }
        return this.userPersistence.getGroups(userId);
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException, SystemException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        int i = 0;
        while (i < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i);
            Group group = userGroup.getGroup();
            userGroupGroups.add(group);
            ++i;
        }
        return userGroupGroups;
    }

    public List<Group> getUserGroupsRelatedGroups(List<UserGroup> userGroups) throws SystemException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        int i = 0;
        while (i < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i);
            List groups = this.userGroupPersistence.getGroups(userGroup.getUserGroupId());
            userGroupGroups.addAll(groups);
            ++i;
        }
        return userGroupGroups;
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException, SystemException {
        UniqueList userOrgsGroups = new UniqueList();
        List userOrgs = this.organizationLocalService.getUserOrganizations(userId, true, start, end);
        for (Organization organization : userOrgs) {
            userOrgsGroups.add(0, organization.getGroup());
            if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
            for (Organization ancestorOrganization : organization.getAncestors()) {
                userOrgsGroups.add(0, ancestorOrganization.getGroup());
            }
        }
        return userOrgsGroups;
    }

    public boolean hasRoleGroup(long roleId, long groupId) throws SystemException {
        return this.rolePersistence.containsGroup(roleId, groupId);
    }

    public boolean hasStagingGroup(long liveGroupId) throws SystemException {
        return this.groupPersistence.fetchByLiveGroupId(liveGroupId) != null;
    }

    public boolean hasUserGroup(long userId, long groupId) throws SystemException {
        return this.groupFinder.countByG_U(groupId, userId) > 0;
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, classNameIds, name, description, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        String realName = this.getRealName(companyId, name);
        return this.groupFinder.findByC_C_N_D(companyId, classNameIds, name, realName, description, params, start, end, obc);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, name, description, params, start, end, null);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        String realName = this.getRealName(companyId, name);
        return this.groupFinder.findByC_N_D(companyId, name, realName, description, params, start, end, obc);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params) throws SystemException {
        String realName = this.getRealName(companyId, name);
        return this.groupFinder.countByC_N_D(companyId, name, realName, description, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params) throws SystemException {
        String realName = this.getRealName(companyId, name);
        return this.groupFinder.countByC_C_N_D(companyId, classNameIds, name, realName, description, params);
    }

    public void setRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.setGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.removeGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroups(long userId, long[] groupIds) throws SystemException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupIds);
        this.userPersistence.removeGroups(userId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void updateAsset(long userId, Group group, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), Group.class.getName(), group.getGroupId(), null, assetCategoryIds, assetTagNames, false, null, null, null, null, null, group.getDescriptiveName(), group.getDescription(), null, null, 0, 0, null, false);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isUser()) {
            User user = this.userPersistence.findByPrimaryKey(group.getClassPK());
            friendlyURL = "/" + user.getScreenName();
            if (group.getFriendlyURL().equals(friendlyURL)) {
                return group;
            }
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, group.getClassNameId(), group.getClassPK(), "", friendlyURL);
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        group.setFriendlyURL(friendlyURL);
        this.groupPersistence.update((BaseModel)group, false);
        return group;
    }

    public Group updateGroup(long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String className = group.getClassName();
        long classNameId = group.getClassNameId();
        long classPK = group.getClassPK();
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, classNameId, classPK, "", friendlyURL);
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateName(group.getGroupId(), group.getCompanyId(), name);
        } else {
            name = String.valueOf(classPK);
        }
        if (PortalUtil.isSystemGroup((String)group.getName()) && !group.getName().equals(name)) {
            throw new RequiredGroupException();
        }
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        group.setName(name);
        group.setDescription(description);
        group.setType(type);
        group.setFriendlyURL(friendlyURL);
        group.setActive(active);
        this.groupPersistence.update((BaseModel)group, false);
        if (serviceContext != null && group.isCommunity()) {
            User user = null;
            try {
                user = this.userPersistence.findByPrimaryKey(group.getCreatorUserId());
            }
            catch (NoSuchUserException noSuchUserException) {
                try {
                    user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
                }
                catch (NoSuchUserException noSuchUserException2) {
                    user = this.userLocalService.getDefaultUser(group.getCompanyId());
                }
            }
            this.updateAsset(user.getUserId(), group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        return group;
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        group.setTypeSettings(typeSettings);
        this.groupPersistence.update((BaseModel)group, false);
        return group;
    }

    public Group updateWorkflow(long groupId, boolean workflowEnabled, int workflowStages, String workflowRoleNames) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties props = group.getTypeSettingsProperties();
        props.setProperty("workflowEnabled", String.valueOf(workflowEnabled));
        if (workflowEnabled) {
            if (workflowStages < PropsValues.TASKS_DEFAULT_STAGES) {
                workflowStages = PropsValues.TASKS_DEFAULT_STAGES;
            }
            if (Validator.isNull((String)workflowRoleNames)) {
                workflowRoleNames = PropsValues.TASKS_DEFAULT_ROLE_NAMES;
            }
            props.setProperty("workflowStages", String.valueOf(workflowStages));
            props.setProperty("workflowRoleNames", workflowRoleNames);
        }
        group.setTypeSettings(group.getTypeSettings());
        this.groupPersistence.update((BaseModel)group, false);
        if (!workflowEnabled) {
            this.tasksProposalLocalService.deleteProposals(groupId);
        }
        return group;
    }

    protected void addControlPanelLayouts(Group group) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), true, 0L, PropsValues.CONTROL_PANEL_LAYOUT_NAME, "", "", "control_panel", false, friendlyURL, serviceContext);
    }

    protected void addDefaultGuestPublicLayoutByProperties(Group group) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), false, 0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_NAME, "", "", "portlet", false, friendlyURL, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        int i = 0;
        while (i < 10) {
            String columnId = "column-" + i;
            String portletIds = PropsUtil.get("default.guest.public.layout.column-" + i);
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
            ++i;
        }
        this.layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            this.layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    protected void addDefaultGuestPublicLayouts(Group group) throws PortalException, SystemException {
        if (this.publicLARFile != null) {
            this.addDefaultGuestPublicLayoutsByLAR(group, this.publicLARFile);
        } else {
            this.addDefaultGuestPublicLayoutByProperties(group);
        }
    }

    protected void addDefaultGuestPublicLayoutsByLAR(Group group, File larFile) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        this.layoutLocalService.importLayouts(defaultUserId, group.getGroupId(), false, parameterMap, larFile);
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizer.normalize(friendlyURL);
    }

    protected String getFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyName, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(friendlyName);
            int i = 1;
            while (true) {
                try {
                    this.validateFriendlyURL(companyId, groupId, classNameId, classPK, friendlyURL);
                }
                catch (GroupFriendlyURLException gfurle) {
                    int type = gfurle.getType();
                    if (type != 6) {
                        friendlyURL = "/" + classPK;
                        break;
                    }
                    friendlyURL = String.valueOf(originalFriendlyURL) + i;
                    ++i;
                    continue;
                }
                break;
            }
        }
        return friendlyURL;
    }

    protected String getRealName(long companyId, String name) throws SystemException {
        if (Validator.isNull((String)name)) {
            return name;
        }
        String realName = name;
        try {
            Company company = this.companyLocalService.getCompany(companyId);
            Account account = company.getAccount();
            String companyName = account.getName();
            name = StringUtil.replace((String)name, (String)"%", (String)"");
            if (companyName.indexOf(name) != -1) {
                realName = "%Guest%";
            }
        }
        catch (PortalException portalException) {}
        return realName;
    }

    protected boolean isStaging(ServiceContext serviceContext) {
        if (serviceContext != null) {
            return ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging");
        }
        return false;
    }

    protected void initImportLARFile() {
        String publicLARFileName = PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected void unscheduleStaging(Group group) {
        try {
            String groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_remote_publisher", (long)group.getGroupId());
            List schedulerRequests = SchedulerEngineUtil.getScheduledJobs((String)groupName);
            for (SchedulerRequest schedulerRequest : schedulerRequests) {
                SchedulerEngineUtil.unschedule((Trigger)schedulerRequest.getTrigger());
            }
            long liveGroupId = 0L;
            long stagingGroupId = 0L;
            if (group.isStagingGroup()) {
                liveGroupId = group.getLiveGroupId();
                stagingGroupId = group.getGroupId();
            } else if (group.hasStagingGroup()) {
                liveGroupId = group.getGroupId();
                stagingGroupId = group.getStagingGroup().getGroupId();
            }
            if (liveGroupId != 0L && stagingGroupId != 0L) {
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)liveGroupId);
                schedulerRequests = SchedulerEngineUtil.getScheduledJobs((String)groupName);
                for (SchedulerRequest schedulerRequest : schedulerRequests) {
                    SchedulerEngineUtil.unschedule((Trigger)schedulerRequest.getTrigger());
                }
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)stagingGroupId);
                schedulerRequests = SchedulerEngineUtil.getScheduledJobs((String)groupName);
                for (SchedulerRequest schedulerRequest : schedulerRequests) {
                    SchedulerEngineUtil.unschedule((Trigger)schedulerRequest.getTrigger());
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to unschedule events for group: " + group.getGroupId()));
        }
    }

    protected void validateFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyURL) throws PortalException, SystemException {
        long userClassNameId;
        long groupClassNameId;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new GroupFriendlyURLException(exceptionType);
        }
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getGroupId() != groupId) {
            throw new GroupFriendlyURLException(6);
        }
        String groupIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)groupIdFriendlyURL) && (classNameId != (groupClassNameId = PortalUtil.getClassNameId(Group.class)) && !groupIdFriendlyURL.equals(String.valueOf(classPK)) && !PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC || classNameId == groupClassNameId && !groupIdFriendlyURL.equals(String.valueOf(groupId)))) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(8);
            gfurle.setKeywordConflict(groupIdFriendlyURL);
            throw gfurle;
        }
        String screenName = friendlyURL.substring(1);
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && (classNameId != (userClassNameId = PortalUtil.getClassNameId(User.class)) || classPK != user.getUserId())) {
            throw new GroupFriendlyURLException(6);
        }
        if (StringUtil.count((String)friendlyURL, (String)"/") > 1) {
            throw new GroupFriendlyURLException(9);
        }
    }

    protected void validateName(long groupId, long companyId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(42) != -1) {
            throw new GroupNameException();
        }
        try {
            Group group = this.groupFinder.findByC_N(companyId, name);
            if (groupId <= 0L || group.getGroupId() != groupId) {
                throw new DuplicateGroupException();
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {}
    }
}

