/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.TeamServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;

public class TeamServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceHttp.class);

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class.getName(), "addTeam", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class.getName(), "deleteTeam", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team updateTeam(HttpPrincipal httpPrincipal, long teamId, String name, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class.getName(), "updateTeam", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

