/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletLuceneComparator;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;

public class LuceneIndexer
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexer.class);
    private long _companyId;
    private boolean _finished;

    public LuceneIndexer(long companyId) {
        this._companyId = companyId;
    }

    public void halt() {
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void run() {
        this.reindex(PropsValues.INDEX_ON_STARTUP_DELAY);
    }

    public void reindex() {
        this.reindex(0);
    }

    public void reindex(int delay) {
        ShardUtil.pushCompanyService((long)this._companyId);
        try {
            this.doReIndex(delay);
        }
        finally {
            ShardUtil.popCompanyService();
        }
    }

    protected void doReIndex(int delay) {
        block13: {
            if (SearchEngineUtil.isIndexReadOnly()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reindexing Lucene started");
            }
            if (delay < 0) {
                delay = 0;
            }
            try {
                if (delay > 0) {
                    Thread.sleep(1000L * (long)delay);
                }
            }
            catch (InterruptedException interruptedException) {}
            StopWatch stopWatch1 = null;
            if (_log.isInfoEnabled()) {
                stopWatch1 = new StopWatch();
                stopWatch1.start();
            }
            try {
                LuceneHelperUtil.delete(this._companyId);
                List portlets = PortletLocalServiceUtil.getPortlets((long)this._companyId);
                portlets = ListUtil.sort((List)portlets, (Comparator)new PortletLuceneComparator());
                for (Portlet portlet : portlets) {
                    Indexer indexer;
                    if (!portlet.isActive() || (indexer = portlet.getIndexerInstance()) == null) continue;
                    String indexerClass = portlet.getIndexerClass();
                    StopWatch stopWatch2 = null;
                    if (_log.isInfoEnabled()) {
                        stopWatch2 = new StopWatch();
                        stopWatch2.start();
                    }
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Reindexing with " + indexerClass + " started"));
                    }
                    indexer.reindex(new String[]{String.valueOf(this._companyId)});
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Reindexing with " + indexerClass + " completed in " + stopWatch2.getTime() / 1000L + " seconds"));
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Reindexing Lucene completed in " + stopWatch1.getTime() / 1000L + " seconds"));
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error encountered while reindexing", (Throwable)e);
                if (!_log.isInfoEnabled()) break block13;
                _log.info((Object)"Reindexing Lucene failed");
            }
        }
        this._finished = true;
    }
}

