/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz;

import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.CronTrigger;
import com.liferay.portal.kernel.scheduler.IntervalTrigger;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.scheduler.job.MessageSenderJob;
import com.liferay.portal.service.QuartzLocalService;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulerEngineImpl
implements SchedulerEngine {
    @BeanReference(name="com.liferay.portal.service.QuartzLocalService")
    protected QuartzLocalService quartzLocalService;
    private Log _log = LogFactoryUtil.getLog(QuartzSchedulerEngineImpl.class);
    private Scheduler _scheduler;

    public void afterPropertiesSet() {
        try {
            if (!PropsValues.SCHEDULER_ENABLED) {
                return;
            }
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            schedulerFactory.initialize(PropsUtil.getProperties("org.quartz.", false));
            this.quartzLocalService.checkQuartzTables();
            this._scheduler = schedulerFactory.getScheduler();
        }
        catch (Exception e) {
            this._log.error((Object)"Unable to initialize engine", (Throwable)e);
        }
    }

    public List<SchedulerRequest> getScheduledJobs(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return new ArrayList<SchedulerRequest>();
        }
        try {
            String[] jobNames = this._scheduler.getJobNames(groupName);
            ArrayList<SchedulerRequest> requests = new ArrayList<SchedulerRequest>();
            String[] stringArray = jobNames;
            int n = jobNames.length;
            int n2 = 0;
            while (n2 < n) {
                String jobName = stringArray[n2];
                JobDetail jobDetail = this._scheduler.getJobDetail(jobName, groupName);
                if (jobDetail != null) {
                    JobDataMap jobDataMap = jobDetail.getJobDataMap();
                    String description = jobDataMap.getString("description");
                    Message message = (Message)jobDataMap.get((Object)"message");
                    SchedulerRequest schedulerRequest = null;
                    org.quartz.Trigger trigger = this._scheduler.getTrigger(jobName, groupName);
                    if (org.quartz.CronTrigger.class.isAssignableFrom(trigger.getClass())) {
                        org.quartz.CronTrigger cronTrigger = (org.quartz.CronTrigger)org.quartz.CronTrigger.class.cast(trigger);
                        schedulerRequest = SchedulerRequest.createRetrieveResponseRequest((Trigger)new CronTrigger(jobName, groupName, cronTrigger.getStartTime(), cronTrigger.getEndTime(), cronTrigger.getCronExpression()), (String)description, (Message)message);
                    } else if (SimpleTrigger.class.isAssignableFrom(trigger.getClass())) {
                        SimpleTrigger simpleTrigger = (SimpleTrigger)SimpleTrigger.class.cast(trigger);
                        schedulerRequest = SchedulerRequest.createRetrieveResponseRequest((Trigger)new IntervalTrigger(jobName, groupName, simpleTrigger.getStartTime(), simpleTrigger.getEndTime(), simpleTrigger.getRepeatInterval()), (String)description, (Message)message);
                    }
                    if (schedulerRequest != null) {
                        requests.add(schedulerRequest);
                    }
                }
                ++n2;
            }
            return requests;
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to retrieve job", (Throwable)se);
        }
    }

    public void schedule(Trigger trigger, String description, String destination, Message message) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            String jobName = trigger.getJobName();
            String groupName = trigger.getGroupName();
            if (jobName.length() > 80) {
                jobName = jobName.substring(0, 80);
            }
            if (groupName.length() > 80) {
                groupName = groupName.substring(0, 80);
            }
            org.quartz.CronTrigger quartzTrigger = null;
            if (trigger.getTriggerType() == TriggerType.CRON) {
                try {
                    quartzTrigger = new org.quartz.CronTrigger(jobName, groupName, (String)trigger.getTriggerContent());
                }
                catch (ParseException parseException) {
                    throw new SchedulerException("Unable to parse cron text " + trigger.getTriggerContent());
                }
            } else if (trigger.getTriggerType() == TriggerType.SIMPLE) {
                long interval = (Long)trigger.getTriggerContent();
                if (interval <= 0L) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Not scheduling " + trigger.getJobName() + " because interval is less than or equal to 0"));
                    }
                    return;
                }
                quartzTrigger = new SimpleTrigger(jobName, groupName, -1, interval);
            } else {
                throw new SchedulerException("Unknown trigger type " + trigger.getTriggerType());
            }
            quartzTrigger.setJobName(jobName);
            quartzTrigger.setJobGroup(groupName);
            Date startDate = trigger.getStartDate();
            if (startDate == null) {
                if (ServerDetector.getServerId().equals("tomcat")) {
                    quartzTrigger.setStartTime(new Date(System.currentTimeMillis() + 60000L));
                } else {
                    quartzTrigger.setStartTime(new Date(System.currentTimeMillis() + 180000L));
                }
            } else {
                quartzTrigger.setStartTime(startDate);
            }
            Date endDate = trigger.getEndDate();
            if (endDate != null) {
                quartzTrigger.setEndTime(endDate);
            }
            if (description != null && description.length() > 120) {
                description = description.substring(0, 120);
            }
            if (message == null) {
                message = new Message();
            }
            message.put("receiver_key", (Object)jobName.concat(":").concat(groupName));
            this.schedule((org.quartz.Trigger)quartzTrigger, description, destination, message);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void shutdown() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._scheduler.shutdown(false);
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)se);
        }
    }

    public void start() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._scheduler.start();
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to start scheduler", (Throwable)se);
        }
    }

    public void unschedule(Trigger trigger) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        String jobName = trigger.getJobName();
        String groupName = trigger.getGroupName();
        try {
            this._scheduler.unscheduleJob(jobName, groupName);
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to unschedule job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(org.quartz.Trigger trigger, String description, String destination, Message message) throws SchedulerException {
        try {
            String jobName = trigger.getName();
            String groupName = trigger.getGroup();
            JobDetail jobDetail = new JobDetail(jobName, groupName, MessageSenderJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put("description", description);
            jobDataMap.put("destination", destination);
            jobDataMap.put((Object)"message", (Object)message);
            QuartzSchedulerEngineImpl quartzSchedulerEngineImpl = this;
            synchronized (quartzSchedulerEngineImpl) {
                this._scheduler.unscheduleJob(jobName, groupName);
                this._scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)"Message is already scheduled");
            }
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to scheduled job", (Throwable)se);
        }
    }
}

