/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.SpriteImage;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.PluginBaseImpl;
import com.liferay.portal.theme.ThemeCompanyLimit;
import com.liferay.portal.theme.ThemeGroupLimit;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeImpl
extends PluginBaseImpl
implements Theme {
    private static Log _log = LogFactoryUtil.getLog(ThemeImpl.class);
    private String _themeId;
    private ThemeCompanyLimit _themeCompanyLimit;
    private ThemeGroupLimit _themeGroupLimit;
    private long _timestamp;
    private String _name;
    private String _rootPath = "/";
    private String _templatesPath = "${root-path}/templates";
    private String _cssPath = "${root-path}/css";
    private String _imagesPath = "${root-path}/images";
    private String _javaScriptPath = "${root-path}/js";
    private String _virtualPath = "";
    private String _templateExtension = "vm";
    private Properties _settings = new Properties();
    private boolean _wapTheme;
    private Map<String, ColorScheme> _colorSchemesMap = new HashMap<String, ColorScheme>();
    private Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private String _servletContextName = "";
    private boolean _warFile;
    private boolean _loadFromServletContext;

    public static String getDefaultRegularThemeId() {
        return PortalUtil.getJsSafePortletId((String)PropsValues.DEFAULT_REGULAR_THEME_ID);
    }

    public static String getDefaultRegularThemeId(long companyId) throws SystemException {
        String defaultRegularThemeId = PrefsPropsUtil.getString(companyId, "default.regular.theme.id");
        return PortalUtil.getJsSafePortletId((String)defaultRegularThemeId);
    }

    public static String getDefaultWapThemeId() {
        return PortalUtil.getJsSafePortletId((String)PropsValues.DEFAULT_WAP_THEME_ID);
    }

    public static String getDefaultWapThemeId(long companyId) throws SystemException {
        String defaultWapThemeId = PrefsPropsUtil.getString(companyId, "default.wap.theme.id");
        return PortalUtil.getJsSafePortletId((String)defaultWapThemeId);
    }

    public ThemeImpl() {
    }

    public ThemeImpl(String themeId) {
        this._themeId = themeId;
    }

    public ThemeImpl(String themeId, String name) {
        this._themeId = themeId;
        this._name = name;
    }

    public String getThemeId() {
        return this._themeId;
    }

    public String getPluginId() {
        return this.getThemeId();
    }

    public String getPluginType() {
        return "theme";
    }

    public ThemeCompanyLimit getThemeCompanyLimit() {
        return this._themeCompanyLimit;
    }

    public void setThemeCompanyLimit(ThemeCompanyLimit themeCompanyLimit) {
        this._themeCompanyLimit = themeCompanyLimit;
    }

    public boolean isCompanyAvailable(long companyId) {
        return this.isAvailable(this.getThemeCompanyLimit(), companyId);
    }

    public ThemeGroupLimit getThemeGroupLimit() {
        return this._themeGroupLimit;
    }

    public void setThemeGroupLimit(ThemeGroupLimit themeGroupLimit) {
        this._themeGroupLimit = themeGroupLimit;
    }

    public boolean isGroupAvailable(long groupId) {
        return this.isAvailable((ThemeCompanyLimit)this.getThemeGroupLimit(), groupId);
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    public String getTemplatesPath() {
        return this._templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this._templatesPath = templatesPath;
    }

    public String getCssPath() {
        return this._cssPath;
    }

    public void setCssPath(String cssPath) {
        this._cssPath = cssPath;
    }

    public String getImagesPath() {
        return this._imagesPath;
    }

    public void setImagesPath(String imagesPath) {
        this._imagesPath = imagesPath;
    }

    public String getJavaScriptPath() {
        return this._javaScriptPath;
    }

    public void setJavaScriptPath(String javaScriptPath) {
        this._javaScriptPath = javaScriptPath;
    }

    public String getVirtualPath() {
        return this._virtualPath;
    }

    public void setVirtualPath(String virtualPath) {
        if (this._warFile && Validator.isNull((String)virtualPath)) {
            virtualPath = PropsValues.THEME_VIRTUAL_PATH;
        }
        this._virtualPath = virtualPath;
    }

    public String getTemplateExtension() {
        return this._templateExtension;
    }

    public void setTemplateExtension(String templateExtension) {
        this._templateExtension = templateExtension;
    }

    public Properties getSettings() {
        return this._settings;
    }

    public String getSetting(String key) {
        return this._settings.getProperty(key);
    }

    public void setSetting(String key, String value) {
        this._settings.setProperty(key, value);
    }

    public boolean getWapTheme() {
        return this._wapTheme;
    }

    public boolean isWapTheme() {
        return this._wapTheme;
    }

    public void setWapTheme(boolean wapTheme) {
        this._wapTheme = wapTheme;
    }

    public List<ColorScheme> getColorSchemes() {
        List colorSchemes = ListUtil.fromCollection(this._colorSchemesMap.values());
        return ListUtil.sort((List)colorSchemes);
    }

    public Map<String, ColorScheme> getColorSchemesMap() {
        return this._colorSchemesMap;
    }

    public boolean hasColorSchemes() {
        return this._colorSchemesMap.size() > 0;
    }

    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    public void setSpriteImages(String spriteFileName, Properties spriteProperties) {
        for (Map.Entry<Object, Object> entry : spriteProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split((String)value, (int)0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull((String)this._servletContextName);
    }

    public boolean getWARFile() {
        return this._warFile;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public String getContextPath() {
        String virtualPath = this.getVirtualPath();
        if (Validator.isNotNull((String)virtualPath)) {
            return virtualPath;
        }
        if (this.isWARFile()) {
            return "/".concat(this.getServletContextName());
        }
        return PortalUtil.getPathContext();
    }

    public String getFreeMarkerTemplateLoader() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public boolean getLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public boolean isLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public void setLoadFromServletContext(boolean loadFromServletContext) {
        this._loadFromServletContext = loadFromServletContext;
    }

    public String getVelocityResourceListener() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public int compareTo(Theme theme) {
        return this.getName().compareTo(theme.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Theme theme = null;
        try {
            theme = (Theme)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        String themeId = theme.getThemeId();
        return this.getThemeId().equals(themeId);
    }

    public int hashCode() {
        return this._themeId.hashCode();
    }

    protected boolean isAvailable(ThemeCompanyLimit limit, long id) {
        boolean available = true;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check if theme " + this.getThemeId() + " is available for " + id));
        }
        if (limit != null) {
            List includes = limit.getIncludes();
            List excludes = limit.getExcludes();
            if (includes.size() != 0 && excludes.size() != 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes and excludes");
                }
                if (available = limit.isIncluded(id)) {
                    available = !limit.isExcluded(id);
                }
            } else if (includes.size() == 0 && excludes.size() != 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check excludes");
                }
                available = !limit.isExcluded(id);
            } else if (includes.size() != 0 && excludes.size() == 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes");
                }
                available = limit.isIncluded(id);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"No includes or excludes set");
                }
                available = true;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Theme " + this.getThemeId() + " is " + (!available ? "NOT " : "") + "available for " + id));
        }
        return available;
    }
}

