/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.util.MethodTargetClassKey;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalCacheAdvice
extends AnnotationChainableMethodAdvice<ThreadLocalCachable> {
    private static ThreadLocalCachable _nullThreadLocalCacheable = new ThreadLocalCachable(){

        public Class<? extends Annotation> annotationType() {
            return ThreadLocalCachable.class;
        }

        public Lifecycle scope() {
            return null;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        MethodTargetClassKey methodTargetClassKey = this.buildMethodTargetClassKey(methodInvocation);
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)this.findAnnotation(methodTargetClassKey);
        if (threadLocalCachable == _nullThreadLocalCacheable) {
            return;
        }
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)threadLocalCachable.scope(), (String)methodTargetClassKey.toString());
        String cacheKey = this._buildCacheKey(methodInvocation.getArguments());
        if (result == null) {
            threadLocalCache.put(cacheKey, this.nullResult);
        } else {
            threadLocalCache.put(cacheKey, result);
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        String cacheKey;
        MethodTargetClassKey methodTargetClassKey = this.buildMethodTargetClassKey(methodInvocation);
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)this.findAnnotation(methodTargetClassKey);
        if (threadLocalCachable == _nullThreadLocalCacheable) {
            return null;
        }
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)threadLocalCachable.scope(), (String)methodTargetClassKey.toString());
        Object value = threadLocalCache.get(cacheKey = this._buildCacheKey(methodInvocation.getArguments()));
        if (value == this.nullResult) {
            return null;
        }
        return value;
    }

    @Override
    public ThreadLocalCachable getNullAnnotation() {
        return _nullThreadLocalCacheable;
    }

    private String _buildCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        int i = 0;
        while (i < arguments.length) {
            sb.append(String.valueOf(arguments[i]));
            if (i + 1 < arguments.length) {
                sb.append("#");
            }
            ++i;
        }
        return sb.toString();
    }
}

